/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.annotation.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Reflections {
    private Reflections() {
    }

    public static List<Method> getObserverMethods(Class<?> clazz) {
        ArrayList<Method> observerMethods = new ArrayList<Method>();
        if (clazz == null) {
            return observerMethods;
        }
        for (Method method : clazz.getMethods()) {
            if (!Reflections.isObserverMethod(method)) continue;
            observerMethods.add(method);
        }
        observerMethods.addAll(Reflections.getObserverMethods(clazz.getSuperclass()));
        return observerMethods;
    }

    public static List<Field> getFieldInjectionPoints(Class<?> clazz) {
        ArrayList<Field> injectionPoints = new ArrayList<Field>();
        if (clazz == null) {
            return injectionPoints;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!Reflections.isInjectionPoint(field)) continue;
            injectionPoints.add(field);
        }
        injectionPoints.addAll(Reflections.getFieldInjectionPoints(clazz.getSuperclass()));
        return injectionPoints;
    }

    public static List<Field> getEventPoints(Class<?> clazz) {
        ArrayList<Field> eventPoints = new ArrayList<Field>();
        if (clazz == null) {
            return eventPoints;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!Reflections.isEventPoint(field)) continue;
            eventPoints.add(field);
        }
        eventPoints.addAll(Reflections.getEventPoints(clazz.getSuperclass()));
        return eventPoints;
    }

    public static Class<? extends Annotation> getScope(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(Scope.class)) continue;
            return annotationType;
        }
        return null;
    }

    public static <T> T createInstance(Class<T> clazz) throws Exception {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(new Object[0]);
    }

    public static boolean isType(Type type, Class<?> clazz) {
        if (type instanceof Class) {
            return (Class)type == clazz;
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType() == clazz;
        }
        return false;
    }

    public static Class<?> getType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Reflections.getType(((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        if (type instanceof WildcardType) {
            for (Type wildType : ((WildcardType)type).getUpperBounds()) {
                Class<?> upperType = Reflections.getType(wildType);
                if (upperType == null) continue;
                return Reflections.getType(upperType);
            }
            for (Type wildType : ((WildcardType)type).getLowerBounds()) {
                Class<?> lowerType = Reflections.getType(wildType);
                if (lowerType == null) continue;
                return Reflections.getType(lowerType);
            }
        }
        return null;
    }

    private static boolean isEventPoint(Field field) {
        return field.isAnnotationPresent(Inject.class) && field.getType() == Event.class;
    }

    private static boolean isInjectionPoint(Field field) {
        if (field.isAnnotationPresent(Inject.class)) {
            if (field.getType() == Instance.class) {
                return true;
            }
            if (field.getType() == InstanceProducer.class) {
                if (Reflections.getScope(field) != null) {
                    return true;
                }
                throw new RuntimeException("A InjectionPoint of type " + InstanceProducer.class.getName() + " must define a " + Scope.class.getName() + " annotation, bad definition for field: " + field);
            }
        }
        return false;
    }

    private static boolean isObserverMethod(Method method) {
        if (method.getParameterTypes().length < 1 || method.getParameterAnnotations().length < 1) {
            return false;
        }
        return Reflections.containsAnnotation(Observes.class, method.getParameterAnnotations()[0]);
    }

    private static boolean containsAnnotation(Class<? extends Annotation> match, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != match) continue;
            return true;
        }
        return false;
    }
}

