/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl.loadable;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.arquillian.core.impl.loadable.SecurityActions;
import org.jboss.arquillian.core.spi.ExtensionLoader;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.core.spi.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSPIExtensionLoader
implements ExtensionLoader {
    private static final String SERVICES = "META-INF/services";

    public Collection<LoadableExtension> load() {
        return this.all(JavaSPIExtensionLoader.class.getClassLoader(), LoadableExtension.class);
    }

    public <T> Collection<T> all(ClassLoader classLoader, Class<T> serviceClass) {
        Validate.notNull((Object)classLoader, (String)"ClassLoader must be provided");
        Validate.notNull(serviceClass, (String)"ServiceClass must be provided");
        return this.createInstances(serviceClass, this.load(serviceClass, classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<Class<? extends T>> load(Class<T> serviceClass, ClassLoader loader) {
        String serviceFile = "META-INF/services/" + serviceClass.getName();
        LinkedHashSet<Class<T>> providers = new LinkedHashSet<Class<T>>();
        LinkedHashSet<Class<T>> vetoedProviders = new LinkedHashSet<Class<T>>();
        try {
            Enumeration<URL> enumeration = loader.getResources(serviceFile);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream is = url.openStream();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = reader.readLine();
                    while (null != line) {
                        if ((line = this.skipCommentAndTrim(line)).length() > 0) {
                            try {
                                boolean mustBeVetoed = line.startsWith("!");
                                if (mustBeVetoed) {
                                    line = line.substring(1);
                                }
                                Class<T> provider = loader.loadClass(line).asSubclass(serviceClass);
                                if (mustBeVetoed) {
                                    vetoedProviders.add(provider);
                                }
                                if (vetoedProviders.contains(provider)) {
                                    providers.remove(provider);
                                } else {
                                    providers.add(provider);
                                }
                            }
                            catch (ClassCastException e) {
                                throw new IllegalStateException("Service " + line + " does not implement expected type " + serviceClass.getName());
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load services for " + serviceClass.getName(), e);
        }
        return providers;
    }

    private String skipCommentAndTrim(String line) {
        int comment = line.indexOf(35);
        if (comment > -1) {
            line = line.substring(0, comment);
        }
        line = line.trim();
        return line;
    }

    private <T> T createInstance(Class<? extends T> serviceImplClass) {
        try {
            Constructor<T> constructor = SecurityActions.getConstructor(serviceImplClass, new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new instance of Service implementation " + serviceImplClass.getName(), e);
        }
    }

    private <T> Set<T> createInstances(Class<T> serviceType, Set<Class<? extends T>> providers) {
        LinkedHashSet<T> providerImpls = new LinkedHashSet<T>();
        for (Class<T> clazz : providers) {
            providerImpls.add(this.createInstance(clazz));
        }
        return providerImpls;
    }
}

