/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl.loadable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.impl.loadable.SecurityActions;
import org.jboss.arquillian.core.impl.loadable.ServiceRegistry;
import org.jboss.arquillian.core.spi.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistryLoader
implements ServiceLoader {
    private Injector injector;
    private ServiceRegistry registry;

    public ServiceRegistryLoader(Injector injector, ServiceRegistry registry) {
        this.injector = injector;
        this.registry = registry;
    }

    public <T> Collection<T> all(Class<T> serviceClass) {
        ArrayList<T> serviceImpls = new ArrayList<T>();
        Set<Class<T>> serviceImplClasses = this.registry.getServiceImpls(serviceClass);
        for (Class<T> serviceImplClass : serviceImplClasses) {
            T serviceImpl = this.createServiceInstance(serviceImplClass);
            serviceImpls.add(serviceImpl);
        }
        return serviceImpls;
    }

    public <T> T onlyOne(Class<T> serviceClass) {
        Collection<T> all = this.all(serviceClass);
        if (all.size() == 1) {
            return all.iterator().next();
        }
        if (all.size() > 1) {
            throw new IllegalStateException("Multiple service implementations found for " + serviceClass + ". " + this.toClassString(all));
        }
        return null;
    }

    public <T> T onlyOne(Class<T> serviceClass, Class<? extends T> defaultServiceClass) {
        T one = null;
        try {
            one = this.onlyOne(serviceClass);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (one == null) {
            one = this.createServiceInstance(defaultServiceClass);
        }
        return one;
    }

    private <T> T createServiceInstance(Class<T> service) {
        T serviceInst = SecurityActions.newInstance(service, new Class[0], new Object[0]);
        this.injector.inject(serviceInst);
        return serviceInst;
    }

    private <T> String toClassString(Collection<T> providers) {
        StringBuilder sb = new StringBuilder();
        for (T provider : providers) {
            sb.append(provider.getClass().getName()).append(", ");
        }
        return ((Object)sb.subSequence(0, sb.length() - 2)).toString();
    }
}

