/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.graphicImage;

import java.io.IOException;
import javax.faces.component.UIComponentBase;
import org.jboss.seam.ui.graphicImage.Image;
import org.jboss.seam.ui.graphicImage.ImageTransform;
import org.richfaces.cdk.annotations.Attribute;

public abstract class UITransformImageSize
extends UIComponentBase
implements ImageTransform {
    @Override
    public void applyTransform(Image image) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (this.isMaintainRatio()) {
            if (this.getWidth() != null && this.getHeight() != null) {
                throw new UnsupportedOperationException("Cannot maintain ratio and specify height and width");
            }
            if (this.getWidth() != null) {
                image.scaleToWidth(new Integer(this.getWidth()));
            } else if (this.getHeight() != null) {
                image.scaleToHeight(new Integer(this.getHeight()));
            }
        } else if (this.getFactor() != null) {
            if (this.getWidth() != null || this.getHeight() != null) {
                throw new UnsupportedOperationException("Cannot scale by a factor and specify height and width");
            }
            image.scale(this.getFactor());
        } else {
            if (this.getWidth() == null || this.getHeight() == null) {
                throw new UnsupportedOperationException("If not specifying a factor or maintain ratio you must specify width and heigh");
            }
            image.resize(new Integer(this.getWidth()), new Integer(this.getHeight()));
        }
    }

    @Attribute
    public abstract boolean isMaintainRatio();

    public abstract void setMaintainRatio(boolean var1);

    @Attribute
    public abstract Integer getWidth();

    public abstract void setWidth(Integer var1);

    @Attribute
    public abstract Integer getHeight();

    public abstract void setHeight(Integer var1);

    @Attribute
    public abstract Double getFactor();

    public abstract void setFactor(Double var1);
}

