/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.richfaces.model.SequenceRowKey;

public class SequenceRowKeyConverter<T>
implements Converter {
    static final Splitter SEPARATOR_SPLITTER = Splitter.on((char)'.');
    private Class<T> clazz;
    private Converter delegateConverter;

    public SequenceRowKeyConverter(Class<T> clazz, Converter delegateConverter) {
        this.clazz = clazz;
        this.delegateConverter = delegateConverter;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        Iterable split = SEPARATOR_SPLITTER.split((CharSequence)value);
        ArrayList keysList = Lists.newArrayList();
        for (String s : split) {
            T convertedKey = this.clazz.cast(this.delegateConverter.getAsObject(context, component, s));
            keysList.add(convertedKey);
        }
        return new SequenceRowKey(keysList.toArray(ObjectArrays.newArray(this.clazz, (int)keysList.size())));
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "";
        }
        SequenceRowKey sequenceRowKey = (SequenceRowKey)value;
        StringBuilder result = new StringBuilder();
        for (Object simpleKey : sequenceRowKey.getSimpleKeys()) {
            String convertedKey = this.delegateConverter.getAsString(context, component, simpleKey);
            if (result.length() > 0) {
                result.append('.');
            }
            result.append(convertedKey);
        }
        return result.toString();
    }
}

