/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.yui.calendar;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.datetime.StyleDateConverter;
import org.apache.wicket.datetime.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converters.ZeroPaddingIntegerConverter;
import org.apache.wicket.util.lang.EnumeratedType;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeField
extends FormComponentPanel<Date> {
    private static final IConverter MINUTES_CONVERTER = new ZeroPaddingIntegerConverter(2);
    private static final long serialVersionUID = 1L;
    private AM_PM amOrPm = AM_PM.AM;
    private DropDownChoice<AM_PM> amOrPmChoice;
    private MutableDateTime date;
    private DateTextField dateField;
    private Integer hours;
    private TextField<Integer> hoursField;
    private Integer minutes;
    private TextField<Integer> minutesField;

    public DateTimeField(String id) {
        this(id, null);
    }

    public DateTimeField(String id, IModel<Date> model) {
        super(id, model);
        this.setType(Date.class);
        PropertyModel dateFieldModel = new PropertyModel((Object)this, "date");
        Component[] componentArray = new Component[1];
        this.dateField = this.newDateTextField("date", dateFieldModel);
        componentArray[0] = this.dateField;
        this.add(componentArray);
        this.dateField.add(new IBehavior[]{this.newDatePicker()});
        Component[] componentArray2 = new Component[1];
        this.hoursField = new TextField("hours", (IModel)new PropertyModel((Object)this, "hours"), Integer.class);
        componentArray2[0] = this.hoursField;
        this.add(componentArray2);
        this.hoursField.add((IValidator)new HoursValidator());
        this.hoursField.setLabel((IModel)new Model((Serializable)((Object)"hours")));
        Component[] componentArray3 = new Component[1];
        this.minutesField = new TextField<Integer>("minutes", (IModel)new PropertyModel((Object)this, "minutes"), Integer.class){
            private static final long serialVersionUID = 1L;

            public IConverter getConverter(Class type) {
                return MINUTES_CONVERTER;
            }
        };
        componentArray3[0] = this.minutesField;
        this.add(componentArray3);
        this.minutesField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(59)));
        this.minutesField.setLabel((IModel)new Model((Serializable)((Object)"minutes")));
        Component[] componentArray4 = new Component[1];
        this.amOrPmChoice = new DropDownChoice("amOrPmChoice", (IModel)new PropertyModel((Object)this, "amOrPm"), Arrays.asList(AM_PM.values()));
        componentArray4[0] = this.amOrPmChoice;
        this.add(componentArray4);
    }

    public AM_PM getAmOrPm() {
        return this.amOrPm;
    }

    public Date getDate() {
        return this.date != null ? this.date.toDate() : null;
    }

    public Integer getHours() {
        return this.hours;
    }

    protected void configure(Map widgetProperties) {
    }

    public String getInput() {
        return this.dateField.getInput() + ", " + this.hoursField.getInput() + ":" + this.minutesField.getInput();
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public void setAmOrPm(AM_PM amOrPm) {
        this.amOrPm = amOrPm;
    }

    public void setDate(Date date) {
        if (date == null) {
            this.date = null;
            this.setDefaultModelObject(null);
            this.setHours(null);
            this.setMinutes(null);
            return;
        }
        this.date = new MutableDateTime((Object)date);
        this.setDefaultModelObject(date);
        Integer hours = this.getHours();
        Integer minutes = this.getMinutes();
        boolean use12HourFormat = this.use12HourFormat();
        if (hours != null) {
            this.date.set(DateTimeFieldType.hourOfDay(), hours % (use12HourFormat ? 12 : 24));
            this.date.setMinuteOfHour(minutes != null ? minutes : 0);
        }
        this.setDefaultModelObject(this.date.toDate());
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    public void setMinutes(Integer minutes) {
        this.minutes = minutes;
    }

    protected TimeZone getClientTimeZone() {
        ClientInfo info = Session.get().getClientInfo();
        if (info instanceof WebClientInfo) {
            return ((WebClientInfo)info).getProperties().getTimeZone();
        }
        return null;
    }

    protected void convertInput() {
        Object dateFieldInput = this.dateField.getConvertedInput();
        if (dateFieldInput != null) {
            MutableDateTime date = new MutableDateTime(dateFieldInput);
            Integer hours = (Integer)this.hoursField.getConvertedInput();
            Integer minutes = (Integer)this.minutesField.getConvertedInput();
            AM_PM amOrPm = (AM_PM)((Object)this.amOrPmChoice.getConvertedInput());
            try {
                TimeZone zone;
                boolean use12HourFormat = this.use12HourFormat();
                if (hours != null) {
                    date.set(DateTimeFieldType.hourOfDay(), hours % this.getMaximumHours(use12HourFormat));
                    date.setMinuteOfHour(minutes != null ? minutes : 0);
                }
                if (use12HourFormat) {
                    date.set(DateTimeFieldType.halfdayOfDay(), amOrPm == AM_PM.PM ? 1 : 0);
                }
                if ((zone = this.getClientTimeZone()) != null) {
                    date.setMillis(this.getMillis(zone, TimeZone.getDefault(), date.getMillis()));
                }
                this.setConvertedInput(date.toDate());
            }
            catch (RuntimeException e) {
                this.error((Serializable)((Object)e.getMessage()));
                this.invalid();
            }
        } else {
            this.setConvertedInput(null);
        }
    }

    private long getMillis(TimeZone to, TimeZone from, long instant) {
        return DateTimeZone.forTimeZone((TimeZone)from).getMillisKeepLocal(DateTimeZone.forTimeZone((TimeZone)to), instant);
    }

    @Deprecated
    protected final DateTextField newDateTextField(PropertyModel dateFieldModel) {
        throw new UnsupportedOperationException();
    }

    protected DateTextField newDateTextField(String id, PropertyModel dateFieldModel) {
        return new DateTextField(id, (IModel<Date>)dateFieldModel, new StyleDateConverter(false));
    }

    protected void onBeforeRender() {
        this.dateField.setRequired(this.isRequired());
        this.hoursField.setRequired(this.isRequired());
        this.minutesField.setRequired(this.isRequired());
        boolean use12HourFormat = this.use12HourFormat();
        this.amOrPmChoice.setVisible(use12HourFormat);
        Date d = (Date)this.getDefaultModelObject();
        if (d != null) {
            this.date = new MutableDateTime((Object)d);
        } else {
            this.date = null;
            this.hours = null;
            this.minutes = null;
        }
        if (this.date != null) {
            int hourOfHalfDay;
            TimeZone zone = this.getClientTimeZone();
            if (zone != null) {
                this.date.setMillis(this.getMillis(TimeZone.getDefault(), zone, this.date.getMillis()));
            }
            this.hours = use12HourFormat ? new Integer((hourOfHalfDay = this.date.get(DateTimeFieldType.hourOfHalfday())) == 0 ? 12 : hourOfHalfDay) : new Integer(this.date.get(DateTimeFieldType.hourOfDay()));
            this.amOrPm = this.date.get(DateTimeFieldType.halfdayOfDay()) == 0 ? AM_PM.AM : AM_PM.PM;
            this.minutes = new Integer(this.date.getMinuteOfHour());
        }
        super.onBeforeRender();
    }

    protected boolean use12HourFormat() {
        String pattern = DateTimeFormat.patternForStyle((String)"-S", (Locale)this.getLocale());
        return pattern.indexOf(97) != -1 || pattern.indexOf(104) != -1 || pattern.indexOf(75) != -1;
    }

    private int getMaximumHours() {
        return this.getMaximumHours(this.use12HourFormat());
    }

    private int getMaximumHours(boolean use12HourFormat) {
        return use12HourFormat ? 12 : 24;
    }

    protected DatePicker newDatePicker() {
        return new DatePicker(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void configure(Map<String, Object> widgetProperties) {
                super.configure(widgetProperties);
                DateTimeField.this.configure(widgetProperties);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HoursValidator
    extends RangeValidator<Integer> {
        private static final long serialVersionUID = 1L;

        public HoursValidator() {
            if (DateTimeField.this.getMaximumHours() == 24) {
                this.setRange(Integer.valueOf(0), Integer.valueOf(23));
            } else {
                this.setRange(Integer.valueOf(1), Integer.valueOf(12));
            }
        }
    }

    private static class AM_PM
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;
        static final AM_PM AM = new AM_PM("AM");
        static final AM_PM PM = new AM_PM("PM");

        public static AM_PM[] values() {
            return new AM_PM[]{AM, PM};
        }

        private AM_PM(String name) {
            super(name);
        }
    }
}

