/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.drools;

import java.io.Serializable;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.event.AgendaEventListener;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.event.process.ProcessEventListener;
import org.drools.spi.GlobalResolver;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.drools.SeamGlobalResolver;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Scope(value=ScopeType.CONVERSATION)
@BypassInterceptors
public class ManagedWorkingMemory
implements Mutable,
Serializable {
    private static final long serialVersionUID = -1746942080571374743L;
    private static final LogProvider log = Logging.getLogProvider(ManagedWorkingMemory.class);
    private String ruleBaseName;
    private String[] eventListeners;
    private StatefulSession statefulSession;
    private Expressions.ValueExpression<RuleBase> ruleBase;

    @Override
    public boolean clearDirty() {
        return true;
    }

    public String getRuleBaseName() {
        return this.ruleBaseName;
    }

    public void setRuleBaseName(String ruleBaseName) {
        this.ruleBaseName = ruleBaseName;
    }

    @Unwrap
    public StatefulSession getStatefulSession() {
        if (this.statefulSession == null) {
            this.statefulSession = this.getRuleBaseFromValueBinding().newStatefulSession();
            this.statefulSession.setGlobalResolver(this.createGlobalResolver(this.statefulSession.getGlobalResolver()));
            if (this.eventListeners != null) {
                this.setEventListeners(this.statefulSession);
            }
        }
        return this.statefulSession;
    }

    private void setEventListeners(StatefulSession statefulSession) {
        if (this.eventListeners != null) {
            for (String eventListener : this.eventListeners) {
                log.debug("adding eventListener: " + eventListener);
                try {
                    Class<?> eventListenerClass = Class.forName(eventListener);
                    Object eventListenerObject = eventListenerClass.newInstance();
                    if (eventListenerObject instanceof WorkingMemoryEventListener) {
                        statefulSession.addEventListener((WorkingMemoryEventListener)eventListenerObject);
                        continue;
                    }
                    if (eventListenerObject instanceof AgendaEventListener) {
                        statefulSession.addEventListener((AgendaEventListener)eventListenerObject);
                        continue;
                    }
                    if (eventListenerObject instanceof ProcessEventListener) {
                        statefulSession.addEventListener((WorkingMemoryEventListener)eventListenerObject);
                        continue;
                    }
                    log.debug("event Listener " + eventListener + " is not of valid type - bypassing.");
                }
                catch (Exception e) {
                    log.error("error adding event listener " + eventListener + " - bypassing.");
                }
            }
        }
    }

    protected RuleBase getRuleBaseFromValueBinding() {
        RuleBase ruleBase;
        if (this.ruleBase != null) {
            ruleBase = this.ruleBase.getValue();
        } else if (this.ruleBaseName != null) {
            ruleBase = (RuleBase)Component.getInstance(this.ruleBaseName, true);
        } else {
            throw new IllegalStateException("No RuleBase");
        }
        if (ruleBase == null) {
            throw new IllegalStateException("RuleBase not found: " + this.ruleBaseName);
        }
        return ruleBase;
    }

    protected GlobalResolver createGlobalResolver(GlobalResolver delegate) {
        return new SeamGlobalResolver(delegate);
    }

    @Destroy
    public void destroy() {
        this.statefulSession.dispose();
    }

    public Expressions.ValueExpression<RuleBase> getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(Expressions.ValueExpression<RuleBase> ruleBase) {
        this.ruleBase = ruleBase;
    }

    public String[] getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(String[] eventListeners) {
        this.eventListeners = eventListeners;
    }
}

