/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;

public class MockRequestDispatcher
implements RequestDispatcher {
    private static final LogProvider logger = Logging.getLogProvider(MockRequestDispatcher.class);
    private final String url;

    public MockRequestDispatcher(String url) {
        this.url = url;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        this.getMockHttpServletResponse(response).setForwardedUrl(this.url);
        if (logger.isDebugEnabled()) {
            logger.debug("MockRequestDispatcher: forwarding to URL [" + this.url + "]");
        }
    }

    public void include(ServletRequest request, ServletResponse response) {
        this.getMockHttpServletResponse(response).setIncludedUrl(this.url);
        if (logger.isDebugEnabled()) {
            logger.debug("MockRequestDispatcher: including URL [" + this.url + "]");
        }
    }

    protected EnhancedMockHttpServletResponse getMockHttpServletResponse(ServletResponse response) {
        if (response instanceof EnhancedMockHttpServletResponse) {
            return (EnhancedMockHttpServletResponse)response;
        }
        if (response instanceof HttpServletResponseWrapper) {
            return this.getMockHttpServletResponse(((HttpServletResponseWrapper)response).getResponse());
        }
        throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
    }
}

