/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception;

import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.exception.ExceptionHandler;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.faces.Redirect;
import org.jboss.seam.faces.RedirectException;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class DebugPageHandler
extends ExceptionHandler {
    private static final LogProvider log = Logging.getLogProvider(DebugPageHandler.class);

    @Override
    public void handle(Exception e) throws Exception {
        log.debug("redirecting to debug page", e);
        Redirect redirect = Redirect.instance();
        redirect.setViewId("/debug.xhtml");
        FacesManager manager = FacesManager.instance();
        manager.beforeRedirect("/debug.xhtml");
        redirect.setParameter(manager.getConversationIdParameter(), manager.getCurrentConversationId());
        try {
            redirect.execute();
        }
        catch (RedirectException re) {
            log.debug("could not redirect", re);
        }
        Contexts.getConversationContext().flush();
    }

    @Override
    public boolean isHandler(Exception e) {
        return true;
    }

    public String toString() {
        return "DebugPageHandler";
    }
}

