/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.util.HashSet;
import java.util.Set;
import org.jboss.seam.annotations.Namespace;

class NamespaceDescriptor {
    private String namespace;
    private Set<String> packageNames = new HashSet<String>();
    private String componentPrefix;

    NamespaceDescriptor(Namespace namespaceAnnotation, Package pkg) {
        this.namespace = namespaceAnnotation.value();
        this.componentPrefix = namespaceAnnotation.prefix();
        this.packageNames.add(pkg.getName());
    }

    NamespaceDescriptor(String namespace, String packageName) {
        this.namespace = namespace;
        this.packageNames.add(packageName);
        this.componentPrefix = "";
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getComponentPrefix() {
        return this.componentPrefix;
    }

    public void addPackageName(String packageName) {
        this.packageNames.add(packageName);
    }

    public Set<String> getPackageNames() {
        return this.packageNames;
    }

    public String toString() {
        return "NamespaceDescriptor(" + this.namespace + ')';
    }
}

