/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.log;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.seam.log.LogImpl;
import org.jboss.seam.log.LogProvider;

final class Log4JProvider
implements LogProvider {
    private final Logger logger;
    private final boolean isWrapped;
    private static final String LOG_IMPL_FQCN;
    private static final String LOG_PROVIDER_FQCN;
    private static final Level TRACE;

    Log4JProvider(String category, boolean wrapped) {
        this.logger = Logger.getLogger((String)category);
        this.isWrapped = wrapped;
    }

    private String getFQCN() {
        return this.isWrapped ? LOG_IMPL_FQCN : LOG_PROVIDER_FQCN;
    }

    @Override
    public void debug(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.DEBUG, object, null);
    }

    @Override
    public void debug(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.DEBUG, object, t);
    }

    @Override
    public void error(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.ERROR, object, null);
    }

    @Override
    public void error(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.ERROR, object, t);
    }

    @Override
    public void fatal(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.FATAL, object, null);
    }

    @Override
    public void fatal(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.FATAL, object, t);
    }

    @Override
    public void info(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.INFO, object, null);
    }

    @Override
    public void info(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.INFO, object, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor((Priority)Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isEnabledFor((Priority)TRACE);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void trace(Object object) {
        this.logger.log(this.getFQCN(), (Priority)TRACE, object, null);
    }

    @Override
    public void trace(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)TRACE, object, t);
    }

    @Override
    public void warn(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.WARN, object, null);
    }

    @Override
    public void warn(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.WARN, object, t);
    }

    static {
        Object trace;
        LOG_IMPL_FQCN = LogImpl.class.getName();
        LOG_PROVIDER_FQCN = Log4JProvider.class.getName();
        try {
            trace = Level.class.getDeclaredField("TRACE").get(null);
        }
        catch (Exception e) {
            trace = Level.DEBUG;
        }
        TRACE = trace;
    }
}

