/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.wicket.mock;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Application;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.apache.wicket.util.tester.DummyHomePage;
import org.apache.wicket.util.tester.WicketTester;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.Init;
import org.jboss.seam.init.Initialization;
import org.jboss.seam.wicket.SeamWebApplication;

public class SeamWicketTester
extends WicketTester {
    private static boolean started;

    public SeamWicketTester() {
        this(DummyHomePage.class);
    }

    public SeamWicketTester(Class homePage) {
        this(homePage, null);
    }

    public SeamWicketTester(Class homePage, Class loginPage) {
        this(SeamWicketTester.createApplication(homePage, loginPage));
    }

    public SeamWicketTester(SeamWebApplication application) {
        this(application, null);
    }

    public SeamWicketTester(SeamWebApplication application, String path) {
        super((WebApplication)application, path);
        Lifecycle.beginCall();
        ((SeamWebApplication)this.getApplication()).setDestroyContextsLazily(true);
        Lifecycle.endCall();
    }

    private static SeamWebApplication createApplication(final Class homePage, final Class loginPage) {
        return new SeamWebApplication(){

            public Class getHomePage() {
                return homePage;
            }

            @Override
            protected Class getLoginPage() {
                return loginPage;
            }

            protected ISessionStore newSessionStore() {
                return new HttpSessionStore((Application)this);
            }

            protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
                return new WebResponse(servletResponse);
            }

            protected void outputDevelopmentModeWarning() {
            }
        };
    }

    public ServletContext newServletContext(String path) {
        URL webxml;
        if (ServletLifecycle.getServletContext() != null) {
            ServletLifecycle.endApplication();
        }
        if (path == null && (webxml = ((Object)((Object)this)).getClass().getResource("/WEB-INF/web.xml")) != null) {
            try {
                path = new File(webxml.toURI()).getParentFile().getParentFile().getAbsolutePath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        ServletContext context = super.newServletContext(path);
        ServletLifecycle.beginApplication((ServletContext)context);
        new Initialization(context).create().init();
        ((Init)context.getAttribute(Seam.getComponentName(Init.class))).setDebug(false);
        return context;
    }

    public WebRequestCycle setupRequestAndResponse(boolean isAjax) {
        WebRequestCycle cycle = super.setupRequestAndResponse(isAjax);
        BaseWicketTester.callOnBeginRequest((RequestCycle)cycle);
        return cycle;
    }
}

