/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.CacheViewControlCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.module.ExtendedModuleCommandFactory;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.MapReduceCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.VersionedPutKeyValueCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandsFactory {
    EmbeddedCacheManager cacheManager;
    GlobalComponentRegistry registry;
    Map<Byte, ModuleCommandFactory> commandFactories;

    @Inject
    public void inject(EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, @ComponentName(value="org.infinispan.modules.command.factories") Map<Byte, ModuleCommandFactory> commandFactories) {
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.commandFactories = commandFactories;
    }

    public ReplicableCommand fromStream(byte id, Object[] parameters, byte type) {
        VisitableCommand command;
        block15: {
            block14: {
                if (type != 0) break block14;
                switch (id) {
                    case 8: {
                        command = new PutKeyValueCommand();
                        break block15;
                    }
                    case 28: {
                        command = new VersionedPutKeyValueCommand();
                        break block15;
                    }
                    case 9: {
                        command = new PutMapCommand();
                        break block15;
                    }
                    case 10: {
                        command = new RemoveCommand();
                        break block15;
                    }
                    case 11: {
                        command = new ReplaceCommand();
                        break block15;
                    }
                    case 4: {
                        command = new GetKeyValueCommand();
                        break block15;
                    }
                    case 5: {
                        command = new ClearCommand();
                        break block15;
                    }
                    case 6: {
                        command = new InvalidateCommand();
                        break block15;
                    }
                    case 7: {
                        command = new InvalidateL1Command();
                        break block15;
                    }
                    case 19: {
                        command = new DistributedExecuteCommand();
                        break block15;
                    }
                    case 25: {
                        command = new ApplyDeltaCommand();
                        break block15;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, parameters);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        command.setParameters(id, parameters);
        return command;
    }

    public CacheRpcCommand fromStream(byte id, Object[] parameters, byte type, String cacheName) {
        CacheRpcCommand command;
        block21: {
            block20: {
                if (type != 0) break block20;
                switch (id) {
                    case 3: {
                        command = new LockControlCommand(cacheName);
                        break block21;
                    }
                    case 12: {
                        command = new PrepareCommand(cacheName);
                        break block21;
                    }
                    case 26: {
                        command = new VersionedPrepareCommand(cacheName);
                        break block21;
                    }
                    case 14: {
                        command = new CommitCommand(cacheName);
                        break block21;
                    }
                    case 27: {
                        command = new VersionedCommitCommand(cacheName);
                        break block21;
                    }
                    case 13: {
                        command = new RollbackCommand(cacheName);
                        break block21;
                    }
                    case 2: {
                        command = new MultipleRpcCommand(cacheName);
                        break block21;
                    }
                    case 1: {
                        command = new SingleRpcCommand(cacheName);
                        break block21;
                    }
                    case 16: {
                        command = new ClusteredGetCommand(cacheName);
                        break block21;
                    }
                    case 15: {
                        command = new StateTransferControlCommand(cacheName);
                        break block21;
                    }
                    case 18: {
                        command = new RemoveCacheCommand(cacheName, this.cacheManager, this.registry);
                        break block21;
                    }
                    case 22: {
                        command = new TxCompletionNotificationCommand(cacheName);
                        break block21;
                    }
                    case 21: {
                        command = new GetInDoubtTransactionsCommand(cacheName);
                        break block21;
                    }
                    case 20: {
                        command = new MapReduceCommand(cacheName);
                        break block21;
                    }
                    case 23: {
                        command = new GetInDoubtTxInfoCommand(cacheName);
                        break block21;
                    }
                    case 24: {
                        command = new CompleteTransactionCommand(cacheName);
                        break block21;
                    }
                    case 17: {
                        command = new CacheViewControlCommand(cacheName);
                        break block21;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ExtendedModuleCommandFactory mcf = (ExtendedModuleCommandFactory)this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, parameters, cacheName);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        command.setParameters(id, parameters);
        return command;
    }
}

