/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.AbstractInvocationContext;

public class SingleKeyNonTxInvocationContext
extends AbstractInvocationContext {
    private final boolean isOriginLocal;
    private Object key;
    private boolean isLocked;
    private CacheEntry cacheEntry;

    public SingleKeyNonTxInvocationContext(boolean originLocal) {
        this.isOriginLocal = originLocal;
    }

    @Override
    public boolean isOriginLocal() {
        return this.isOriginLocal;
    }

    @Override
    public boolean isInTxScope() {
        return false;
    }

    @Override
    public Object getLockOwner() {
        return Thread.currentThread();
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.isLocked && this.key != null ? Collections.singleton(this.key) : Collections.emptySet();
    }

    @Override
    public void clearLockedKeys() {
        this.key = null;
        this.cacheEntry = null;
    }

    @Override
    public void addLockedKey(Object key) {
        if (this.cacheEntry != null && !key.equals(this.key)) {
            throw this.illegalStateException();
        }
        this.isLocked = true;
    }

    private IllegalStateException illegalStateException() {
        return new IllegalStateException("This is a single key invocation context, using multiple keys shouldn't be possible");
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (key != null && key.equals(this.key)) {
            return this.cacheEntry;
        }
        return null;
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.key == null ? Collections.emptyMap() : Collections.singletonMap(this.key, this.cacheEntry);
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.key = key;
        this.cacheEntry = e;
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> lookedUpEntries) {
        if (lookedUpEntries.size() > 1) {
            throw this.illegalStateException();
        }
        Map.Entry<Object, CacheEntry> e = lookedUpEntries.entrySet().iterator().next();
        this.key = e.getKey();
        this.cacheEntry = e.getValue();
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (key.equals(this.key)) {
            this.clearLockedKeys();
        }
    }

    @Override
    public void clearLookedUpEntries() {
        this.clearLockedKeys();
    }

    public CacheEntry getCacheEntry() {
        return this.cacheEntry;
    }
}

