/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class SysPropertyActions {
    public static String getProperty(String name, String defaultValue) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEDGED.getProperty(name, defaultValue);
        }
        return SysProps.PRIVILEDGED.getProperty(name, defaultValue);
    }

    public static String getProperty(String name) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEDGED.getProperty(name);
        }
        return SysProps.PRIVILEDGED.getProperty(name);
    }

    public static String setProperty(String name, String value) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEDGED.setProperty(name, value);
        }
        return SysProps.PRIVILEDGED.setProperty(name, value);
    }

    static interface SysProps {
        public static final SysProps NON_PRIVILEDGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return System.getProperty(name, defaultValue);
            }

            @Override
            public String getProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public String setProperty(String key, String value) {
                return System.setProperty(key, value);
            }
        };
        public static final SysProps PRIVILEDGED = new SysProps(){

            @Override
            public String getProperty(final String name, final String defaultValue) {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(name, defaultValue);
                    }
                };
                return (String)AccessController.doPrivileged(action);
            }

            @Override
            public String getProperty(final String name) {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(name);
                    }
                };
                return (String)AccessController.doPrivileged(action);
            }

            @Override
            public String setProperty(final String name, final String value) {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        return System.setProperty(name, value);
                    }
                };
                return (String)AccessController.doPrivileged(action);
            }
        };

        public String getProperty(String var1, String var2);

        public String getProperty(String var1);

        public String setProperty(String var1, String var2);
    }
}

