/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.extra;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.sonatype.aether.ant.com.ning.http.client.extra.ThrottleRequestFilter;
import org.sonatype.aether.ant.com.ning.http.client.resumable.ResumableListener;
import org.sonatype.aether.ant.org.slf4j.Logger;
import org.sonatype.aether.ant.org.slf4j.LoggerFactory;

public class ResumableRandomAccessFileListener
implements ResumableListener {
    private final RandomAccessFile file;
    private static final Logger logger = LoggerFactory.getLogger(ThrottleRequestFilter.class);

    public ResumableRandomAccessFileListener(RandomAccessFile file) {
        this.file = file;
    }

    public void onBytesReceived(ByteBuffer buffer) throws IOException {
        this.file.seek(this.file.length());
        this.file.write(buffer.array());
    }

    public void onAllBytesReceived() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }
}

