/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.apache.maven.model.profile.activation;

import org.sonatype.aether.ant.org.apache.maven.model.Activation;
import org.sonatype.aether.ant.org.apache.maven.model.ActivationOS;
import org.sonatype.aether.ant.org.apache.maven.model.Profile;
import org.sonatype.aether.ant.org.apache.maven.model.building.ModelProblemCollector;
import org.sonatype.aether.ant.org.apache.maven.model.profile.ProfileActivationContext;
import org.sonatype.aether.ant.org.apache.maven.model.profile.activation.ProfileActivator;
import org.sonatype.aether.ant.org.codehaus.plexus.component.annotations.Component;
import org.sonatype.aether.ant.org.codehaus.plexus.util.Os;

@Component(role=ProfileActivator.class, hint="os")
public class OperatingSystemProfileActivator
implements ProfileActivator {
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        ActivationOS os;
        boolean active = false;
        Activation activation = profile.getActivation();
        if (activation != null && (os = activation.getOs()) != null) {
            active = this.ensureAtLeastOneNonNull(os);
            if (active && os.getFamily() != null) {
                active = this.determineFamilyMatch(os.getFamily());
            }
            if (active && os.getName() != null) {
                active = this.determineNameMatch(os.getName());
            }
            if (active && os.getArch() != null) {
                active = this.determineArchMatch(os.getArch());
            }
            if (active && os.getVersion() != null) {
                active = this.determineVersionMatch(os.getVersion());
            }
        }
        return active;
    }

    private boolean ensureAtLeastOneNonNull(ActivationOS os) {
        return os.getArch() != null || os.getFamily() != null || os.getName() != null || os.getVersion() != null;
    }

    private boolean determineVersionMatch(String version) {
        String test = version;
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        boolean result = Os.isVersion(test);
        if (reverse) {
            return !result;
        }
        return result;
    }

    private boolean determineArchMatch(String arch) {
        String test = arch;
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        boolean result = Os.isArch(test);
        if (reverse) {
            return !result;
        }
        return result;
    }

    private boolean determineNameMatch(String name) {
        String test = name;
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        boolean result = Os.isName(test);
        if (reverse) {
            return !result;
        }
        return result;
    }

    private boolean determineFamilyMatch(String family) {
        String test = family;
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        boolean result = Os.isFamily(test);
        if (reverse) {
            return !result;
        }
        return result;
    }
}

