/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.tasks;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.sonatype.aether.ant.AntRepoSys;
import org.sonatype.aether.ant.ConverterUtils;
import org.sonatype.aether.ant.org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.ant.org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.ant.org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.ant.org.sonatype.aether.deployment.DeploymentException;
import org.sonatype.aether.ant.tasks.AbstractDistTask;
import org.sonatype.aether.ant.types.RemoteRepository;

public class Deploy
extends AbstractDistTask {
    private RemoteRepository repository;
    private RemoteRepository snapshotRepository;

    protected void validate() {
        super.validate();
        if (this.repository == null) {
            throw new BuildException("You must specify the <remoteRepo id=\"...\" url=\"...\"> element to denote the target repository for the deployment");
        }
        this.repository.validate(this);
        if (this.snapshotRepository != null) {
            this.snapshotRepository.validate(this);
        }
    }

    public void addRemoteRepo(RemoteRepository repository) {
        if (this.repository != null) {
            throw new BuildException("You must not specify multiple <remoteRepo> elements");
        }
        this.repository = repository;
    }

    public void setRemoteRepoRef(Reference ref) {
        if (this.repository == null) {
            this.repository = new RemoteRepository();
            this.repository.setProject(this.getProject());
        }
        this.repository.setRefid(ref);
    }

    public void addSnapshotRepo(RemoteRepository snapshotRepository) {
        if (this.snapshotRepository != null) {
            throw new BuildException("You must not specify multiple <snapshotRepo> elements");
        }
        this.snapshotRepository = snapshotRepository;
    }

    public void setSnapshotRepoRef(Reference ref) {
        if (this.snapshotRepository == null) {
            this.snapshotRepository = new RemoteRepository();
            this.snapshotRepository.setProject(this.getProject());
        }
        this.snapshotRepository.setRefid(ref);
    }

    public void execute() throws BuildException {
        this.validate();
        AntRepoSys sys = AntRepoSys.getInstance(this.getProject());
        RepositorySystemSession session = sys.getSession(this, null);
        RepositorySystem system = sys.getSystem();
        DeployRequest request = new DeployRequest();
        request.setArtifacts(this.toArtifacts(session));
        boolean snapshot = request.getArtifacts().iterator().next().isSnapshot();
        RemoteRepository distRepo = snapshot && this.snapshotRepository != null ? this.snapshotRepository : this.repository;
        request.setRepository(ConverterUtils.toDistRepository(distRepo, session));
        try {
            system.deploy(session, request);
        }
        catch (DeploymentException e) {
            throw new BuildException("Could not deploy artifacts: " + e.getMessage(), (Throwable)e);
        }
    }
}

