/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.sonatype.aether.ant.AntRepoSys;
import org.sonatype.aether.ant.types.Authentication;

public class Proxy
extends DataType {
    private String host;
    private int port;
    private String type;
    private String nonProxyHosts;
    private Authentication authentication;

    public void setProject(Project project) {
        super.setProject(project);
        AntRepoSys.getInstance(project).addProxy(this);
    }

    protected Proxy getRef() {
        return (Proxy)((Object)this.getCheckedRef());
    }

    public void setRefid(Reference ref) {
        if (this.host != null || this.port != 0 || this.type != null || this.nonProxyHosts != null) {
            throw this.tooManyAttributes();
        }
        if (this.authentication != null) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(ref);
    }

    public String getHost() {
        if (this.isReference()) {
            return this.getRef().getHost();
        }
        return this.host;
    }

    public void setHost(String host) {
        this.checkAttributesAllowed();
        this.host = host;
    }

    public int getPort() {
        if (this.isReference()) {
            return this.getRef().getPort();
        }
        return this.port;
    }

    public void setPort(int port) {
        this.checkAttributesAllowed();
        if (port <= 0 || port > 65535) {
            throw new BuildException("The port number must be within the range 1 - 65535");
        }
        this.port = port;
    }

    public String getType() {
        if (this.isReference()) {
            return this.getRef().getType();
        }
        return this.type;
    }

    public void setType(String type) {
        this.checkAttributesAllowed();
        this.type = type;
    }

    public String getNonProxyHosts() {
        if (this.isReference()) {
            return this.getRef().getNonProxyHosts();
        }
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.checkAttributesAllowed();
        this.nonProxyHosts = nonProxyHosts;
    }

    public Authentication getAuthentication() {
        if (this.isReference()) {
            return this.getRef().getAuthentication();
        }
        return this.authentication;
    }

    public void addAuthentication(Authentication authentication) {
        this.checkChildrenAllowed();
        if (this.authentication != null) {
            throw new BuildException("You must not specify multiple <authentication> elements");
        }
        this.authentication = authentication;
    }

    public void setAuthRef(Reference ref) {
        if (this.authentication == null) {
            this.authentication = new Authentication();
            this.authentication.setProject(this.getProject());
        }
        this.authentication.setRefid(ref);
    }
}

