//$Id: HotelSearchingAction.groovy 4933 2007-05-27 03:13:24Z ebernard $
package org.jboss.seam.example.groovy.action

import javax.persistence.EntityManager

import org.jboss.seam.ScopeType

import org.jboss.seam.annotations.Name
import org.jboss.seam.annotations.Scope
import org.jboss.seam.annotations.datamodel.DataModel

import org.jboss.seam.annotations.In

import org.jboss.seam.annotations.Factory
import org.jboss.seam.example.groovy.model.Hotel
import org.jboss.seam.annotations.security.Restrict

@Name("hotelSearch")
@Scope(ScopeType.SESSION)
@Restrict("#{identity.loggedIn}")
class HotelSearchingAction
{

   @In
   private EntityManager em

   String searchString
   int pageSize = 10
   int page

   @DataModel
   List<Hotel> hotels

   void find()
   {
      page = 0
      queryHotels()
   }

   void nextPage()
   {
      page++
      queryHotels()
   }

   private void queryHotels()
   {
      def query = em.createQuery('''
         select h from Hotel h where
         lower(h.name) like #{pattern}
         or lower(h.city) like #{pattern}
         or lower(h.zip) like #{pattern}
         or lower(h.address) like #{pattern}
         ''')
      query.maxResults = pageSize
      query.firstResult = page * pageSize
      hotels = query.getResultList()	
   }

   @Factory(value="pattern", scope=ScopeType.EVENT)
   String getSearchPattern()
   {
      return searchString ?
            "%${searchString.toLowerCase().replace('*', '%')}%" :
            "%";
   }

   boolean isNextPageAvailable()
   {
      return hotels && hotels.size()==pageSize
   }
}
