/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.example.tasks.entity;

import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import javax.validation.constraints.NotNull;

/**
 * 
 * @author Jozef Hartinger
 *
 */
@Entity
@XmlRootElement
@Table(uniqueConstraints = @UniqueConstraint(columnNames = { "NAME", "OWNER_USERNAME" }))
@NamedQuery(name = "categoryByNameAndUser", query = "select category from Category category where category.owner.username like :username and category.name like :category")
public class Category
{
   private Long id;
   private String name;
   private List<Task> tasks;
   private User owner;

   public Category()
   {
   }

   public Category(Long id, String name, List<Task> tasks, User owner)
   {
      this.id = id;
      this.name = name;
      this.tasks = tasks;
      this.owner = owner;
   }

   @Id
   @GeneratedValue(strategy= GenerationType.IDENTITY)
   @XmlTransient
   public Long getId()
   {
      return id;
   }

   public void setId(Long id)
   {
      this.id = id;
   }

   @NotNull
   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   @OneToMany(mappedBy = "category", cascade = CascadeType.REMOVE)
   @XmlTransient
   public List<Task> getTasks()
   {
      return tasks;
   }

   public void setTasks(List<Task> tasks)
   {
      this.tasks = tasks;
   }

   @ManyToOne
   @XmlTransient
   public User getOwner()
   {
      return owner;
   }

   public void setOwner(User owner)
   {
      this.owner = owner;
   }

}
