/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.sasl.callback.DigestHashCallback;

public class PropertiesCallbackHandler
extends PropertiesFileLoader
implements Service<DomainCallbackHandler>,
DomainCallbackHandler {
    public static final String SERVICE_SUFFIX = "properties_authentication";
    private static final Class[] PLAIN_CALLBACKS = new Class[]{AuthorizeCallback.class, RealmCallback.class, NameCallback.class, PasswordCallback.class};
    private static final Class[] DIGEST_CALLBACKS = new Class[]{AuthorizeCallback.class, RealmCallback.class, NameCallback.class, DigestHashCallback.class};
    private static final String DOLLAR_LOCAL = "$local";
    private final Class[] supportedCallbacks;
    private final String realm;
    private final boolean plainText;

    public PropertiesCallbackHandler(String realm, ModelNode properties) {
        super(properties.require("path").asString());
        this.realm = realm;
        this.plainText = properties.hasDefined("plain-text") ? properties.require("plain-text").asBoolean() : false;
        this.supportedCallbacks = this.plainText ? PLAIN_CALLBACKS : DIGEST_CALLBACKS;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
    }

    @Override
    protected void verifyProperties(Properties properties) throws IOException {
        String admin = "admin";
        if (properties.contains("admin") && "admin".equals(properties.get("admin"))) {
            DomainManagementLogger.ROOT_LOGGER.userAndPasswordWarning();
        }
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
    }

    public DomainCallbackHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Class[] getSupportedCallbacks() {
        return this.supportedCallbacks;
    }

    @Override
    public boolean isReady() {
        Properties users;
        try {
            users = this.getProperties();
        }
        catch (IOException e) {
            return false;
        }
        return users.size() > 0;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
        String userName = null;
        boolean userFound = false;
        Properties users = this.getProperties();
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                userName = nameCallback.getDefaultName();
                userFound = users.containsKey(userName);
                continue;
            }
            if (current instanceof PasswordCallback && this.plainText) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof DigestHashCallback && !this.plainText) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realm = ((RealmCallback)current).getDefaultText();
                if (this.realm.equals(realm)) continue;
                throw DomainManagementMessages.MESSAGES.invalidRealm(realm, this.realm);
            }
            throw new UnsupportedCallbackException(current);
        }
        for (Callback current : toRespondTo) {
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                continue;
            }
            if (current instanceof PasswordCallback) {
                if (!userFound) {
                    throw new UserNotFoundException(userName);
                }
                String password = users.get(userName).toString();
                ((PasswordCallback)current).setPassword(password.toCharArray());
                continue;
            }
            if (!(current instanceof DigestHashCallback)) continue;
            if (!userFound) {
                throw new UserNotFoundException(userName);
            }
            String hash = users.get(userName).toString();
            ((DigestHashCallback)current).setHexHash(hash);
        }
    }
}

