/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.sprm;

import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public class SprmOperation {
    private static final BitField OP_BITFIELD = BitFieldFactory.getInstance((int)511);
    private static final BitField SPECIAL_BITFIELD = BitFieldFactory.getInstance((int)512);
    private static final BitField TYPE_BITFIELD = BitFieldFactory.getInstance((int)7168);
    private static final BitField SIZECODE_BITFIELD = BitFieldFactory.getInstance((int)57344);
    private static final short LONG_SPRM_TABLE = -10744;
    private static final short LONG_SPRM_PARAGRAPH = -14827;
    public static final int PAP_TYPE = 1;
    public static final int TAP_TYPE = 5;
    private int _type;
    private int _operation;
    private int _gOffset;
    private byte[] _grpprl;
    private int _sizeCode;
    private int _size;

    public SprmOperation(byte[] grpprl, int offset) {
        this._grpprl = grpprl;
        short sprmStart = LittleEndian.getShort((byte[])grpprl, (int)offset);
        this._gOffset = offset + 2;
        this._operation = OP_BITFIELD.getValue((int)sprmStart);
        this._type = TYPE_BITFIELD.getValue((int)sprmStart);
        this._sizeCode = SIZECODE_BITFIELD.getValue((int)sprmStart);
        this._size = this.initSize(sprmStart);
    }

    public static int getOperationFromOpcode(short opcode) {
        return OP_BITFIELD.getValue((int)opcode);
    }

    public static int getTypeFromOpcode(short opcode) {
        return TYPE_BITFIELD.getValue((int)opcode);
    }

    public int getType() {
        return this._type;
    }

    public int getOperation() {
        return this._operation;
    }

    public int getGrpprlOffset() {
        return this._gOffset;
    }

    public int getOperand() {
        switch (this._sizeCode) {
            case 0: 
            case 1: {
                return this._grpprl[this._gOffset];
            }
            case 2: 
            case 4: 
            case 5: {
                return LittleEndian.getShort((byte[])this._grpprl, (int)this._gOffset);
            }
            case 3: {
                return LittleEndian.getInt((byte[])this._grpprl, (int)this._gOffset);
            }
            case 6: {
                int operandLength = this._grpprl[this._gOffset + 1];
                byte[] codeBytes = new byte[4];
                for (int i = 0; i < operandLength; ++i) {
                    if (this._gOffset + i >= this._grpprl.length) continue;
                    codeBytes[i] = this._grpprl[this._gOffset + 1 + i];
                }
                return LittleEndian.getInt((byte[])codeBytes, (int)0);
            }
            case 7: {
                byte[] threeByteInt = new byte[]{this._grpprl[this._gOffset], this._grpprl[this._gOffset + 1], this._grpprl[this._gOffset + 2], 0};
                return LittleEndian.getInt((byte[])threeByteInt, (int)0);
            }
        }
        throw new IllegalArgumentException("SPRM contains an invalid size code");
    }

    public int getSizeCode() {
        return this._sizeCode;
    }

    public int size() {
        return this._size;
    }

    public byte[] getGrpprl() {
        return this._grpprl;
    }

    private int initSize(short sprm) {
        switch (this._sizeCode) {
            case 0: 
            case 1: {
                return 3;
            }
            case 2: 
            case 4: 
            case 5: {
                return 4;
            }
            case 3: {
                return 6;
            }
            case 6: {
                if (sprm == -10744 || sprm == -14827) {
                    int retVal = (0xFFFF & LittleEndian.getShort((byte[])this._grpprl, (int)this._gOffset)) + 3;
                    this._gOffset += 2;
                    return retVal;
                }
                return (0xFF & this._grpprl[this._gOffset++]) + 3;
            }
            case 7: {
                return 5;
            }
        }
        throw new IllegalArgumentException("SPRM contains an invalid size code");
    }
}

