/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client;

import org.sonatype.aether.ant.com.ning.http.client.AsyncCompletionHandlerBase;
import org.sonatype.aether.ant.com.ning.http.client.AsyncHandler;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseBodyPart;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseHeaders;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseStatus;
import org.sonatype.aether.ant.com.ning.http.client.ProgressAsyncHandler;
import org.sonatype.aether.ant.com.ning.http.client.Response;
import org.sonatype.aether.ant.org.slf4j.Logger;
import org.sonatype.aether.ant.org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncCompletionHandler<T>
implements AsyncHandler<T>,
ProgressAsyncHandler<T> {
    private final Logger log = LoggerFactory.getLogger(AsyncCompletionHandlerBase.class);
    private final Response.ResponseBuilder builder = new Response.ResponseBuilder();

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.builder.accumulate(content);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
        this.builder.reset();
        this.builder.accumulate(status);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.builder.accumulate(headers);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final T onCompleted() throws Exception {
        return this.onCompleted(this.builder.build());
    }

    @Override
    public void onThrowable(Throwable t) {
        this.log.debug(t.getMessage(), t);
    }

    public abstract T onCompleted(Response var1) throws Exception;

    @Override
    public AsyncHandler.STATE onHeaderWriteCompleted() {
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onContentWriteCompleted() {
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onContentWriteProgress(long amount, long current, long total) {
        return AsyncHandler.STATE.CONTINUE;
    }
}

