/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.providers.jdk;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sonatype.aether.ant.com.ning.http.client.Cookie;
import org.sonatype.aether.ant.com.ning.http.client.FluentCaseInsensitiveStringsMap;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseBodyPart;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseHeaders;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseStatus;
import org.sonatype.aether.ant.com.ning.http.client.Response;
import org.sonatype.aether.ant.com.ning.http.util.AsyncHttpProviderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKResponse
implements Response {
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String HEADERS_NOT_COMPUTED = "Response's headers hasn't been computed by your AsyncHandler.";
    private final URI uri;
    private final Collection<HttpResponseBodyPart> bodyParts;
    private final HttpResponseHeaders headers;
    private final HttpResponseStatus status;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private AtomicBoolean contentComputed = new AtomicBoolean(false);
    private String content;

    public JDKResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        this.bodyParts = bodyParts;
        this.headers = headers;
        this.status = status;
        this.uri = this.status.getUrl();
    }

    @Override
    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(DEFAULT_CHARSET);
    }

    @Override
    public String getResponseBody(String charset) throws IOException {
        String contentType = this.getContentType();
        if (contentType != null && charset == null) {
            charset = AsyncHttpProviderUtils.parseCharset(contentType);
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        if (!this.contentComputed.get()) {
            this.contentToString(charset);
        }
        return this.content;
    }

    String contentToString(String charset) throws UnsupportedEncodingException {
        StringBuilder b = new StringBuilder();
        for (HttpResponseBodyPart bp : this.bodyParts) {
            b.append(new String(bp.getBodyPartBytes(), charset));
        }
        this.content = b.toString();
        return this.content;
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        if (this.contentComputed.get()) {
            return new ByteArrayInputStream(this.content.getBytes(DEFAULT_CHARSET));
        }
        if (this.bodyParts.size() > 0) {
            return new ByteArrayCollectionInputStream(this.bodyParts.toArray(new HttpResponseBodyPart[this.bodyParts.size()]));
        }
        return new ByteArrayInputStream("".getBytes());
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        return this.getResponseBodyExcerpt(maxLength, DEFAULT_CHARSET);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
        String contentType = this.getContentType();
        if (contentType != null && charset == null) {
            charset = AsyncHttpProviderUtils.parseCharset(contentType);
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        if (!this.contentComputed.get()) {
            this.contentToString(charset == null ? DEFAULT_CHARSET : charset);
        }
        return this.content.length() <= maxLength ? this.content : this.content.substring(0, maxLength);
    }

    @Override
    public URI getUri() throws MalformedURLException {
        return this.uri;
    }

    @Override
    public String getContentType() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders().getFirstValue("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        if (this.headers == null) {
            throw new IllegalStateException();
        }
        return this.headers.getHeaders().getFirstValue(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders().get(name);
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders();
    }

    @Override
    public boolean isRedirected() {
        return this.status.getStatusCode() >= 300 && this.status.getStatusCode() <= 399;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        if (this.cookies.isEmpty()) {
            for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
                if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
                List<String> v = header.getValue();
                for (String value : v) {
                    Cookie cookie = AsyncHttpProviderUtils.parseCookie(value);
                    this.cookies.add(cookie);
                }
            }
        }
        return Collections.unmodifiableList(this.cookies);
    }

    @Override
    public boolean hasResponseStatus() {
        return this.bodyParts != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null;
    }

    @Override
    public boolean hasResponseBody() {
        return this.bodyParts != null && this.bodyParts.size() > 0;
    }

    private static class ByteArrayCollectionInputStream
    extends InputStream {
        private final HttpResponseBodyPart[] parts;
        private int currentPos = 0;
        private int bytePos = -1;
        private byte[] active;
        private int available = 0;

        public ByteArrayCollectionInputStream(HttpResponseBodyPart[] parts) {
            this.parts = parts;
            this.active = parts[0].getBodyPartBytes();
            this.computeLength(parts);
        }

        private void computeLength(HttpResponseBodyPart[] parts) {
            if (this.available == 0) {
                for (HttpResponseBodyPart p : parts) {
                    this.available += p.getBodyPartBytes().length;
                }
            }
        }

        public int available() throws IOException {
            return this.available;
        }

        public int read() throws IOException {
            if (++this.bytePos >= this.active.length) {
                if (++this.currentPos >= this.parts.length) {
                    return -1;
                }
                this.bytePos = 0;
                this.active = this.parts[this.currentPos].getBodyPartBytes();
            }
            return this.active[this.bytePos] & 0xFF;
        }
    }
}

