/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.sonatype.aether.util.graph.transformer;

import org.sonatype.aether.ant.org.sonatype.aether.RepositoryException;
import org.sonatype.aether.ant.org.sonatype.aether.collection.DependencyGraphTransformationContext;
import org.sonatype.aether.ant.org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.ant.org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.ant.org.sonatype.aether.graph.DependencyNode;

public class JavaDependencyContextRefiner
implements DependencyGraphTransformer {
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        String scope;
        String ctx = node.getRequestContext();
        if ("project".equals(ctx) && (scope = this.getClasspathScope(node)) != null) {
            ctx = ctx + '/' + scope;
            node.setRequestContext(ctx);
        }
        for (DependencyNode child : node.getChildren()) {
            this.transformGraph(child, context);
        }
        return node;
    }

    private String getClasspathScope(DependencyNode node) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return null;
        }
        String scope = dependency.getScope();
        if ("compile".equals(scope) || "system".equals(scope) || "provided".equals(scope)) {
            return "compile";
        }
        if ("runtime".equals(scope)) {
            return "runtime";
        }
        if ("test".equals(scope)) {
            return "test";
        }
        return null;
    }
}

