/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.server.rpc.impl.SerializedInstanceReference;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializabilityUtil {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final Comparator<Field> FIELD_COMPARATOR = new Comparator<Field>(){

        @Override
        public int compare(Field f1, Field f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };
    private static final Map<Class<?>, String> classCRC32Cache = new IdentityHashMap();
    private static final Map<Class<?>, Field[]> classSerializableFieldsCache = new IdentityHashMap();
    private static final Map<Class<?>, Class<?>> classCustomSerializerCache = new IdentityHashMap();
    private static final String JRE_SERIALIZER_PACKAGE = "com.google.gwt.user.client.rpc.core";
    private static final Map<String, String> SERIALIZED_PRIMITIVE_TYPE_NAMES = new HashMap<String, String>();
    private static final Set<Class<?>> TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES = new HashSet();

    SerializabilityUtil() {
    }

    public static Field[] applyFieldSerializationPolicy(Class<?> clazz) {
        Field[] serializableFields = SerializabilityUtil.getCachedSerializableFieldsForClass(clazz);
        if (serializableFields == null) {
            Field[] fields;
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!SerializabilityUtil.fieldQualifiesForSerialization(field)) continue;
                fieldList.add(field);
            }
            serializableFields = fieldList.toArray(new Field[fieldList.size()]);
            Arrays.sort(serializableFields, 0, serializableFields.length, FIELD_COMPARATOR);
            SerializabilityUtil.putCachedSerializableFieldsForClass(clazz, serializableFields);
        }
        return serializableFields;
    }

    public static SerializedInstanceReference decodeSerializedInstanceReference(String encodedSerializedInstanceReference) {
        final String[] components = encodedSerializedInstanceReference.split("/");
        return new SerializedInstanceReference(){

            public String getName() {
                return components.length > 0 ? components[0] : "";
            }

            public String getSignature() {
                return components.length > 1 ? components[1] : "";
            }
        };
    }

    public static String encodeSerializedInstanceReference(Class<?> instanceType) {
        return instanceType.getName() + "/" + SerializabilityUtil.getSerializationSignature(instanceType);
    }

    public static String getSerializationSignature(Class<?> instanceType) {
        String result = SerializabilityUtil.getCachedCRCForClass(instanceType);
        if (result == null) {
            CRC32 crc = new CRC32();
            try {
                SerializabilityUtil.generateSerializationSignature(instanceType, crc);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Could not compute the serialization signature", e);
            }
            result = Long.toString(crc.getValue());
            SerializabilityUtil.putCachedCRCForClass(instanceType, result);
        }
        return result;
    }

    public static String getSerializedTypeName(Class<?> instanceType) {
        if (instanceType.isPrimitive()) {
            return SERIALIZED_PRIMITIVE_TYPE_NAMES.get(instanceType.getName());
        }
        return instanceType.getName();
    }

    public static Class<?> hasCustomFieldSerializer(Class<?> instanceType) {
        assert (instanceType != null);
        if (instanceType.isArray()) {
            return null;
        }
        Class<?> result = SerializabilityUtil.getCachedSerializerForClass(instanceType);
        if (result != null) {
            return result;
        }
        if (SerializabilityUtil.containsCachedSerializerForClass(instanceType)) {
            return null;
        }
        result = SerializabilityUtil.computeHasCustomFieldSerializer(instanceType);
        SerializabilityUtil.putCachedSerializerForClass(instanceType, result);
        return result;
    }

    private static Class<?> computeHasCustomFieldSerializer(Class<?> instanceType) {
        String simpleSerializerName;
        assert (instanceType != null);
        String qualifiedTypeName = instanceType.getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> customSerializer = SerializabilityUtil.getCustomFieldSerializer(classLoader, simpleSerializerName = qualifiedTypeName + "_CustomFieldSerializer");
        if (customSerializer != null) {
            return customSerializer;
        }
        Class<?> customSerializerClass = SerializabilityUtil.getCustomFieldSerializer(classLoader, "com.google.gwt.user.client.rpc.core." + simpleSerializerName);
        if (customSerializerClass != null) {
            return customSerializerClass;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsCachedSerializerForClass(Class<?> instanceType) {
        Map<Class<?>, Class<?>> map = classCustomSerializerCache;
        synchronized (map) {
            return classCustomSerializerCache.containsKey(instanceType);
        }
    }

    private static boolean excludeImplementationFromSerializationSignature(Class<?> instanceType) {
        return TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.contains(instanceType);
    }

    private static boolean fieldQualifiesForSerialization(Field field) {
        if (Throwable.class == field.getDeclaringClass()) {
            if ("detailMessage".equals(field.getName())) {
                assert (SerializabilityUtil.isNotStaticTransientOrFinal(field));
                return true;
            }
            return false;
        }
        return SerializabilityUtil.isNotStaticTransientOrFinal(field);
    }

    private static void generateSerializationSignature(Class<?> instanceType, CRC32 crc) throws UnsupportedEncodingException {
        crc.update(SerializabilityUtil.getSerializedTypeName(instanceType).getBytes(DEFAULT_ENCODING));
        if (SerializabilityUtil.excludeImplementationFromSerializationSignature(instanceType)) {
            return;
        }
        Class<?> customSerializer = SerializabilityUtil.hasCustomFieldSerializer(instanceType);
        if (customSerializer != null) {
            SerializabilityUtil.generateSerializationSignature(customSerializer, crc);
        } else if (instanceType.isArray()) {
            SerializabilityUtil.generateSerializationSignature(instanceType.getComponentType(), crc);
        } else if (!instanceType.isPrimitive()) {
            Field[] fields;
            for (Field field : fields = SerializabilityUtil.applyFieldSerializationPolicy(instanceType)) {
                assert (field != null);
                crc.update(field.getName().getBytes(DEFAULT_ENCODING));
                crc.update(SerializabilityUtil.getSerializedTypeName(field.getType()).getBytes(DEFAULT_ENCODING));
            }
            Class<?> superClass = instanceType.getSuperclass();
            if (superClass != null) {
                SerializabilityUtil.generateSerializationSignature(superClass, crc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCachedCRCForClass(Class<?> instanceType) {
        Map<Class<?>, String> map = classCRC32Cache;
        synchronized (map) {
            return classCRC32Cache.get(instanceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field[] getCachedSerializableFieldsForClass(Class<?> clazz) {
        Map<Class<?>, Field[]> map = classSerializableFieldsCache;
        synchronized (map) {
            return classSerializableFieldsCache.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getCachedSerializerForClass(Class<?> instanceType) {
        Map<Class<?>, Class<?>> map = classCustomSerializerCache;
        synchronized (map) {
            return classCustomSerializerCache.get(instanceType);
        }
    }

    private static Class<?> getCustomFieldSerializer(ClassLoader classLoader, String qualifiedSerialzierName) {
        try {
            Class<?> customSerializerClass = Class.forName(qualifiedSerialzierName, false, classLoader);
            return customSerializerClass;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static boolean isNotStaticTransientOrFinal(Field field) {
        int fieldModifiers = field.getModifiers();
        return !Modifier.isStatic(fieldModifiers) && !Modifier.isTransient(fieldModifiers) && !Modifier.isFinal(fieldModifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putCachedCRCForClass(Class<?> instanceType, String crc32) {
        Map<Class<?>, String> map = classCRC32Cache;
        synchronized (map) {
            classCRC32Cache.put(instanceType, crc32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putCachedSerializableFieldsForClass(Class<?> clazz, Field[] serializableFields) {
        Map<Class<?>, Field[]> map = classSerializableFieldsCache;
        synchronized (map) {
            classSerializableFieldsCache.put(clazz, serializableFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putCachedSerializerForClass(Class<?> instanceType, Class<?> customFieldSerializer) {
        Map<Class<?>, Class<?>> map = classCustomSerializerCache;
        synchronized (map) {
            classCustomSerializerCache.put(instanceType, customFieldSerializer);
        }
    }

    static {
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Boolean.TYPE.getName(), "Z");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Byte.TYPE.getName(), "B");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Character.TYPE.getName(), "C");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Double.TYPE.getName(), "D");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Float.TYPE.getName(), "F");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Integer.TYPE.getName(), "I");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Long.TYPE.getName(), "J");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Short.TYPE.getName(), "S");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Boolean.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Byte.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Character.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Double.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Exception.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Float.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Integer.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Long.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Object.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Short.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(String.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Throwable.class);
    }
}

