/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageMap;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WicketURLEncoder;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.util.lang.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageMap
implements IClusterable,
IPageMap {
    private static final Logger log = LoggerFactory.getLogger(PageMap.class);
    public static final String DEFAULT_NAME = null;
    private static final long serialVersionUID = 1L;
    private MetaDataEntry<?>[] metaData;
    private String interceptContinuationURL;
    private final String name;
    private int pageId = 0;

    public static IPageMap forName(String pageMapName) {
        Session session = Session.get();
        return session != null ? session.pageMapForName(pageMapName, true) : null;
    }

    public PageMap(String name) {
        if ("".equals(name)) {
            throw new IllegalStateException("Empty string name for pagemaps is not allowed");
        }
        this.name = name;
    }

    @Override
    public final String attributeForId(int id) {
        return this.attributePrefix() + id;
    }

    @Override
    public void clear() {
        this.visitEntries(new IVisitor(){

            public void entry(IPageMapEntry entry) {
                PageMap.this.removeEntry(entry);
            }
        });
    }

    @Override
    public final boolean continueToOriginalDestination() {
        RequestCycle cycle = RequestCycle.get();
        if (this.interceptContinuationURL != null) {
            cycle.setRequestTarget(new RedirectRequestTarget(this.interceptContinuationURL));
            this.interceptContinuationURL = null;
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public abstract Page get(int var1, int var2);

    @Override
    public final IPageMapEntry getEntry(int id) {
        return (IPageMapEntry)Session.get().getAttribute(this.attributeForId(id));
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final Session getSession() {
        return Session.get();
    }

    @Override
    public final long getSizeInBytes() {
        long size = Objects.sizeof(this);
        for (IPageMapEntry entry : this.getEntries()) {
            if (entry instanceof Page) {
                size += ((Page)entry).getSizeInBytes();
                continue;
            }
            size += Objects.sizeof(entry);
        }
        return size;
    }

    @Override
    public final boolean isDefault() {
        return this.name == DEFAULT_NAME;
    }

    @Override
    public final int nextId() {
        this.dirty();
        return this.pageId++;
    }

    @Override
    public abstract void put(Page var1);

    @Override
    public final <T extends Page> void redirectToInterceptPage(Class<T> pageClazz) {
        RequestCycle cycle = RequestCycle.get();
        this.setUpRedirect(cycle);
        cycle.setResponsePage(pageClazz);
    }

    @Override
    public final void redirectToInterceptPage(Page page) {
        RequestCycle cycle = RequestCycle.get();
        this.setUpRedirect(cycle);
        cycle.setResponsePage(page);
    }

    private void setUpRedirect(RequestCycle cycle) {
        Session session = Session.get();
        if (session.isTemporary()) {
            session.bind();
        }
        if (cycle.getRequest() instanceof WebRequest && ((WebRequest)cycle.getRequest()).isAjax()) {
            this.interceptContinuationURL = ((Object)cycle.urlFor(cycle.getRequest().getPage())).toString();
        } else {
            this.interceptContinuationURL = "/" + cycle.getRequest().getURL();
            this.interceptContinuationURL = WicketURLEncoder.FULL_PATH_INSTANCE.encode(this.interceptContinuationURL);
        }
        this.dirty();
        cycle.setRedirect(true);
    }

    @Override
    public final void remove() {
        Session.get().removePageMap(this);
        this.clear();
    }

    @Override
    public void remove(Page page) {
        this.removeEntry(page.getPageMapEntry());
        Session.get().untouch(page);
    }

    @Override
    public abstract void removeEntry(IPageMapEntry var1);

    public String toString() {
        return "[PageMap name=" + this.name + "]";
    }

    private final List<IPageMapEntry> getEntries() {
        Session session = Session.get();
        List<String> attributes = session.getAttributeNames();
        ArrayList<IPageMapEntry> list = new ArrayList<IPageMapEntry>();
        for (String attribute : attributes) {
            if (!attribute.startsWith(this.attributePrefix())) continue;
            list.add((IPageMapEntry)session.getAttribute(attribute));
        }
        return list;
    }

    protected final void dirty() {
        if (Session.get().getPageMaps().contains(this)) {
            Session.get().dirtyPageMap(this);
        }
    }

    protected final void visitEntries(IVisitor visitor) {
        Session session = Session.get();
        List<String> attributes = session.getAttributeNames();
        for (String attribute : attributes) {
            if (!attribute.startsWith(this.attributePrefix())) continue;
            visitor.entry((IPageMapEntry)session.getAttribute(attribute));
        }
    }

    public final void setMetaData(MetaDataKey<?> key, Serializable object) {
        this.metaData = key.set(this.metaData, object);
    }

    public final Serializable getMetaData(MetaDataKey<?> key) {
        return (Serializable)key.get(this.metaData);
    }

    final String attributePrefix() {
        return "p:" + this.name + ":";
    }

    static interface IVisitor {
        public void entry(IPageMapEntry var1);
    }
}

