/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.INewBrowserWindowListener;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.request.urlcompressing.UrlCompressor;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.JavascriptUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebPage
extends Page
implements INewBrowserWindowListener {
    private static final Logger log = LoggerFactory.getLogger(WebPage.class);
    private static final long serialVersionUID = 1L;
    private static ResourceReference cookiesResource = new ResourceReference(WebPage.class, "cookies.js");
    private UrlCompressor compressor;

    protected WebPage() {
        this.commonInit();
    }

    protected WebPage(IModel<?> model) {
        super(model);
        this.commonInit();
    }

    protected WebPage(IPageMap pageMap) {
        super(pageMap);
        this.commonInit();
    }

    protected WebPage(IPageMap pageMap, IModel<?> model) {
        super(pageMap, model);
        this.commonInit();
    }

    protected WebPage(PageParameters parameters) {
        super(parameters);
        this.commonInit();
    }

    protected WebPage(IPageMap pageMap, PageParameters parameters) {
        super(pageMap, parameters);
        this.commonInit();
    }

    @Override
    public String getMarkupType() {
        return "html";
    }

    public final UrlCompressor getUrlCompressor() {
        if (this.compressor == null) {
            this.compressor = new UrlCompressor();
            this.setStatelessHint(false);
        }
        return this.compressor;
    }

    @Override
    public void onNewBrowserWindow() {
        WebPage clonedPage = this;
        try {
            clonedPage = (WebPage)Objects.cloneObject(this);
        }
        catch (Exception e) {
            log.error("Page " + clonedPage + " couldn't be cloned to move to another pagemap", (Throwable)e);
        }
        IPageMap map = this.getSession().createAutoPageMap();
        clonedPage.moveToPageMap(map);
        this.setResponsePage(clonedPage);
    }

    private void commonInit() {
        if (this.getApplication().getPageSettings().getAutomaticMultiWindowSupport()) {
            this.add(new PageMapChecker(this));
        }
    }

    @Override
    protected void configureResponse() {
        super.configureResponse();
        if (this.getWebRequestCycle().getResponse() instanceof WebResponse) {
            WebResponse response = this.getWebRequestCycle().getWebResponse();
            this.setHeaders(response);
        }
    }

    protected void setHeaders(WebResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, max-age=0, must-revalidate");
    }

    protected final WebRequestCycle getWebRequestCycle() {
        return (WebRequestCycle)this.getRequestCycle();
    }

    protected final BookmarkablePageLink<?> homePageLink(String id) {
        return new BookmarkablePageLink(id, this.getApplication().getHomePage());
    }

    @Override
    protected void onAfterRender() {
        super.onAfterRender();
        if ("development".equals(this.getApplication().getConfigurationType()) && this.getRequestCycle().getResponsePage() == this) {
            this.validateHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateHeaders() {
        HtmlHeaderContainer header = (HtmlHeaderContainer)this.visitChildren(new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                if (component instanceof HtmlHeaderContainer) {
                    return component;
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
        if (header == null) {
            header = new HtmlHeaderContainer("_header_");
            this.add(header);
            Response orgResponse = this.getRequestCycle().getResponse();
            try {
                StringResponse response = new StringResponse();
                this.getRequestCycle().setResponse(response);
                this.renderHead(header);
                final HtmlHeaderContainer finalHeader = header;
                this.visitChildren(new Component.IVisitor<Component>(){

                    @Override
                    public Object component(Component component) {
                        component.renderHead(finalHeader);
                        return CONTINUE_TRAVERSAL;
                    }
                });
                response.close();
                if (response.getBuffer().length() > 0) {
                    log.error("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                    log.error("You probably forgot to add a <body> or <header> tag to your markup since no Header Container was \nfound but components were found which want to write to the <head> section.\n" + response.getBuffer());
                    log.error("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                }
            }
            catch (Exception e) {
                log.error("header/body check throws exception", (Throwable)e);
            }
            finally {
                this.remove(header);
                this.getRequestCycle().setResponse(orgResponse);
            }
        }
    }

    private static final class PageMapChecker
    extends AbstractBehavior
    implements IHeaderContributor {
        private static final long serialVersionUID = 1L;
        private final WebPage webPage;

        PageMapChecker(WebPage webPage) {
            this.webPage = webPage;
        }

        public final void renderHead(IHeaderResponse headResponse) {
            boolean firstAccess;
            Response response = headResponse.getResponse();
            WebRequestCycle cycle = (WebRequestCycle)RequestCycle.get();
            IRequestTarget target = cycle.getRequestTarget();
            if (this.webPage.isPageStateless()) {
                return;
            }
            IPageMap pageMap = this.webPage.getPageMap();
            String name = pageMap.getName();
            name = name == null ? "wicket:default" : name.replace('\"', '_');
            Session session = Session.get();
            Session.PageMapAccessMetaData meta = session.getMetaData(Session.PAGEMAP_ACCESS_MDK);
            if (meta == null) {
                meta = new Session.PageMapAccessMetaData();
                session.setMetaData(Session.PAGEMAP_ACCESS_MDK, meta);
            }
            if (firstAccess = meta.add(pageMap)) {
                JavascriptUtils.writeOpenTag(response);
                response.write("if (window.name=='' || window.name.indexOf('wicket') > -1) { window.name=\"");
                response.write("wicket-" + name);
                response.write("\"; }");
                JavascriptUtils.writeCloseTag(response);
            } else {
                CharSequence url = null;
                if (target instanceof IBookmarkablePageRequestTarget) {
                    IBookmarkablePageRequestTarget current = (IBookmarkablePageRequestTarget)target;
                    BookmarkablePageRequestTarget redirect = new BookmarkablePageRequestTarget(session.createAutoPageMapName(), current.getPageClass(), current.getPageParameters());
                    url = cycle.urlFor(redirect);
                } else {
                    url = this.webPage.urlFor(INewBrowserWindowListener.INTERFACE);
                }
                JavascriptUtils.writeOpenTag(response);
                response.write("if (window.name=='' || (window.name.indexOf('wicket') > -1 && window.name!='wicket-" + name + "')) { window.location=\"");
                response.write(url);
                response.write("\" + (window.location.hash != null ? window.location.hash : \"\"); }");
                JavascriptUtils.writeCloseTag(response);
            }
        }
    }
}

