/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormModelUpdateListener;
import org.apache.wicket.markup.html.form.IFormSubmitListener;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.IFormVisitorParticipant;
import org.apache.wicket.markup.html.form.persistence.CookieValuePersister;
import org.apache.wicket.markup.html.form.persistence.IValuePersister;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WicketURLDecoder;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.listener.IListenerInterfaceRequestTarget;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.upload.FileUploadBase;
import org.apache.wicket.util.upload.FileUploadException;
import org.apache.wicket.validation.IValidatorAddListener;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form<T>
extends WebMarkupContainer
implements IFormSubmitListener,
IHeaderContributor {
    private static final String HIDDEN_DIV_START = "<div style=\"width:0px;height:0px;position:absolute;left:-100px;top:-100px;overflow:hidden\">";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private static final short FLAG_SUBMITTED = 256;
    private static final Logger log = LoggerFactory.getLogger(Form.class);
    private static final long serialVersionUID = 1L;
    private static final String UPLOAD_FAILED_RESOURCE_KEY = "uploadFailed";
    private static final String UPLOAD_TOO_LARGE_RESOURCE_KEY = "uploadTooLarge";
    private IFormSubmittingComponent defaultSubmittingComponent;
    private Object formValidators = null;
    private Bytes maxSize = null;
    private short multiPart = 0;
    private static final short MULTIPART_HARD = 1;
    private static final short MULTIPART_HINT = 2;

    public Form(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    public Form(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    public void add(IFormValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("Argument `validator` cannot be null");
        }
        this.formValidators_add(validator);
        if (validator instanceof IValidatorAddListener) {
            ((IValidatorAddListener)((Object)validator)).onAdded(this);
        }
    }

    public void remove(IFormValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("Argument `validator` cannot be null");
        }
        IFormValidator removed = this.formValidators_remove(validator);
        if (removed == null) {
            throw new IllegalStateException("Tried to remove form validator that was not previously added. Make sure your validator's equals() implementation is sufficient");
        }
        this.addStateChange(new FormValidatorRemovedChange(removed));
    }

    private final int formValidators_indexOf(IFormValidator validator) {
        if (this.formValidators != null) {
            if (this.formValidators instanceof IFormValidator) {
                IFormValidator v = (IFormValidator)this.formValidators;
                if (v == validator || v.equals(validator)) {
                    return 0;
                }
            } else {
                IFormValidator[] validators = (IFormValidator[])this.formValidators;
                for (int i = 0; i < validators.length; ++i) {
                    IFormValidator v = validators[i];
                    if (v != validator && !v.equals(validator)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private final IFormValidator formValidators_remove(IFormValidator validator) {
        int index = this.formValidators_indexOf(validator);
        if (index != -1) {
            return this.formValidators_remove(index);
        }
        return null;
    }

    private final IFormValidator formValidators_remove(int index) {
        if (this.formValidators instanceof IFormValidator) {
            if (index == 0) {
                IFormValidator removed = (IFormValidator)this.formValidators;
                this.formValidators = null;
                return removed;
            }
            throw new IndexOutOfBoundsException();
        }
        IFormValidator[] validators = (IFormValidator[])this.formValidators;
        IFormValidator removed = validators[index];
        if (validators.length == 2) {
            this.formValidators = validators[1 - index];
        } else {
            IFormValidator[] newValidators = new IFormValidator[validators.length - 1];
            int j = 0;
            for (int i = 0; i < validators.length; ++i) {
                if (i == index) continue;
                newValidators[j++] = validators[i];
            }
            this.formValidators = newValidators;
        }
        return removed;
    }

    public final void clearInput() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            @Override
            public void onFormComponent(FormComponent<?> formComponent) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.clearInput();
                }
            }
        });
    }

    public final void error(String error, Map<String, Object> args) {
        this.error((Serializable)((Object)new MapVariableInterpolator(error, args).toString()));
    }

    public final IFormSubmittingComponent findSubmittingButton() {
        IFormSubmittingComponent submittingComponent = (IFormSubmittingComponent)this.getPage().visitChildren(IFormSubmittingComponent.class, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                IFormSubmittingComponent submittingComponent = (IFormSubmittingComponent)((Object)component);
                Form<?> form = submittingComponent.getForm();
                if (form != null && form.getRootForm() == Form.this) {
                    String name = submittingComponent.getInputName();
                    if (Form.this.getRequest().getParameter(name) != null || Form.this.getRequest().getParameter(name + ".x") != null) {
                        if (!component.isVisibleInHierarchy()) {
                            throw new WicketRuntimeException("Submit Button " + submittingComponent.getInputName() + " (path=" + component.getPageRelativePath() + ") is not visible");
                        }
                        if (!component.isEnabledInHierarchy()) {
                            throw new WicketRuntimeException("Submit Button " + submittingComponent.getInputName() + " (path=" + component.getPageRelativePath() + ") is not enabled");
                        }
                        return submittingComponent;
                    }
                }
                return CONTINUE_TRAVERSAL;
            }
        });
        return submittingComponent;
    }

    public final IFormSubmittingComponent getDefaultButton() {
        if (this.isRootForm()) {
            return this.defaultSubmittingComponent;
        }
        return this.getRootForm().getDefaultButton();
    }

    public final Collection<IFormValidator> getFormValidators() {
        int size = this.formValidators_size();
        List validators = null;
        if (size == 0) {
            validators = Collections.emptyList();
        } else {
            validators = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                validators.add(this.formValidators_get(i));
            }
        }
        return Collections.unmodifiableCollection(validators);
    }

    public final CharSequence getJsForInterfaceUrl(CharSequence url) {
        Form<?> root = this.getRootForm();
        return new AppendingStringBuffer("document.getElementById('").append(root.getHiddenFieldId()).append("').value='").append(url).append("';document.getElementById('").append(root.getMarkupId()).append("').submit();");
    }

    public Bytes getMaxSize() {
        Bytes maxSize = this.maxSize;
        if (maxSize == null) {
            maxSize = (Bytes)this.visitChildren(Form.class, new Component.IVisitor<Form<?>>(){

                @Override
                public Object component(Form<?> component) {
                    Bytes maxSize = component.getMaxSize();
                    if (maxSize != null) {
                        return maxSize;
                    }
                    return CONTINUE_TRAVERSAL;
                }
            });
        }
        if (maxSize == null) {
            return this.getApplication().getApplicationSettings().getDefaultMaximumUploadSize();
        }
        return maxSize;
    }

    public Form<?> getRootForm() {
        Form form;
        Form parent = this;
        while ((parent = (form = parent).findParent(Form.class)) != null) {
        }
        return form;
    }

    public String getValidatorKeyPrefix() {
        return null;
    }

    public final boolean hasError() {
        if (this.hasErrorMessage()) {
            return true;
        }
        return this.anyFormComponentError();
    }

    public boolean isRootForm() {
        return this.findParent(Form.class) == null;
    }

    public final boolean isSubmitted() {
        return this.getFlag((short)256);
    }

    @Override
    public boolean isVersioned() {
        return super.isVersioned();
    }

    public final void loadPersistentFormComponentValues() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            @Override
            public void onFormComponent(FormComponent<?> formComponent) {
                if (formComponent.isPersistent() && formComponent.isVisibleInHierarchy()) {
                    IValuePersister persister = Form.this.getValuePersister();
                    persister.load(formComponent);
                }
            }
        });
    }

    @Override
    public final void onFormSubmitted() {
        this.markFormsSubmitted();
        if (this.handleMultiPart()) {
            this.inputChanged();
            String url = this.getRequest().getParameter(this.getHiddenFieldId());
            if (!Strings.isEmpty(url)) {
                this.dispatchEvent(this.getPage(), url);
            } else {
                IFormSubmittingComponent submittingComponent = this.findSubmittingButton();
                if (submittingComponent != null && !submittingComponent.getDefaultFormProcessing()) {
                    submittingComponent.onSubmit();
                } else {
                    Form<?> formToProcess = this;
                    if (submittingComponent != null) {
                        formToProcess = submittingComponent.getForm();
                    }
                    formToProcess.process(submittingComponent);
                }
            }
        } else if (this.hasError()) {
            this.callOnError();
        }
    }

    public void process(IFormSubmittingComponent submittingComponent) {
        PageParameters parameters;
        Page page = this.getPage();
        if (this.process()) {
            this.delegateSubmit(submittingComponent);
        }
        if ((parameters = page.getPageParameters()) != null) {
            this.visitFormComponents(new FormComponent.IVisitor(){

                public Object formComponent(IFormVisitorParticipant formComponent) {
                    if (formComponent instanceof FormComponent) {
                        parameters.remove(((FormComponent)formComponent).getInputName());
                    }
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
            });
            parameters.remove(this.getHiddenFieldId());
        }
    }

    @Deprecated
    public boolean process() {
        if (!this.isEnabledInHierarchy() || !this.isVisibleInHierarchy()) {
            return false;
        }
        this.validate();
        if (this.hasError()) {
            this.markFormComponentsInvalid();
            this.callOnError();
            return false;
        }
        this.markFormComponentsValid();
        this.beforeUpdateFormComponentModels();
        this.updateFormComponentModels();
        this.persistFormComponentData();
        return true;
    }

    private void callOnError() {
        this.onError();
        this.visitChildren(Form.class, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                Form form = (Form)component;
                if (!form.isEnabledInHierarchy() || !form.isVisibleInHierarchy()) {
                    return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                }
                if (form.hasError()) {
                    form.onError();
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
    }

    private void markFormsSubmitted() {
        this.setFlag((short)256, true);
        this.visitChildren(Form.class, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                Form form = (Form)component;
                if (form.isEnabledInHierarchy() && Form.this.isVisibleInHierarchy()) {
                    form.setFlag((short)256, true);
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    public void removePersistentFormComponentValues(final boolean disablePersistence) {
        final IValuePersister persister = this.getValuePersister();
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            @Override
            public void onFormComponent(FormComponent<?> formComponent) {
                if (formComponent.isVisibleInHierarchy()) {
                    persister.clear(formComponent);
                    if (formComponent.isPersistent() && disablePersistence) {
                        formComponent.setPersistent(false);
                    }
                }
            }
        });
    }

    public final void setDefaultButton(IFormSubmittingComponent submittingComponent) {
        if (this.isRootForm()) {
            this.defaultSubmittingComponent = submittingComponent;
        } else {
            this.getRootForm().setDefaultButton(submittingComponent);
        }
    }

    public void setMaxSize(Bytes maxSize) {
        this.maxSize = maxSize;
    }

    public void setMultiPart(boolean multiPart) {
        this.multiPart = multiPart ? (short)(this.multiPart | 1) : (short)(this.multiPart & 0xFFFFFFFE);
    }

    @Override
    public final Component setVersioned(final boolean isVersioned) {
        super.setVersioned(isVersioned);
        this.visitFormComponents(new FormComponent.AbstractVisitor(){

            @Override
            public void onFormComponent(FormComponent<?> formComponent) {
                formComponent.setVersioned(isVersioned);
            }
        });
        return this;
    }

    public final void visitFormComponents(final FormComponent.IVisitor visitor) {
        this.visitChildren(FormComponent.class, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                visitor.formComponent((FormComponent)component);
                return CONTINUE_TRAVERSAL;
            }
        });
        this.visitChildrenInContainingBorder(visitor);
    }

    public final void visitFormComponentsPostOrder(FormComponent.IVisitor visitor) {
        FormComponent.visitFormComponentsPostOrder(this, visitor);
        if (this.getParent() instanceof Border) {
            FormComponent.visitFormComponentsPostOrder(this.getParent(), visitor);
        }
    }

    private void visitChildrenInContainingBorder(FormComponent.IVisitor visitor) {
        if (this.getParent() instanceof Border) {
            MarkupContainer border = this.getParent();
            Iterator<? extends Component> iter = border.iterator();
            while (iter.hasNext()) {
                Component child = iter.next();
                if (!(child instanceof FormComponent)) continue;
                visitor.formComponent((FormComponent)child);
            }
        }
    }

    private boolean anyFormComponentError() {
        final boolean[] error = new boolean[]{false};
        final Component.IVisitor<Component> visitor = new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                if (component.hasErrorMessage()) {
                    error[0] = true;
                    return Component.IVisitor.STOP_TRAVERSAL;
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        };
        this.visitChildren(Component.class, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                return visitor.component(component);
            }
        });
        if (!error[0] && this.getParent() instanceof Border) {
            MarkupContainer border = this.getParent();
            border.visitChildren(Component.class, new Component.IVisitor<Component>(){

                @Override
                public Object component(Component component) {
                    if (component == Form.this || !(component instanceof FormComponent)) {
                        return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                    }
                    return visitor.component(component);
                }
            });
        }
        return error[0];
    }

    private void dispatchEvent(Page page, String url) {
        RequestParameters requestParameters;
        RequestCycle rc = RequestCycle.get();
        IRequestCycleProcessor processor = rc.getProcessor();
        IRequestTarget rt = processor.resolve(rc, requestParameters = processor.getRequestCodingStrategy().decode(new FormDispatchRequest(rc.getRequest(), url)));
        if (!(rt instanceof IListenerInterfaceRequestTarget)) {
            throw new WicketRuntimeException("Attempt to access unknown request listener interface " + requestParameters.getInterfaceName());
        }
        IListenerInterfaceRequestTarget interfaceTarget = (IListenerInterfaceRequestTarget)rt;
        interfaceTarget.getRequestListenerInterface().invoke(page, interfaceTarget.getTarget());
    }

    private void formValidators_add(IFormValidator validator) {
        if (this.formValidators == null) {
            this.formValidators = validator;
        } else {
            int size = this.formValidators_size();
            IFormValidator[] validators = new IFormValidator[size + 1];
            for (int i = 0; i < size; ++i) {
                validators[i] = this.formValidators_get(i);
            }
            validators[size] = validator;
            this.formValidators = validators;
        }
    }

    private IFormValidator formValidators_get(int index) {
        if (this.formValidators == null) {
            throw new IndexOutOfBoundsException();
        }
        if (this.formValidators instanceof IFormValidator[]) {
            return ((IFormValidator[])this.formValidators)[index];
        }
        return (IFormValidator)this.formValidators;
    }

    private int formValidators_size() {
        if (this.formValidators == null) {
            return 0;
        }
        if (this.formValidators instanceof IFormValidator[]) {
            return ((IFormValidator[])this.formValidators).length;
        }
        return 1;
    }

    private void inputChanged() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            @Override
            public void onFormComponent(FormComponent<?> formComponent) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.inputChanged();
                }
            }
        });
    }

    private void persistFormComponentData() {
        if (this.getRequestCycle() instanceof WebRequestCycle) {
            final IValuePersister persister = this.getValuePersister();
            this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

                @Override
                public void onFormComponent(FormComponent<?> formComponent) {
                    if (formComponent.isVisibleInHierarchy()) {
                        if (formComponent.isPersistent()) {
                            persister.save(formComponent);
                        } else {
                            persister.clear(formComponent);
                        }
                    }
                }
            });
        }
    }

    protected void appendDefaultButtonField(MarkupStream markupStream, ComponentTag openTag) {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append(HIDDEN_DIV_START);
        buffer.append("<input type=\"text\" autocomplete=\"false\"/>");
        Component submittingComponent = (Component)((Object)this.defaultSubmittingComponent);
        buffer.append("<input type=\"submit\" name=\"");
        buffer.append(this.defaultSubmittingComponent.getInputName());
        buffer.append("\" onclick=\" var b=document.getElementById('");
        buffer.append(submittingComponent.getMarkupId());
        buffer.append("'); if (b!=null&amp;&amp;b.onclick!=null&amp;&amp;typeof(b.onclick) != 'undefined') {  var r = b.onclick.bind(b)(); if (r != false) b.click(); } else { b.click(); };  return false;\" ");
        buffer.append(" />");
        buffer.append("</div>");
        this.getResponse().write(buffer);
    }

    protected void beforeUpdateFormComponentModels() {
    }

    protected void delegateSubmit(IFormSubmittingComponent submittingComponent) {
        Form<Form> formToProcess = this;
        if (submittingComponent != null) {
            formToProcess = submittingComponent.getForm();
            submittingComponent.onSubmit();
        }
        formToProcess.onSubmit();
        formToProcess.visitChildren(Form.class, new Component.IVisitor<Form<?>>(){

            @Override
            public Object component(Form<?> component) {
                Form<?> form = component;
                if (form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    form.onSubmit();
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    public final String getHiddenFieldId() {
        return this.getInputNamePrefix() + this.getMarkupId() + "_hf_0";
    }

    @Deprecated
    protected final String getJavascriptId() {
        return this.getMarkupId();
    }

    protected String getMethod() {
        String method = this.getMarkupAttributes().getString("method");
        return method != null ? method : METHOD_POST;
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }

    protected IValuePersister getValuePersister() {
        return new CookieValuePersister();
    }

    private boolean isMultiPart() {
        if (this.multiPart != 0) {
            return true;
        }
        final boolean[] anyEmbeddedMultipart = new boolean[]{false};
        this.visitChildren(Component.class, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                FormComponent fc;
                boolean isMultiPart = false;
                if (component instanceof Form) {
                    Form form = (Form)component;
                    if (form.isVisibleInHierarchy() && form.isEnabledInHierarchy()) {
                        isMultiPart = form.multiPart != 0;
                    }
                } else if (component instanceof FormComponent && (fc = (FormComponent)component).isVisibleInHierarchy() && fc.isEnabledInHierarchy()) {
                    isMultiPart = fc.isMultiPart();
                }
                if (isMultiPart) {
                    anyEmbeddedMultipart[0] = true;
                    return STOP_TRAVERSAL;
                }
                return CONTINUE_TRAVERSAL;
            }
        });
        if (anyEmbeddedMultipart[0]) {
            this.multiPart = (short)(this.multiPart | 2);
        }
        return anyEmbeddedMultipart[0];
    }

    protected boolean handleMultiPart() {
        if (this.isMultiPart()) {
            try {
                WebRequest multipartWebRequest = ((WebRequest)this.getRequest()).newMultipartWebRequest(this.getMaxSize());
                this.getRequestCycle().setRequest(multipartWebRequest);
            }
            catch (WicketRuntimeException wre) {
                if (wre.getCause() == null || !(wre.getCause() instanceof FileUploadException)) {
                    throw wre;
                }
                FileUploadException e = (FileUploadException)wre.getCause();
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("exception", e);
                model.put("maxSize", this.getMaxSize());
                this.onFileUploadException((FileUploadException)wre.getCause(), model);
                return false;
            }
        }
        return true;
    }

    protected void onFileUploadException(FileUploadException e, Map<String, Object> model) {
        if (e instanceof FileUploadBase.SizeLimitExceededException) {
            String defaultValue = "Upload must be less than " + this.getMaxSize();
            String msg = this.getString(this.getId() + "." + UPLOAD_TOO_LARGE_RESOURCE_KEY, Model.ofMap(model), defaultValue);
            this.error((Serializable)((Object)msg));
        } else {
            String defaultValue = "Upload failed: " + e.getLocalizedMessage();
            String msg = this.getString(this.getId() + "." + UPLOAD_FAILED_RESOURCE_KEY, Model.ofMap(model), defaultValue);
            this.error((Serializable)((Object)msg));
            log.warn(msg, (Throwable)e);
        }
    }

    @Override
    protected void internalOnModelChanged() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            @Override
            public void onFormComponent(FormComponent<?> formComponent) {
                if (formComponent.sameInnermostModel(Form.this)) {
                    formComponent.modelChanged();
                }
            }
        });
    }

    protected final void markFormComponentsInvalid() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            @Override
            public void onFormComponent(FormComponent<?> formComponent) {
                if (formComponent.isVisibleInHierarchy()) {
                    formComponent.invalid();
                }
            }
        });
    }

    protected final void markFormComponentsValid() {
        this.internalMarkFormComponentsValid();
        this.markNestedFormComponentsValid();
    }

    private void markNestedFormComponentsValid() {
        this.visitChildren(Form.class, new Component.IVisitor<Form<?>>(){

            @Override
            public Object component(Form<?> component) {
                Form<?> form = component;
                if (form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    ((Form)form).internalMarkFormComponentsValid();
                    return CONTINUE_TRAVERSAL;
                }
                return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    private void internalMarkFormComponentsValid() {
        this.visitFormComponentsPostOrder(new FormComponent.AbstractVisitor(){

            @Override
            public void onFormComponent(FormComponent<?> formComponent) {
                if (formComponent.getForm() == Form.this && formComponent.isVisibleInHierarchy()) {
                    formComponent.valid();
                }
            }
        });
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "form");
        if (this.isRootForm()) {
            String method = this.getMethod().toLowerCase();
            tag.put("method", method);
            String url = ((Object)this.urlFor(IFormSubmitListener.INTERFACE)).toString();
            if (this.encodeUrlInHiddenFields()) {
                int i = url.indexOf(63);
                String action = i > -1 ? url.substring(0, i) : "";
                tag.put("action", action);
            } else {
                tag.put("action", Strings.escapeMarkup(url));
            }
            if (this.isMultiPart()) {
                tag.put("enctype", "multipart/form-data");
            } else {
                String enctype = (String)tag.getAttributes().get("enctype");
                if ("multipart/form-data".equalsIgnoreCase(enctype)) {
                    this.setMultiPart(true);
                }
            }
        } else {
            tag.setName("div");
            tag.remove("method");
            tag.remove("action");
            tag.remove("enctype");
        }
    }

    @Override
    protected void renderPlaceholderTag(ComponentTag tag, Response response) {
        if (this.isRootForm()) {
            super.renderPlaceholderTag(tag, response);
        } else {
            response.write("<div style=\"display:none\"");
            if (this.getOutputMarkupId()) {
                response.write(" id=\"");
                response.write(this.getMarkupId());
                response.write("\"");
            }
            response.write("></div>");
        }
    }

    protected boolean encodeUrlInHiddenFields() {
        String method = this.getMethod().toLowerCase();
        return method.equals(METHOD_GET);
    }

    @Override
    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (this.isRootForm()) {
            Component submittingComponent;
            String nameAndId = this.getHiddenFieldId();
            AppendingStringBuffer buffer = new AppendingStringBuffer(HIDDEN_DIV_START).append("<input type=\"hidden\" name=\"").append(nameAndId).append("\" id=\"").append(nameAndId).append("\" />");
            if (this.encodeUrlInHiddenFields()) {
                String url = ((Object)this.urlFor(IFormSubmitListener.INTERFACE)).toString();
                int i = url.indexOf(63);
                String[] params = (i > -1 ? url.substring(i + 1) : url).split("&");
                this.writeParamsAsHiddenFields(params, buffer);
            }
            buffer.append("</div>");
            this.getResponse().write(buffer);
            if (this.defaultSubmittingComponent instanceof Component && (submittingComponent = (Component)((Object)this.defaultSubmittingComponent)).isVisibleInHierarchy() && submittingComponent.isEnabledInHierarchy()) {
                this.appendDefaultButtonField(markupStream, openTag);
            }
        }
        super.onComponentTagBody(markupStream, openTag);
    }

    protected void writeParamsAsHiddenFields(String[] params, AppendingStringBuffer buffer) {
        for (int j = 0; j < params.length; ++j) {
            String[] pair = params[j].split("=");
            buffer.append("<input type=\"hidden\" name=\"").append(this.recode(pair[0])).append("\" value=\"").append(pair.length > 1 ? this.recode(pair[1]) : "").append("\" />");
        }
    }

    private String recode(String s) {
        String un = WicketURLDecoder.QUERY_INSTANCE.decode(s);
        return ((Object)Strings.escapeMarkup(un)).toString();
    }

    @Override
    protected void onDetach() {
        super.internalOnDetach();
        this.setFlag((short)256, false);
        super.onDetach();
    }

    protected void onError() {
    }

    @Override
    protected void onBeforeRender() {
        this.multiPart = (short)(this.multiPart & 0xFFFFFFFD);
        super.onBeforeRender();
    }

    protected void onSubmit() {
    }

    protected final void updateFormComponentModels() {
        this.internalUpdateFormComponentModels();
        this.updateNestedFormComponentModels();
    }

    private final void updateNestedFormComponentModels() {
        this.visitChildren(Form.class, new Component.IVisitor<Form<?>>(){

            @Override
            public Object component(Form<?> form) {
                if (form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    ((Form)form).internalUpdateFormComponentModels();
                    return CONTINUE_TRAVERSAL;
                }
                return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    private void internalUpdateFormComponentModels() {
        FormComponent.visitComponentsPostOrder(this, new FormModelUpdateVisitor(this));
        MarkupContainer border = this.findParent(Border.class);
        if (border != null) {
            FormComponent.visitComponentsPostOrder(border, new FormModelUpdateVisitor(this));
        }
    }

    protected final void validate() {
        if (this.isEnabledInHierarchy() && this.isVisibleInHierarchy()) {
            this.validateComponents();
            this.validateFormValidators();
            this.onValidate();
            this.validateNestedForms();
        }
    }

    protected void onValidate() {
    }

    protected final void validateComponents() {
        this.visitFormComponentsPostOrder(new ValidationVisitor(){

            @Override
            public void validate(FormComponent<?> formComponent) {
                Form<?> form = formComponent.getForm();
                if (form == Form.this && form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    formComponent.validate();
                }
            }
        });
    }

    private boolean isFormComponentVisibleInPage(FormComponent<?> fc) {
        if (fc == null) {
            throw new IllegalArgumentException("Argument `fc` cannot be null");
        }
        return fc.isVisibleInHierarchy();
    }

    protected final void validateFormValidator(IFormValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException("Argument [[validator]] cannot be null");
        }
        FormComponent<?>[] dependents = validator.getDependentFormComponents();
        boolean validate = true;
        if (dependents != null) {
            for (int j = 0; j < dependents.length; ++j) {
                FormComponent<?> dependent = dependents[j];
                if (!dependent.isValid()) {
                    validate = false;
                    break;
                }
                if (this.isFormComponentVisibleInPage(dependent)) continue;
                if (log.isWarnEnabled()) {
                    log.warn("IFormValidator in form `" + this.getPageRelativePath() + "` depends on a component that has been removed from the page or is no longer visible. " + "Offending component id `" + dependent.getId() + "`.");
                }
                validate = false;
                break;
            }
        }
        if (validate) {
            validator.validate(this);
        }
    }

    protected final void validateFormValidators() {
        int count = this.formValidators_size();
        for (int i = 0; i < count; ++i) {
            this.validateFormValidator(this.formValidators_get(i));
        }
    }

    private void validateNestedForms() {
        this.visitChildren(Form.class, new Component.IVisitor<Form<?>>(){

            @Override
            public Object component(Form<?> form) {
                if (form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
                    form.validateComponents();
                    form.validateFormValidators();
                    form.onValidate();
                    return CONTINUE_TRAVERSAL;
                }
                return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    protected String getInputNamePrefix() {
        return "";
    }

    public final IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public final void setModel(IModel<T> model) {
        this.setDefaultModel((IModel)model);
    }

    public final T getModelObject() {
        return (T)this.getDefaultModelObject();
    }

    public final void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }

    public static Form<?> findForm(Component component) {
        Form<?> form = component.findParent(Form.class);
        if (form == null) {
            Border border = component.findParent(Border.class);
            while (form == null && border != null) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class FindFormVisitor
                implements Component.IVisitor<Form<?>> {
                    Form<?> form = null;

                    FindFormVisitor() {
                    }

                    @Override
                    public Object component(Form<?> component) {
                        this.form = component;
                        return Component.IVisitor.STOP_TRAVERSAL;
                    }
                }
                FindFormVisitor formVisitor = new FindFormVisitor();
                border.visitChildren(Form.class, formVisitor);
                form = formVisitor.form;
                if (form != null) continue;
                border = border.findParent(Border.class);
            }
        }
        return form;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        if (!this.isRootForm() && this.isMultiPart()) {
            this.registerJavascriptNamespaces(response);
            response.renderJavascript("Wicket.Forms[\"" + this.getMarkupId() + "\"]={multipart:true};", Form.class.getName() + "." + this.getMarkupId() + ".metadata");
        }
    }

    protected void registerJavascriptNamespaces(IHeaderResponse response) {
        response.renderJavascript("if (typeof(Wicket)=='undefined') { Wicket={}; } if (typeof(Wicket.Forms)=='undefined') { Wicket.Forms={}; }", Form.class.getName());
    }

    private class FormValidatorRemovedChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final IFormValidator removed;

        public FormValidatorRemovedChange(IFormValidator removed) {
            this.removed = removed;
        }

        public void undo() {
            Form.this.add(this.removed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FormDispatchRequest
    extends Request {
        private final Map<String, String[]> params = new HashMap<String, String[]>();
        private final Request realRequest;
        private final String url;

        public FormDispatchRequest(Request realRequest, String url) {
            this.realRequest = realRequest;
            this.url = realRequest.decodeURL(url);
            String queryString = this.url.substring(this.url.indexOf("?") + 1);
            RequestUtils.decodeUrlParameters(queryString, this.params);
        }

        @Override
        public Locale getLocale() {
            return this.realRequest.getLocale();
        }

        @Override
        public String getParameter(String key) {
            String[] p = this.params.get(key);
            return p != null && p.length > 0 ? p[0] : null;
        }

        @Override
        public Map<String, String[]> getParameterMap() {
            return this.params;
        }

        @Override
        public String[] getParameters(String key) {
            String[] param = this.params.get(key);
            if (param != null) {
                return param;
            }
            return new String[0];
        }

        @Override
        public String getPath() {
            return this.realRequest.getPath();
        }

        @Override
        public String getRelativePathPrefixToContextRoot() {
            return this.realRequest.getRelativePathPrefixToContextRoot();
        }

        @Override
        public String getRelativePathPrefixToWicketHandler() {
            return this.realRequest.getRelativePathPrefixToWicketHandler();
        }

        @Override
        public String getURL() {
            return this.url;
        }

        @Override
        public String getQueryString() {
            return this.realRequest.getQueryString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FormModelUpdateVisitor
    implements Component.IVisitor<Component> {
        private final Form<?> formFilter;

        public FormModelUpdateVisitor(Form<?> formFilter) {
            this.formFilter = formFilter;
        }

        @Override
        public Object component(Component component) {
            Form<?> form;
            if (component instanceof IFormModelUpdateListener && (form = Form.findForm(component)) != null && (this.formFilter == null || this.formFilter == form) && form.isEnabledInHierarchy() && component.isVisibleInHierarchy() && component.isEnabledInHierarchy()) {
                ((IFormModelUpdateListener)((Object)component)).updateModel();
            }
            return Component.IVisitor.CONTINUE_TRAVERSAL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ValidationVisitor
    implements FormComponent.IVisitor {
        @Override
        public Object formComponent(IFormVisitorParticipant component) {
            if (component instanceof FormComponent) {
                FormComponent formComponent = (FormComponent)component;
                Form<?> form = formComponent.getForm();
                if (!form.isVisibleInHierarchy() || !form.isEnabledInHierarchy()) {
                    return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                }
                if (formComponent.isVisibleInHierarchy() && formComponent.isValid() && formComponent.isEnabledInHierarchy()) {
                    this.validate(formComponent);
                }
            }
            if (component.processChildren()) {
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
            return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
        }

        public abstract void validate(FormComponent<?> var1);
    }
}

