/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.internal.AutoMarkupLabel;
import org.apache.wicket.markup.html.internal.DirectChildTagIterator;
import org.apache.wicket.markup.html.internal.ResponseBufferZone;
import org.apache.wicket.markup.resolver.ComponentResolvers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enclosure
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Enclosure.class);
    private Component childComponent;
    private final CharSequence childId;
    private transient Map<Component, Boolean> changes;

    public Enclosure(String id, CharSequence childId) {
        super(id);
        if (childId == null) {
            throw new MarkupException("You most likely forgot to register the EnclosureHandler with the MarkupParserFactory");
        }
        this.childId = childId;
    }

    public boolean isTransparentResolver() {
        return true;
    }

    private MarkupContainer getEnclosureParent() {
        MarkupContainer parent = this.getParent();
        while (parent != null) {
            if (parent.isTransparentResolver()) {
                parent = parent.getParent();
                continue;
            }
            if (!(parent instanceof Border.BorderBodyContainer)) break;
            parent = parent.findParent(Border.class);
        }
        if (parent == null) {
            throw new WicketRuntimeException("Unable to find parent component which is not a transparent resolver");
        }
        return parent;
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag enclosureOpenTag) {
        this.changes = new HashMap<Component, Boolean>();
        MarkupContainer container = this.getEnclosureParent();
        this.ensureAllChildrenPresent(container, markupStream, enclosureOpenTag);
        Component controller = container.get(((Object)this.childId).toString());
        this.checkChildComponent(controller, this.childId);
        this.setVisible(controller.determineVisibility());
        this.applyEnclosureVisibilityToChildren(container, markupStream, enclosureOpenTag);
        this.warnAboutFormComponentsInsideEnclosure(container, markupStream, enclosureOpenTag);
        if (this.isVisible()) {
            super.onComponentTagBody(markupStream, enclosureOpenTag);
        } else {
            markupStream.skipToMatchingCloseTag(enclosureOpenTag);
        }
    }

    private void warnAboutFormComponentInsideEnclosure(FormComponent fc) {
        log.warn("Found a form component {}/{} inside an enclosure. Form components do not work well inside wicket:enclosure tags, use EnclosureContainer instead", (Object)fc.getClass().getSimpleName(), (Object)fc.getPageRelativePath());
    }

    private void warnAboutFormComponentsInsideEnclosure(MarkupContainer container, MarkupStream markupStream, ComponentTag enclosureOpenTag) {
        if (!"development".equals(this.getApplication().getConfigurationType())) {
            return;
        }
        DirectChildTagIterator it = new DirectChildTagIterator(markupStream, enclosureOpenTag);
        while (it.hasNext()) {
            ComponentTag tag = it.next();
            if (tag.isAutoComponentTag()) continue;
            Component child = container.get(tag.getId());
            if (child instanceof FormComponent) {
                this.warnAboutFormComponentInsideEnclosure((FormComponent)child);
                continue;
            }
            if (!(child instanceof MarkupContainer)) continue;
            ((MarkupContainer)child).visitChildren(FormComponent.class, new Component.IVisitor<FormComponent<?>>(){

                @Override
                public Object component(FormComponent<?> component) {
                    Enclosure.this.warnAboutFormComponentInsideEnclosure(component);
                    return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                }
            });
        }
        it.rewind();
    }

    private void applyEnclosureVisibilityToChildren(MarkupContainer container, MarkupStream markupStream, ComponentTag enclosureOpenTag) {
        DirectChildTagIterator it = new DirectChildTagIterator(markupStream, enclosureOpenTag);
        while (it.hasNext()) {
            ComponentTag tag = it.next();
            if (tag.isAutoComponentTag()) continue;
            Component child = container.get(tag.getId());
            boolean childVisibility = child.isVisibilityAllowed();
            if (this.isVisible() || !childVisibility) continue;
            this.changes.put(child, childVisibility);
            child.setVisibilityAllowed(false);
        }
        it.rewind();
    }

    private void checkChildComponent(Component child, CharSequence id) {
        if (child == null) {
            throw new WicketRuntimeException("Could not find child with id: " + id + " in the wicket:enclosure");
        }
        if (child == this) {
            throw new WicketRuntimeException("Programming error: childComponent == enclose component; endless loop");
        }
    }

    private void ensureAllChildrenPresent(final MarkupContainer container, final MarkupStream markupStream, ComponentTag enclosureOpenTag) {
        DirectChildTagIterator it = new DirectChildTagIterator(markupStream, enclosureOpenTag);
        while (it.hasNext()) {
            Component child;
            final ComponentTag tag = it.next();
            if (tag.isAutoComponentTag() || (child = container.get(tag.getId())) != null) continue;
            CharSequence buffer = new ResponseBufferZone(this.getRequestCycle(), markupStream){

                protected void executeInsideBufferedZone() {
                    int ind = markupStream.findComponentIndex(tag.getPath(), tag.getId());
                    markupStream.setCurrentIndex(ind);
                    ComponentResolvers.resolve(Enclosure.this.getApplication(), container, markupStream, tag);
                }
            }.execute();
            child = container.get(tag.getId());
            this.checkChildComponent(child, tag.getId());
            if (buffer.length() <= 0) continue;
            AutoMarkupLabel stub = new AutoMarkupLabel(child.getId(), buffer);
            container.replace(stub);
        }
        it.rewind();
    }

    protected void onDetach() {
        this.restoreOriginalChildVisibility();
        super.onDetach();
    }

    private void restoreOriginalChildVisibility() {
        if (this.changes != null) {
            MarkupContainer container = this.getEnclosureParent();
            for (Map.Entry<Component, Boolean> entry : this.changes.entrySet()) {
                entry.getKey().setVisibilityAllowed(entry.getValue());
            }
            this.changes = null;
        }
    }
}

