/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.Serializable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.wicket.Application;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.version.IPageVersionManager;
import org.apache.wicket.version.undo.UndoPageVersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpSessionStore
implements ISessionStore {
    private static Logger log = LoggerFactory.getLogger(AbstractHttpSessionStore.class);
    protected final WebApplication application;

    public AbstractHttpSessionStore(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("the application object must be provided");
        }
        if (!(application instanceof WebApplication)) {
            throw new IllegalStateException(this.getClass().getName() + " can only operate in the context of web applications");
        }
        this.application = (WebApplication)application;
    }

    public final void bind(Request request, Session newSession) {
        this.onBind(request, newSession);
        WebRequest webRequest = this.toWebRequest(request);
        HttpSession httpSession = this.getHttpSession(webRequest, true);
        String applicationKey = this.application.getApplicationKey();
        httpSession.setAttribute("Wicket:SessionUnbindingListener-" + applicationKey, (Object)new SessionBindingListener(applicationKey, httpSession.getId()));
        this.setAttribute(webRequest, "session", newSession);
    }

    @Deprecated
    public final IPageMap createPageMap(String name, Session session) {
        throw new UnsupportedOperationException("obsolete method");
    }

    public void destroy() {
    }

    public String getSessionId(Request request, boolean create) {
        String id = null;
        WebRequest webRequest = this.toWebRequest(request);
        HttpSession httpSession = webRequest.getHttpServletRequest().getSession(false);
        if (httpSession != null) {
            id = httpSession.getId();
        } else if (create) {
            httpSession = webRequest.getHttpServletRequest().getSession(true);
            id = httpSession.getId();
            IRequestLogger logger = this.application.getRequestLogger();
            if (logger != null) {
                logger.sessionCreated(id);
            }
        }
        return id;
    }

    public final void invalidate(Request request) {
        WebRequest webRequest = this.toWebRequest(request);
        HttpSession httpSession = this.getHttpSession(webRequest);
        if (httpSession != null) {
            String applicationKey = this.application.getApplicationKey();
            try {
                SessionBindingListener l = (SessionBindingListener)httpSession.getAttribute("Wicket:SessionUnbindingListener-" + applicationKey);
                if (l != null) {
                    l.unbound = true;
                }
                this.unbind(httpSession.getId());
                httpSession.invalidate();
            }
            catch (IllegalStateException e) {
                log.warn("Error while invalidating Session Store: Session already invalidated", (Throwable)e);
            }
            catch (Exception e) {
                log.error("Error while invalidating Session Store: ", (Throwable)e);
            }
        }
    }

    public Session lookup(Request request) {
        String sessionId = this.getSessionId(request, false);
        if (sessionId != null) {
            WebRequest webRequest = this.toWebRequest(request);
            return (Session)this.getAttribute(webRequest, "session");
        }
        return null;
    }

    public IPageVersionManager newVersionManager(Page page) {
        return new UndoPageVersionManager(page, 20);
    }

    public void onBeginRequest(Request request) {
    }

    public void onEndRequest(Request request) {
    }

    public final void unbind(String sessionId) {
        this.onUnbind(sessionId);
        this.application.sessionDestroyed(sessionId);
    }

    protected final HttpSession getHttpSession(WebRequest request) {
        return this.getHttpSession(request, false);
    }

    protected final HttpSession getHttpSession(WebRequest request, boolean create) {
        return request.getHttpServletRequest().getSession(create);
    }

    protected void onBind(Request request, Session newSession) {
    }

    protected void onUnbind(String sessionId) {
    }

    protected final WebRequest toWebRequest(Request request) {
        if (request == null) {
            return null;
        }
        if (!(request instanceof WebRequest)) {
            throw new IllegalArgumentException(this.getClass().getName() + " can only work with WebRequests");
        }
        return (WebRequest)request;
    }

    protected static final class SessionBindingListener
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String applicationKey;
        private final String sessionId;
        private boolean unbound = false;

        public SessionBindingListener(String applicationKey, String sessionId) {
            this.applicationKey = applicationKey;
            this.sessionId = sessionId;
        }

        public void valueBound(HttpSessionBindingEvent evg) {
        }

        public void valueUnbound(HttpSessionBindingEvent evt) {
            if (!this.unbound) {
                this.unbound = true;
                Application application = Application.get(this.applicationKey);
                if (application != null) {
                    application.getSessionStore().unbind(this.sessionId);
                }
            }
        }
    }
}

