/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.SecondLevelCacheSessionStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFilePageStore
implements SecondLevelCacheSessionStore.IPageStore {
    protected static Logger log = LoggerFactory.getLogger(TestFilePageStore.class);
    private final File defaultWorkDir;
    private final String appName;
    volatile long totalSavingTime = 0L;
    volatile long totalSerializationTime = 0L;
    private volatile int saved;
    private volatile int bytesSaved;

    @Override
    public void destroy() {
    }

    public TestFilePageStore() {
        this((File)((WebApplication)Application.get()).getServletContext().getAttribute("javax.servlet.context.tempdir"));
    }

    public TestFilePageStore(File dir) {
        this.defaultWorkDir = dir;
        this.appName = Application.get().getApplicationKey();
    }

    @Override
    public <T> Page getPage(String sessionId, String pagemap, int id, int versionNumber, int ajaxVersionNumber) {
        SessionPageKey currentKey = new SessionPageKey(sessionId, id, versionNumber, ajaxVersionNumber, pagemap, null);
        File sessionDir = new File(this.getWorkDir(), sessionId);
        File pageFile = this.getPageFile(currentKey, sessionDir);
        if (pageFile.exists()) {
            long t1 = System.currentTimeMillis();
            FileInputStream fis = null;
            try {
                byte[] pageData = null;
                fis = new FileInputStream(pageFile);
                int length = (int)pageFile.length();
                ByteBuffer bb = ByteBuffer.allocate(length);
                fis.getChannel().read(bb);
                if (bb.hasArray()) {
                    pageData = bb.array();
                } else {
                    pageData = new byte[length];
                    bb.get(pageData);
                }
                long t2 = System.currentTimeMillis();
                Page page = (Page)Objects.byteArrayToObject(pageData);
                page = page.getVersion(versionNumber);
                if (page != null && log.isDebugEnabled()) {
                    long t3 = System.currentTimeMillis();
                    log.debug("restoring page " + page.getClass() + "[" + page.getNumericId() + "," + page.getCurrentVersionNumber() + "] size: " + pageData.length + " for session " + sessionId + " took " + (t2 - t1) + " miliseconds to read in and " + (t3 - t2) + " miliseconds to deserialize");
                }
                Page ret = page;
                return ret;
            }
            catch (Exception e) {
                log.error("Error", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void pageAccessed(String sessionId, Page page) {
    }

    @Override
    public void removePage(String sessionId, String pageMapName, int pageId) {
    }

    @Override
    public void storePage(String sessionId, Page page) {
        SessionPageKey key = new SessionPageKey(sessionId, page);
        byte[] serialized = Objects.objectToByteArray(page);
        this.savePage(key, serialized);
    }

    @Override
    public void unbind(String sessionId) {
    }

    private File getPageFile(SessionPageKey key, File sessionDir) {
        return new File(sessionDir, this.appName + "-pm-" + key.pageMap + "-p-" + key.id + "-v-" + key.versionNumber + "-a-" + key.ajaxVersionNumber);
    }

    private File getWorkDir() {
        return this.defaultWorkDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePage(SessionPageKey key, byte[] bytes) {
        File sessionDir = new File(this.getWorkDir(), key.sessionId);
        sessionDir.mkdirs();
        File pageFile = this.getPageFile(key, sessionDir);
        FileOutputStream fos = null;
        long t1 = System.currentTimeMillis();
        int length = 0;
        try {
            fos = new FileOutputStream(pageFile);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            fos.getChannel().write(bb);
            length = bytes.length;
        }
        catch (Exception e) {
            log.error("Error saving page " + key.pageClassName + " [" + key.id + "," + key.versionNumber + "] for the sessionid " + key.sessionId);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {}
        }
        long t3 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("storing page " + key.pageClassName + "[" + key.id + "," + key.versionNumber + "] size: " + length + " for session " + key.sessionId + " took " + (t3 - t1) + " miliseconds to save");
        }
        this.totalSavingTime += t3 - t1;
        ++this.saved;
        this.bytesSaved += length;
    }

    @Override
    public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SessionPageKey {
        private final String sessionId;
        private final int id;
        private final int versionNumber;
        private final int ajaxVersionNumber;
        private final String pageMap;
        private final String pageClassName;

        SessionPageKey(String sessionId, Page page) {
            this(sessionId, page.getNumericId(), page.getCurrentVersionNumber(), page.getAjaxVersionNumber(), page.getPageMapName(), page.getClass());
        }

        <T extends Page> SessionPageKey(String sessionId, int id, int versionNumber, int ajaxVersionNumber, String pagemap, Class<T> pageClass) {
            this.sessionId = sessionId;
            this.id = id;
            this.versionNumber = versionNumber;
            this.ajaxVersionNumber = ajaxVersionNumber;
            this.pageClassName = pageClass.getName();
            this.pageMap = pagemap;
        }

        public int hashCode() {
            return this.sessionId.hashCode() + this.id + this.versionNumber;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SessionPageKey) {
                SessionPageKey key = (SessionPageKey)obj;
                return this.id == key.id && this.versionNumber == key.versionNumber && this.ajaxVersionNumber == key.ajaxVersionNumber && (this.pageMap != null && this.pageMap.equals(key.pageMap) || this.pageMap == null && key.pageMap == null) && this.sessionId.equals(key.sessionId);
            }
            return false;
        }

        public String toString() {
            return "SessionPageKey[" + this.sessionId + "," + this.id + "," + this.versionNumber + "," + this.ajaxVersionNumber + ", " + this.pageMap + "]";
        }
    }
}

