/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import org.apache.wicket.RequestContext;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketResponseState {
    private final boolean isActionResponse;
    private final boolean isEventResponse;
    private final boolean isRenderResponse;
    private final boolean isResourceResponse;
    private final boolean isMimeResponse;
    private final boolean isStateAwareResponse;
    private final Locale defaultLocale;
    private final PortletResponse response;
    private boolean flushed;
    private ByteArrayOutputStream byteOutputBuffer;
    private CharArrayWriterBuffer charOutputBuffer;
    private ServletOutputStream outputStream;
    private PrintWriter printWriter;
    private HashMap<String, ArrayList<String>> headers;
    private ArrayList<Cookie> cookies;
    private boolean committed;
    private boolean hasStatus;
    private boolean hasError;
    private Locale locale;
    private boolean setContentTypeAfterEncoding;
    private boolean closed;
    private String characterEncoding;
    private int contentLength = -1;
    private String contentType;
    private int statusCode;
    private String redirectLocation;

    public WicketResponseState(PortletRequest request, PortletResponse response) {
        String lifecyclePhase = (String)request.getAttribute("javax.portlet.lifecycle_phase");
        this.isActionResponse = "ACTION_PHASE".equals(lifecyclePhase);
        this.isEventResponse = "EVENT_PHASE".equals(lifecyclePhase);
        this.isRenderResponse = "RENDER_PHASE".equals(lifecyclePhase);
        this.isResourceResponse = "RESOURCE_PHASE".equals(lifecyclePhase);
        this.isStateAwareResponse = this.isActionResponse || this.isEventResponse;
        this.isMimeResponse = this.isRenderResponse || this.isResourceResponse;
        this.response = response;
        this.defaultLocale = this.isMimeResponse ? ((MimeResponse)response).getLocale() : null;
    }

    private ArrayList<String> getHeaderList(String name, boolean create) {
        ArrayList<String> headerList;
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        if ((headerList = this.headers.get(name)) == null && create) {
            headerList = new ArrayList();
            this.headers.put(name, headerList);
        }
        return headerList;
    }

    private void failIfCommitted() {
        if (this.committed) {
            throw new IllegalStateException("Response is already committed");
        }
    }

    public boolean isActionResponse() {
        return this.isActionResponse;
    }

    public boolean isEventResponse() {
        return this.isEventResponse;
    }

    public boolean isRenderResponse() {
        return this.isRenderResponse;
    }

    public boolean isResourceResponse() {
        return this.isResourceResponse;
    }

    public boolean isMimeResponse() {
        return this.isMimeResponse;
    }

    public boolean isStateAwareResponse() {
        return this.isStateAwareResponse;
    }

    public void addCookie(Cookie cookie) {
        if (!this.committed) {
            if (this.cookies == null) {
                this.cookies = new ArrayList();
            }
            this.cookies.add(cookie);
        }
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, Long.toString(date));
    }

    public void addHeader(String name, String value) {
        if (this.isMimeResponse && !this.committed) {
            this.getHeaderList(name, true).add(value);
        }
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        return this.isMimeResponse && this.getHeaderList(name, false) != null;
    }

    public void sendError(int errorCode, String errorMessage) throws IOException {
        this.failIfCommitted();
        this.committed = true;
        this.closed = true;
        this.hasError = true;
    }

    public void sendError(int errorCode) throws IOException {
        this.sendError(errorCode, null);
    }

    public void sendRedirect(String redirectLocation) throws IOException {
        if (this.isActionResponse || this.isMimeResponse) {
            RequestContext rc;
            this.failIfCommitted();
            this.closed = true;
            this.committed = true;
            if (this.isMimeResponse && (rc = RequestContext.get()) instanceof PortletRequestContext) {
                String wicketUrl = ((PortletRequestContext)rc).getLastEncodedPath(redirectLocation);
                if (wicketUrl != null) {
                    redirectLocation = wicketUrl;
                } else {
                    String contextPath = ((PortletRequestContext)rc).getPortletRequest().getContextPath();
                    if (redirectLocation.startsWith(contextPath + "/") && (redirectLocation = redirectLocation.substring(contextPath.length())).length() == 0) {
                        redirectLocation = "/";
                    }
                }
            }
            this.redirectLocation = redirectLocation;
        }
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, Long.toString(date));
    }

    public void setHeader(String name, String value) {
        if (this.isMimeResponse && !this.committed) {
            ArrayList<String> headerList = this.getHeaderList(name, true);
            headerList.clear();
            headerList.add(value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setStatus(int statusCode, String message) {
        throw new UnsupportedOperationException("This method is deprecated and no longer supported");
    }

    public void setStatus(int statusCode) {
        if (!this.committed) {
            this.statusCode = statusCode;
            this.hasStatus = true;
            this.resetBuffer();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.isMimeResponse && !this.closed) {
            this.committed = true;
        }
    }

    public int getBufferSize() {
        return this.isMimeResponse ? Integer.MAX_VALUE : 0;
    }

    public String getCharacterEncoding() {
        return this.isMimeResponse ? (this.characterEncoding != null ? this.characterEncoding : "ISO-8859-1") : null;
    }

    public String getContentType() {
        return this.isMimeResponse ? this.contentType : null;
    }

    public Locale getLocale() {
        return this.isMimeResponse ? (this.locale != null ? this.locale : this.defaultLocale) : null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.isStateAwareResponse) {
            return null;
        }
        if (this.outputStream == null) {
            if (this.printWriter != null) {
                throw new IllegalStateException("getWriter() has already been called on this response");
            }
            this.byteOutputBuffer = new ByteArrayOutputStream();
            this.outputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    if (!WicketResponseState.this.closed) {
                        WicketResponseState.this.byteOutputBuffer.write(b);
                        if (WicketResponseState.this.contentLength > -1 && WicketResponseState.this.byteOutputBuffer.size() >= WicketResponseState.this.contentLength) {
                            WicketResponseState.this.committed = true;
                            WicketResponseState.this.closed = true;
                        }
                    }
                }
            };
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.isStateAwareResponse) {
            return null;
        }
        if (this.printWriter == null) {
            if (this.outputStream != null) {
                throw new IllegalStateException("getOutputStream() has already been called on this response");
            }
            this.charOutputBuffer = new CharArrayWriterBuffer();
            this.printWriter = new PrintWriter(this.charOutputBuffer);
        }
        return this.printWriter;
    }

    public boolean isCommitted() {
        return this.isMimeResponse && this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.headers = null;
        this.cookies = null;
        this.hasStatus = false;
        this.contentLength = -1;
        if (this.printWriter == null) {
            this.contentType = null;
            this.characterEncoding = null;
            this.locale = null;
        }
    }

    public void resetBuffer() {
        this.failIfCommitted();
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.byteOutputBuffer.reset();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
            this.charOutputBuffer.reset();
        }
    }

    public void setBufferSize(int size) {
    }

    public void setCharacterEncoding(String charset) {
        if (this.isResourceResponse && charset != null && !this.committed && this.printWriter == null) {
            this.characterEncoding = charset;
            this.setContentTypeAfterEncoding = false;
        }
    }

    public void setContentLength(int len) {
        if (this.isResourceResponse && !this.committed && this.printWriter == null && len > 0) {
            this.contentLength = len;
            if (this.outputStream != null) {
                try {
                    this.outputStream.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.closed && this.byteOutputBuffer != null && this.byteOutputBuffer.size() >= len) {
                this.committed = true;
                this.closed = true;
            }
        }
    }

    public void setContentType(String type) {
        if (this.isMimeResponse && !this.committed) {
            this.contentType = type;
            this.setContentTypeAfterEncoding = false;
            if (this.printWriter == null) {
                // empty if block
            }
        }
    }

    public void setLocale(Locale locale) {
        if (this.isResourceResponse && !this.committed) {
            this.locale = locale;
        }
    }

    public void clear() {
        this.printWriter = null;
        this.byteOutputBuffer = null;
        this.charOutputBuffer = null;
        this.outputStream = null;
        this.printWriter = null;
        this.headers = null;
        this.cookies = null;
        this.committed = false;
        this.hasStatus = false;
        this.hasError = false;
        this.locale = null;
        this.setContentTypeAfterEncoding = false;
        this.closed = false;
        this.characterEncoding = null;
        this.contentLength = -1;
        this.contentType = null;
        this.statusCode = 0;
        this.redirectLocation = null;
    }

    public void flush() throws IOException {
        if (this.flushed) {
            throw new IllegalStateException("Already flushed");
        }
        this.flushed = true;
        if (this.cookies != null) {
            for (Cookie cookie : this.cookies) {
                this.response.addProperty(cookie);
            }
            this.cookies = null;
        }
        if (this.isMimeResponse) {
            ResourceResponse resourceResponse;
            MimeResponse mimeResponse = (MimeResponse)this.response;
            ResourceResponse resourceResponse2 = resourceResponse = this.isResourceResponse ? (ResourceResponse)this.response : null;
            if (this.locale != null) {
                try {
                    resourceResponse.setLocale(this.locale);
                }
                catch (UnsupportedOperationException usoe) {
                    // empty catch block
                }
            }
            if (this.contentType != null) {
                if (this.characterEncoding != null) {
                    if (this.setContentTypeAfterEncoding) {
                        resourceResponse.setCharacterEncoding(this.characterEncoding);
                        resourceResponse.setContentType(this.contentType);
                    } else {
                        resourceResponse.setContentType(this.contentType);
                        resourceResponse.setCharacterEncoding(this.characterEncoding);
                    }
                } else {
                    mimeResponse.setContentType(this.contentType);
                }
            } else if (this.characterEncoding != null) {
                resourceResponse.setCharacterEncoding(this.characterEncoding);
            }
            if (this.headers != null) {
                for (Map.Entry<String, ArrayList<String>> entry : this.headers.entrySet()) {
                    for (String value : entry.getValue()) {
                        mimeResponse.addProperty(entry.getKey(), value);
                    }
                }
                this.headers = null;
            }
            if (this.isResourceResponse && this.hasStatus) {
                resourceResponse.setProperty("portlet.http-status-code", Integer.toString(this.statusCode));
            }
            if (this.isResourceResponse && this.contentLength > -1) {
                try {
                    resourceResponse.setContentLength(this.contentLength);
                }
                catch (UnsupportedOperationException usoe) {
                    // empty catch block
                }
            }
            if (!this.hasError && this.redirectLocation == null) {
                if (this.outputStream != null) {
                    if (!this.closed) {
                        this.outputStream.flush();
                    }
                    OutputStream realOutputStream = mimeResponse.getPortletOutputStream();
                    int len = this.byteOutputBuffer.size();
                    if (this.contentLength > -1 && this.contentLength < len) {
                        len = this.contentLength;
                    }
                    if (len > 0) {
                        realOutputStream.write(this.byteOutputBuffer.toByteArray(), 0, len);
                    }
                    this.outputStream.close();
                    this.outputStream = null;
                    this.byteOutputBuffer = null;
                } else if (this.printWriter != null && !this.closed) {
                    this.printWriter.flush();
                    if (this.charOutputBuffer.getCount() > 0) {
                        mimeResponse.getWriter().write(this.charOutputBuffer.getBuffer(), 0, this.charOutputBuffer.getCount());
                    }
                    this.printWriter.close();
                    this.printWriter = null;
                    this.charOutputBuffer = null;
                }
            }
        }
    }

    private static class CharArrayWriterBuffer
    extends CharArrayWriter {
        private CharArrayWriterBuffer() {
        }

        public char[] getBuffer() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

