/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.component;

import java.lang.ref.WeakReference;
import java.util.Map;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkablePageRequestTarget
implements IBookmarkablePageRequestTarget {
    private Page page;
    private final WeakReference<Class<? extends Page>> pageClassRef;
    private final String pageMapName;
    private final PageParameters pageParameters;

    public <C extends Page> BookmarkablePageRequestTarget(Class<C> pageClass) {
        this(null, pageClass);
    }

    public <C extends Page> BookmarkablePageRequestTarget(Class<C> pageClass, PageParameters pageParameters) {
        this(null, pageClass, pageParameters);
    }

    public <C extends Page> BookmarkablePageRequestTarget(String pageMapName, Class<C> pageClass) {
        this(pageMapName, pageClass, null);
    }

    public <C extends Page> BookmarkablePageRequestTarget(String pageMapName, Class<C> pageClass, PageParameters pageParameters) {
        if (pageClass == null) {
            throw new IllegalArgumentException("Argument pageClass must be not null");
        }
        if (!Page.class.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("Argument pageClass must be an instance of " + Page.class.getName());
        }
        this.pageClassRef = new WeakReference<Class<C>>(pageClass);
        this.pageParameters = pageParameters == null ? new PageParameters() : pageParameters;
        this.pageMapName = pageMapName;
    }

    @Override
    public void detach(RequestCycle requestCycle) {
        if (this.page != null) {
            this.page.detach();
        }
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && obj instanceof BookmarkablePageRequestTarget) {
            BookmarkablePageRequestTarget that = (BookmarkablePageRequestTarget)obj;
            if (this.getPageClass().equals(that.getPageClass())) {
                boolean mapMatch = false;
                mapMatch = this.pageMapName != null ? that.pageMapName != null && this.pageMapName.equals(that.pageMapName) : that.pageMapName == null;
                equal = mapMatch;
            }
        }
        return equal;
    }

    public final Page getPage() {
        return this.page;
    }

    protected final void setPage(Page page) {
        this.page = page;
    }

    @Override
    public final Class<? extends Page> getPageClass() {
        return (Class)this.pageClassRef.get();
    }

    @Override
    public final String getPageMapName() {
        return this.pageMapName;
    }

    @Override
    public final PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public int hashCode() {
        int result = "BookmarkablePageRequestTarget".hashCode();
        result += this.getPageClass().hashCode();
        return 17 * (result += this.pageMapName != null ? this.pageMapName.hashCode() : 0);
    }

    @Override
    public void processEvents(RequestCycle requestCycle) {
        if (!requestCycle.isRedirect()) {
            this.page = this.getPage(requestCycle);
        }
    }

    @Override
    public void respond(RequestCycle requestCycle) {
        if (this.pageClassRef != null && this.pageClassRef.get() != null) {
            if (requestCycle.isRedirect()) {
                IRequestCycleProcessor processor = requestCycle.getProcessor();
                String redirectUrl = ((Object)processor.getRequestCodingStrategy().encode(requestCycle, this)).toString();
                if (redirectUrl.startsWith("./")) {
                    redirectUrl = redirectUrl.length() == 2 ? "." : redirectUrl.substring(2);
                }
                requestCycle.getResponse().redirect(redirectUrl);
            } else {
                this.getPage(requestCycle).renderPage();
            }
        }
    }

    public String toString() {
        return "[BookmarkablePageRequestTarget@" + this.hashCode() + " pageClass=" + this.getPageClass().getName() + "]";
    }

    protected <C extends Page> Page newPage(Class<C> pageClass, RequestCycle requestCycle) {
        IPageFactory pageFactory = requestCycle.getApplication().getSessionSettings().getPageFactory();
        if (this.pageParameters == null || this.pageParameters.size() == 0) {
            return pageFactory.newPage(pageClass);
        }
        Map<String, String[]> requestMap = requestCycle.getRequest().getParameterMap();
        requestMap.putAll(this.pageParameters.toRequestParameters());
        return pageFactory.newPage(pageClass, this.pageParameters);
    }

    protected final Page getPage(RequestCycle requestCycle) {
        if (this.page == null && !requestCycle.isRedirect()) {
            this.page = this.newPage(this.getPageClass(), requestCycle);
        }
        return this.page;
    }
}

