/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.resource.IPropertiesChangeListener;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.value.ValueMap;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesFactory
implements IPropertiesFactory {
    private static final Logger log = LoggerFactory.getLogger(PropertiesFactory.class);
    private final List<IPropertiesChangeListener> afterReloadListeners = new ArrayList<IPropertiesChangeListener>();
    private final Map<String, Properties> propertiesCache = new ConcurrentHashMap<String, Properties>();
    private final Application application;
    private final List<IPropertiesLoader> propertiesLoader;

    public PropertiesFactory(Application application) {
        this.application = application;
        this.propertiesLoader = new ArrayList<IPropertiesLoader>();
        this.propertiesLoader.add(new PropertiesFilePropertiesLoader());
        this.propertiesLoader.add(new XmlFilePropertiesLoader("xml"));
    }

    public List<IPropertiesLoader> getPropertiesLoaders() {
        return this.propertiesLoader;
    }

    @Override
    public void addListener(IPropertiesChangeListener listener) {
        if (!this.afterReloadListeners.contains(listener)) {
            this.afterReloadListeners.add(listener);
        }
    }

    @Override
    public final void clearCache() {
        this.propertiesCache.clear();
        this.application.getResourceSettings().getLocalizer().clearCache();
    }

    @Override
    public Properties load(Class<?> clazz, String path) {
        Properties properties = this.propertiesCache.get(path);
        if (properties == null) {
            Iterator<IPropertiesLoader> iter = this.propertiesLoader.iterator();
            while (properties == null && iter.hasNext()) {
                IPropertiesLoader loader = iter.next();
                properties = loader.load(clazz, path);
            }
            if (properties == null) {
                this.propertiesCache.put(path, Properties.EMPTY_PROPERTIES);
            } else {
                this.propertiesCache.put(path, properties);
            }
        }
        if (properties == Properties.EMPTY_PROPERTIES) {
            properties = null;
        }
        return properties;
    }

    protected final Map<String, Properties> getCache() {
        return this.propertiesCache;
    }

    public class XmlFilePropertiesLoader
    extends AbstractPropertiesLoader {
        private final String fileExtension;

        public XmlFilePropertiesLoader(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        protected String getFileExtension() {
            return this.fileExtension;
        }

        protected java.util.Properties loadProperties(BufferedInputStream in) throws IOException {
            java.util.Properties properties = new java.util.Properties();
            Streams.loadFromXml(properties, in);
            return properties;
        }
    }

    public class PropertiesFilePropertiesLoader
    extends AbstractPropertiesLoader {
        protected String getFileExtension() {
            return "properties";
        }

        protected java.util.Properties loadProperties(BufferedInputStream in) throws IOException {
            java.util.Properties properties = new java.util.Properties();
            properties.load(in);
            return properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractPropertiesLoader
    implements IPropertiesLoader {
        protected abstract String getFileExtension();

        protected abstract java.util.Properties loadProperties(BufferedInputStream var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Properties load(Class<?> clazz, final String path) {
            block11: {
                Properties properties;
                IResourceStream resourceStream;
                block10: {
                    String fullPath = path + this.getFileExtension();
                    resourceStream = PropertiesFactory.this.application.getResourceSettings().getResourceStreamLocator().locate(clazz, fullPath);
                    if (resourceStream == null) {
                        return null;
                    }
                    IModificationWatcher watcher = PropertiesFactory.this.application.getResourceSettings().getResourceWatcher(true);
                    if (watcher != null) {
                        watcher.add(resourceStream, new IChangeListener(){

                            public void onChange() {
                                log.info("A properties files has changed. Removing all entries from the cache. Resource: " + resourceStream);
                                PropertiesFactory.this.clearCache();
                                for (IPropertiesChangeListener listener : PropertiesFactory.this.afterReloadListeners) {
                                    try {
                                        listener.propertiesChanged(path);
                                    }
                                    catch (Throwable ex) {
                                        log.error("PropertiesReloadListener has thrown an exception: " + ex.getMessage());
                                    }
                                }
                            }
                        });
                    }
                    log.info("Loading properties files from " + resourceStream);
                    ValueMap strings = null;
                    BufferedInputStream in = null;
                    try {
                        in = new BufferedInputStream(resourceStream.getInputStream());
                        java.util.Properties properties2 = this.loadProperties(in);
                        strings = new ValueMap();
                        Enumeration<?> enumeration = properties2.propertyNames();
                        while (enumeration.hasMoreElements()) {
                            String property = (String)enumeration.nextElement();
                            strings.put(property, (Object)properties2.getProperty(property));
                        }
                        properties = new Properties(path, strings);
                        if (in == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            resourceStream.close();
                            throw throwable;
                        }
                        catch (ResourceStreamNotFoundException e) {
                            log.warn("Unable to find resource " + resourceStream, (Throwable)e);
                            strings = ValueMap.EMPTY_MAP;
                            break block11;
                        }
                        catch (IOException e) {
                            log.warn("Unable to access resource " + resourceStream, (Throwable)e);
                            strings = ValueMap.EMPTY_MAP;
                        }
                    }
                    in.close();
                }
                resourceStream.close();
                return properties;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IPropertiesLoader {
        public Properties load(Class<?> var1, String var2);
    }
}

