/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.aggregation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.DecoratingHeaderResponse;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.resource.ResourceUtil;
import org.apache.wicket.resource.aggregation.ResourceReferenceAndStringData;
import org.apache.wicket.resource.aggregation.ResourceReferenceCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceAggregatingHeaderResponse<R extends ResourceReferenceCollection, K>
extends DecoratingHeaderResponse {
    private final List<ResourceReferenceAndStringData> topLevelReferences = new ArrayList<ResourceReferenceAndStringData>();

    public AbstractResourceAggregatingHeaderResponse(IHeaderResponse real) {
        super(real);
    }

    @Override
    public void renderJavascriptReference(ResourceReference reference) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, null, false));
    }

    @Override
    public void renderJavascriptReference(ResourceReference reference, String id) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, id, false));
    }

    @Override
    public void renderCSSReference(ResourceReference reference) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, null, true));
    }

    @Override
    public void renderCSSReference(ResourceReference reference, String media) {
        this.topLevelReferences.add(new ResourceReferenceAndStringData(reference, media, true));
    }

    @Override
    public void close() {
        TreeMap<K, R> map = new TreeMap<K, R>(this.getGroupingKeyComparator());
        for (ResourceReferenceAndStringData ref : this.topLevelReferences) {
            K key = this.newGroupingKey(ref);
            ResourceReferenceCollection coll = (ResourceReferenceCollection)map.get(key);
            if (coll == null) {
                coll = this.newResourceReferenceCollection();
                map.put(key, coll);
            }
            coll.add(ref);
        }
        LinkedHashSet<ResourceReferenceAndStringData> alreadyRendered = new LinkedHashSet<ResourceReferenceAndStringData>();
        for (Map.Entry entry : map.entrySet()) {
            this.renderCollection(alreadyRendered, entry.getKey(), (ResourceReferenceCollection)entry.getValue());
        }
        this.onAllCollectionsRendered(this.topLevelReferences);
        super.close();
    }

    protected R newResourceReferenceCollection() {
        return (R)new ResourceReferenceCollection();
    }

    protected abstract K newGroupingKey(ResourceReferenceAndStringData var1);

    protected Comparator<K> getGroupingKeyComparator() {
        return null;
    }

    protected void renderCollection(Set<ResourceReferenceAndStringData> alreadyRendered, K key, R coll) {
        for (ResourceReferenceAndStringData data : coll) {
            this.renderIfNotAlreadyRendered(alreadyRendered, data);
        }
    }

    protected void renderIfNotAlreadyRendered(Set<ResourceReferenceAndStringData> alreadyRendered, ResourceReferenceAndStringData data) {
        if (!alreadyRendered.contains(data)) {
            this.render(data);
            alreadyRendered.add(data);
        }
    }

    protected void render(ResourceReferenceAndStringData data) {
        ResourceUtil.renderTo(this.getRealResponse(), data.getReference(), data.isCss(), data.getString());
    }

    protected void onAllCollectionsRendered(List<ResourceReferenceAndStringData> allTopLevelReferences) {
    }

    @Override
    public void renderJavascriptReference(String url) {
        this.getRealResponse().renderJavascriptReference(url);
    }

    @Override
    public void renderJavascriptReference(String url, String id) {
        this.getRealResponse().renderJavascriptReference(url, id);
    }

    @Override
    public void renderCSSReference(String url) {
        this.getRealResponse().renderCSSReference(url);
    }

    @Override
    public void renderCSSReference(String url, String media) {
        this.getRealResponse().renderCSSReference(url, media);
    }
}

