/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IDetachListener;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.IResourceFactory;
import org.apache.wicket.IResponseFilter;
import org.apache.wicket.Localizer;
import org.apache.wicket.Page;
import org.apache.wicket.application.DefaultClassResolver;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.javascript.IJavascriptCompressor;
import org.apache.wicket.markup.IMarkupCache;
import org.apache.wicket.markup.IMarkupParserFactory;
import org.apache.wicket.markup.MarkupCache;
import org.apache.wicket.markup.MarkupParserFactory;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.markup.html.PackageResourceGuard;
import org.apache.wicket.markup.html.form.persistence.CookieValuePersisterSettings;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.PropertiesFactory;
import org.apache.wicket.resource.loader.ClassStringResourceLoader;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.resource.loader.PackageStringResourceLoader;
import org.apache.wicket.resource.loader.ValidatorStringResourceLoader;
import org.apache.wicket.session.DefaultPageFactory;
import org.apache.wicket.session.pagemap.IPageMapEvictionStrategy;
import org.apache.wicket.session.pagemap.LeastRecentlyAccessedEvictionStrategy;
import org.apache.wicket.settings.IApplicationSettings;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.settings.IExceptionSettings;
import org.apache.wicket.settings.IFrameworkSettings;
import org.apache.wicket.settings.IMarkupSettings;
import org.apache.wicket.settings.IPageSettings;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.settings.IRequestLoggerSettings;
import org.apache.wicket.settings.IResourceSettings;
import org.apache.wicket.settings.ISecuritySettings;
import org.apache.wicket.settings.ISessionSettings;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.crypt.KeyInSessionSunJceCryptFactory;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.file.IResourcePath;
import org.apache.wicket.util.file.Path;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.apache.wicket.util.watch.ModificationWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Settings
implements IApplicationSettings,
IDebugSettings,
IExceptionSettings,
IMarkupSettings,
IPageSettings,
IRequestCycleSettings,
IResourceSettings,
ISecuritySettings,
ISessionSettings,
IFrameworkSettings,
IRequestLoggerSettings {
    private IDetachListener detachListener;
    private boolean outputComponentPath = false;
    private WeakReference<Class<? extends Page>> accessDeniedPage;
    private boolean ajaxDebugModeEnabled = false;
    private final Application application;
    private IAuthorizationStrategy authorizationStrategy = IAuthorizationStrategy.ALLOW_ALL;
    private boolean automaticLinking = false;
    private boolean automaticMultiWindowSupport = true;
    private boolean bufferResponse = true;
    private IClassResolver classResolver = new DefaultClassResolver();
    private final List<IComponentResolver> componentResolvers = new ArrayList<IComponentResolver>();
    private boolean componentUseCheck = true;
    private boolean compressWhitespace = false;
    private CookieValuePersisterSettings cookieValuePersisterSettings = new CookieValuePersisterSettings();
    private ICryptFactory cryptFactory;
    private String defaultAfterDisabledLink = "</em>";
    private String defaultBeforeDisabledLink = "<em>";
    private String defaultMarkupEncoding;
    private boolean disableGZipCompression = false;
    private boolean enforceMounts = false;
    private boolean gatherExtendedBrowserInfo = false;
    private WeakReference<Class<? extends Page>> internalErrorPage;
    private boolean linePreciseReportingOnAddComponentEnabled = false;
    private boolean developmentUtilitiesEnabled = false;
    private boolean linePreciseReportingOnNewComponentEnabled = false;
    private Localizer localizer;
    private IMarkupParserFactory markupParserFactory;
    private IMarkupCache markupCache;
    private boolean throwExceptionOnMissingXmlDeclaration = false;
    private int maxPageMaps = 5;
    private final Map<String, IResourceFactory> nameToResourceFactory = new HashMap<String, IResourceFactory>();
    private IPackageResourceGuard packageResourceGuard = new PackageResourceGuard();
    private WeakReference<Class<? extends Page>> pageExpiredErrorPage;
    private IPageFactory pageFactory = new DefaultPageFactory();
    private IPageMapEvictionStrategy pageMapEvictionStrategy = new LeastRecentlyAccessedEvictionStrategy(5);
    private IPropertiesFactory propertiesFactory;
    private IRequestCycleSettings.RenderStrategy renderStrategy = REDIRECT_TO_BUFFER;
    private IResourceFinder resourceFinder = new Path();
    private Duration resourcePollFrequency = null;
    private IResourceStreamLocator resourceStreamLocator;
    private IModificationWatcher resourceWatcher;
    private List<IResponseFilter> responseFilters;
    private String responseRequestEncoding = "UTF-8";
    private final List<IStringResourceLoader> stringResourceLoaders = new ArrayList<IStringResourceLoader>(4);
    private boolean stripComments = false;
    private boolean stripWicketTags = false;
    private boolean stripXmlDeclarationFromOutput;
    private boolean throwExceptionOnMissingResource = true;
    private boolean pageIdUniquePerSession = true;
    private Duration timeout = Duration.ONE_MINUTE;
    private IUnauthorizedComponentInstantiationListener unauthorizedComponentInstantiationListener = new IUnauthorizedComponentInstantiationListener(){

        public void onUnauthorizedInstantiation(Component component) {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
    };
    private IExceptionSettings.UnexpectedExceptionDisplay unexpectedExceptionDisplay = SHOW_EXCEPTION_PAGE;
    private boolean useDefaultOnMissingResource = true;
    private boolean versionPagesByDefault = true;
    private boolean recordSessionSize = true;
    private int requestsWindowSize = 0;
    private boolean requestLoggerEnabled;
    private boolean stripJavascriptCommentsAndWhitespace = false;
    private IJavascriptCompressor javascriptCompressor;
    private boolean outputMarkupContainerClassName = false;
    private boolean addLastModifiedTimeToResourceReferenceUrl = false;
    private Bytes defaultMaximumUploadSize = Bytes.MAX;
    private CharSequence parentFolderPlaceholder = null;
    private int defaultCacheDuration = 3600;

    public Settings(Application application) {
        this.application = application;
        this.stringResourceLoaders.add(new ComponentStringResourceLoader());
        this.stringResourceLoaders.add(new PackageStringResourceLoader());
        this.stringResourceLoaders.add(new ClassStringResourceLoader(this.application.getClass()));
        this.stringResourceLoaders.add(new ValidatorStringResourceLoader());
    }

    @Override
    public void addComponentResolver(IComponentResolver resolver) {
        this.componentResolvers.add(resolver);
    }

    @Override
    public void addResourceFactory(String name, IResourceFactory resourceFactory) {
        this.nameToResourceFactory.put(name, resourceFactory);
    }

    @Override
    public void addResourceFolder(String resourceFolder) {
        IResourceFinder finder = this.getResourceFinder();
        if (!(finder instanceof IResourcePath)) {
            throw new IllegalArgumentException("To add a resource folder, the application's resource finder must be an instance of IResourcePath");
        }
        IResourcePath path = (IResourcePath)finder;
        path.add(resourceFolder);
    }

    @Override
    public void addResponseFilter(IResponseFilter responseFilter) {
        if (this.responseFilters == null) {
            this.responseFilters = new ArrayList<IResponseFilter>(4);
        }
        this.responseFilters.add(responseFilter);
    }

    @Override
    public void addStringResourceLoader(IStringResourceLoader loader) {
        this.stringResourceLoaders.add(loader);
    }

    @Override
    public void addStringResourceLoader(int index, IStringResourceLoader loader) {
        this.stringResourceLoaders.add(index, loader);
    }

    @Override
    public Class<? extends Page> getAccessDeniedPage() {
        return (Class)this.accessDeniedPage.get();
    }

    @Override
    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.authorizationStrategy;
    }

    @Override
    public boolean getAutomaticLinking() {
        return this.automaticLinking;
    }

    @Override
    public boolean getAutomaticMultiWindowSupport() {
        return this.automaticMultiWindowSupport;
    }

    @Override
    public boolean getBufferResponse() {
        return this.bufferResponse;
    }

    @Override
    public IClassResolver getClassResolver() {
        return this.classResolver;
    }

    @Override
    public List<IComponentResolver> getComponentResolvers() {
        return this.componentResolvers;
    }

    @Override
    public boolean getComponentUseCheck() {
        return this.componentUseCheck;
    }

    @Override
    public boolean getCompressWhitespace() {
        return this.compressWhitespace;
    }

    @Override
    public CookieValuePersisterSettings getCookieValuePersisterSettings() {
        return this.cookieValuePersisterSettings;
    }

    @Override
    public synchronized ICryptFactory getCryptFactory() {
        if (this.cryptFactory == null) {
            this.cryptFactory = new KeyInSessionSunJceCryptFactory();
        }
        return this.cryptFactory;
    }

    @Override
    public String getDefaultAfterDisabledLink() {
        return this.defaultAfterDisabledLink;
    }

    @Override
    public String getDefaultBeforeDisabledLink() {
        return this.defaultBeforeDisabledLink;
    }

    @Override
    public String getDefaultMarkupEncoding() {
        return this.defaultMarkupEncoding;
    }

    @Override
    public boolean getDisableGZipCompression() {
        return this.disableGZipCompression;
    }

    @Override
    public boolean getEnforceMounts() {
        return this.enforceMounts;
    }

    @Override
    public boolean getGatherExtendedBrowserInfo() {
        return this.gatherExtendedBrowserInfo;
    }

    @Override
    public Class<? extends Page> getInternalErrorPage() {
        return (Class)this.internalErrorPage.get();
    }

    @Override
    public Localizer getLocalizer() {
        if (this.localizer == null) {
            this.localizer = new Localizer();
        }
        return this.localizer;
    }

    @Override
    public void setLocalizer(Localizer localizer) {
        this.localizer = localizer;
    }

    @Override
    public IMarkupParserFactory getMarkupParserFactory() {
        if (this.markupParserFactory == null) {
            this.markupParserFactory = new MarkupParserFactory();
        }
        return this.markupParserFactory;
    }

    @Override
    public final int getMaxPageMaps() {
        return this.maxPageMaps;
    }

    @Override
    public IPackageResourceGuard getPackageResourceGuard() {
        return this.packageResourceGuard;
    }

    @Override
    public Class<? extends Page> getPageExpiredErrorPage() {
        return (Class)this.pageExpiredErrorPage.get();
    }

    @Override
    public IPageFactory getPageFactory() {
        return this.pageFactory;
    }

    @Override
    public IPageMapEvictionStrategy getPageMapEvictionStrategy() {
        return this.pageMapEvictionStrategy;
    }

    @Override
    public IPropertiesFactory getPropertiesFactory() {
        if (this.propertiesFactory == null) {
            this.propertiesFactory = new PropertiesFactory(Application.get());
        }
        return this.propertiesFactory;
    }

    @Override
    public IRequestCycleSettings.RenderStrategy getRenderStrategy() {
        return this.renderStrategy;
    }

    @Override
    public IResourceFactory getResourceFactory(String name) {
        return this.nameToResourceFactory.get(name);
    }

    @Override
    public IResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }

    @Override
    public Duration getResourcePollFrequency() {
        return this.resourcePollFrequency;
    }

    @Override
    public IResourceStreamLocator getResourceStreamLocator() {
        if (this.resourceStreamLocator == null) {
            this.resourceStreamLocator = new ResourceStreamLocator(this.getResourceFinder());
        }
        return this.resourceStreamLocator;
    }

    @Override
    public IModificationWatcher getResourceWatcher(boolean start) {
        Duration pollFrequency;
        if (this.resourceWatcher == null && start && (pollFrequency = this.getResourcePollFrequency()) != null) {
            this.resourceWatcher = new ModificationWatcher(pollFrequency);
        }
        return this.resourceWatcher;
    }

    @Override
    public List<IResponseFilter> getResponseFilters() {
        if (this.responseFilters == null) {
            return null;
        }
        return Collections.unmodifiableList(this.responseFilters);
    }

    @Override
    public String getResponseRequestEncoding() {
        return this.responseRequestEncoding;
    }

    @Override
    public List<IStringResourceLoader> getStringResourceLoaders() {
        return this.stringResourceLoaders;
    }

    @Override
    public boolean getStripComments() {
        return this.stripComments;
    }

    @Override
    public boolean getStripWicketTags() {
        return this.stripWicketTags;
    }

    @Override
    public boolean getStripXmlDeclarationFromOutput() {
        return this.stripXmlDeclarationFromOutput;
    }

    @Override
    public boolean getThrowExceptionOnMissingResource() {
        return this.throwExceptionOnMissingResource;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public IUnauthorizedComponentInstantiationListener getUnauthorizedComponentInstantiationListener() {
        return this.unauthorizedComponentInstantiationListener;
    }

    @Override
    public IExceptionSettings.UnexpectedExceptionDisplay getUnexpectedExceptionDisplay() {
        return this.unexpectedExceptionDisplay;
    }

    @Override
    public boolean getUseDefaultOnMissingResource() {
        return this.useDefaultOnMissingResource;
    }

    @Override
    public String getVersion() {
        String implVersion = null;
        Package pkg = this.getClass().getPackage();
        if (pkg != null) {
            implVersion = pkg.getImplementationVersion();
        }
        return Strings.isEmpty(implVersion) ? "n/a" : implVersion;
    }

    @Override
    public boolean getVersionPagesByDefault() {
        return this.versionPagesByDefault;
    }

    @Override
    public boolean isAjaxDebugModeEnabled() {
        return this.ajaxDebugModeEnabled;
    }

    @Override
    public <C extends Page> void setAccessDeniedPage(Class<C> accessDeniedPage) {
        if (accessDeniedPage == null) {
            throw new IllegalArgumentException("Argument accessDeniedPage may not be null");
        }
        this.checkPageClass(accessDeniedPage);
        this.accessDeniedPage = new WeakReference<Class<C>>(accessDeniedPage);
    }

    @Override
    public void setAjaxDebugModeEnabled(boolean enable) {
        this.ajaxDebugModeEnabled = enable;
    }

    @Override
    public void setAuthorizationStrategy(IAuthorizationStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("authorization strategy cannot be set to null");
        }
        this.authorizationStrategy = strategy;
    }

    @Override
    public void setAutomaticLinking(boolean automaticLinking) {
        this.automaticLinking = automaticLinking;
    }

    @Override
    public void setAutomaticMultiWindowSupport(boolean automaticMultiWindowSupport) {
        this.automaticMultiWindowSupport = automaticMultiWindowSupport;
    }

    @Override
    public void setBufferResponse(boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
    }

    @Override
    public void setClassResolver(IClassResolver defaultClassResolver) {
        this.classResolver = defaultClassResolver;
    }

    @Override
    public void setComponentUseCheck(boolean componentUseCheck) {
        this.componentUseCheck = componentUseCheck;
    }

    @Override
    public void setCompressWhitespace(boolean compressWhitespace) {
        this.compressWhitespace = compressWhitespace;
    }

    @Override
    public void setCookieValuePersisterSettings(CookieValuePersisterSettings cookieValuePersisterSettings) {
        this.cookieValuePersisterSettings = cookieValuePersisterSettings;
    }

    @Override
    public void setCryptFactory(ICryptFactory cryptFactory) {
        if (cryptFactory == null) {
            throw new IllegalArgumentException("cryptFactory cannot be null");
        }
        this.cryptFactory = cryptFactory;
    }

    @Override
    public void setDefaultAfterDisabledLink(String defaultAfterDisabledLink) {
        this.defaultAfterDisabledLink = defaultAfterDisabledLink;
    }

    @Override
    public void setDefaultBeforeDisabledLink(String defaultBeforeDisabledLink) {
        this.defaultBeforeDisabledLink = defaultBeforeDisabledLink;
    }

    @Override
    public void setDefaultMarkupEncoding(String encoding) {
        this.defaultMarkupEncoding = encoding;
    }

    @Override
    public void setDisableGZipCompression(boolean disableGZipCompression) {
        this.disableGZipCompression = disableGZipCompression;
    }

    @Override
    public void setEnforceMounts(boolean enforce) {
        this.enforceMounts = enforce;
    }

    @Override
    public void setGatherExtendedBrowserInfo(boolean gatherExtendedBrowserInfo) {
        this.gatherExtendedBrowserInfo = gatherExtendedBrowserInfo;
    }

    @Override
    public <C extends Page> void setInternalErrorPage(Class<C> internalErrorPage) {
        if (internalErrorPage == null) {
            throw new IllegalArgumentException("Argument internalErrorPage may not be null");
        }
        this.checkPageClass(internalErrorPage);
        this.internalErrorPage = new WeakReference<Class<C>>(internalErrorPage);
    }

    @Override
    public void setMarkupParserFactory(IMarkupParserFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("markup parser factory cannot be null");
        }
        this.markupParserFactory = factory;
    }

    @Override
    public final void setMaxPageMaps(int maxPageMaps) {
        this.maxPageMaps = maxPageMaps;
    }

    @Override
    public void setPackageResourceGuard(IPackageResourceGuard packageResourceGuard) {
        if (packageResourceGuard == null) {
            throw new IllegalArgumentException("Argument packageResourceGuard may not be null");
        }
        this.packageResourceGuard = packageResourceGuard;
    }

    @Override
    public <C extends Page> void setPageExpiredErrorPage(Class<C> pageExpiredErrorPage) {
        if (pageExpiredErrorPage == null) {
            throw new IllegalArgumentException("Argument pageExpiredErrorPage may not be null");
        }
        this.checkPageClass(pageExpiredErrorPage);
        this.pageExpiredErrorPage = new WeakReference<Class<C>>(pageExpiredErrorPage);
    }

    @Override
    public void setPageFactory(IPageFactory defaultPageFactory) {
        this.pageFactory = defaultPageFactory;
    }

    @Override
    public void setPageMapEvictionStrategy(IPageMapEvictionStrategy pageMapEvictionStrategy) {
        this.pageMapEvictionStrategy = pageMapEvictionStrategy;
    }

    @Override
    public void setPropertiesFactory(IPropertiesFactory factory) {
        this.propertiesFactory = factory;
    }

    @Override
    public void setRenderStrategy(IRequestCycleSettings.RenderStrategy renderStrategy) {
        this.renderStrategy = renderStrategy;
    }

    @Override
    public void setResourceFinder(IResourceFinder resourceFinder) {
        this.resourceFinder = resourceFinder;
        this.resourceStreamLocator = null;
    }

    @Override
    public void setResourcePollFrequency(Duration resourcePollFrequency) {
        this.resourcePollFrequency = resourcePollFrequency;
    }

    @Override
    public void setResourceStreamLocator(IResourceStreamLocator resourceStreamLocator) {
        this.resourceStreamLocator = resourceStreamLocator;
    }

    @Override
    public void setResourceWatcher(IModificationWatcher watcher) {
        this.resourceWatcher = watcher;
    }

    @Override
    public void setResponseRequestEncoding(String responseRequestEncoding) {
        this.responseRequestEncoding = responseRequestEncoding;
    }

    @Override
    public void setStripComments(boolean stripComments) {
        this.stripComments = stripComments;
    }

    @Override
    public void setStripWicketTags(boolean stripWicketTags) {
        this.stripWicketTags = stripWicketTags;
    }

    @Override
    public void setStripXmlDeclarationFromOutput(boolean strip) {
        this.stripXmlDeclarationFromOutput = strip;
    }

    @Override
    public void setThrowExceptionOnMissingResource(boolean throwExceptionOnMissingResource) {
        this.throwExceptionOnMissingResource = throwExceptionOnMissingResource;
    }

    @Override
    public void setTimeout(Duration timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("timeout cannot be null");
        }
        this.timeout = timeout;
    }

    @Override
    public void setUnauthorizedComponentInstantiationListener(IUnauthorizedComponentInstantiationListener unauthorizedComponentInstantiationListener) {
        this.unauthorizedComponentInstantiationListener = unauthorizedComponentInstantiationListener;
    }

    @Override
    public void setUnexpectedExceptionDisplay(IExceptionSettings.UnexpectedExceptionDisplay unexpectedExceptionDisplay) {
        this.unexpectedExceptionDisplay = unexpectedExceptionDisplay;
    }

    @Override
    public void setUseDefaultOnMissingResource(boolean useDefaultOnMissingResource) {
        this.useDefaultOnMissingResource = useDefaultOnMissingResource;
    }

    @Override
    public void setVersionPagesByDefault(boolean pagesVersionedByDefault) {
        this.versionPagesByDefault = pagesVersionedByDefault;
    }

    private <C extends Page> void checkPageClass(Class<C> pageClass) {
        if (!Page.class.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("argument " + pageClass + " must be a subclass of Page");
        }
    }

    @Override
    public boolean getRecordSessionSize() {
        return this.recordSessionSize;
    }

    @Override
    public int getRequestsWindowSize() {
        return this.requestsWindowSize;
    }

    @Override
    public boolean isRequestLoggerEnabled() {
        return this.requestLoggerEnabled;
    }

    @Override
    public void setRecordSessionSize(boolean record) {
        this.recordSessionSize = record;
    }

    @Override
    public void setRequestLoggerEnabled(boolean enable) {
        this.requestLoggerEnabled = enable;
    }

    @Override
    public void setRequestsWindowSize(int size) {
        this.requestsWindowSize = size;
    }

    @Override
    @Deprecated
    public boolean getStripJavascriptCommentsAndWhitespace() {
        return this.stripJavascriptCommentsAndWhitespace;
    }

    @Override
    @Deprecated
    public void setStripJavascriptCommentsAndWhitespace(boolean value) {
        this.stripJavascriptCommentsAndWhitespace = value;
    }

    @Override
    public void setOutputMarkupContainerClassName(boolean enable) {
        this.outputMarkupContainerClassName = enable;
    }

    @Override
    public boolean isOutputMarkupContainerClassName() {
        return this.outputMarkupContainerClassName;
    }

    @Override
    public IMarkupCache getMarkupCache() {
        if (this.markupCache == null) {
            this.markupCache = new MarkupCache(this.application);
        }
        return this.markupCache;
    }

    @Override
    public void setMarkupCache(IMarkupCache markupCache) {
        this.markupCache = markupCache;
    }

    @Override
    public Bytes getDefaultMaximumUploadSize() {
        return this.defaultMaximumUploadSize;
    }

    @Override
    public void setDefaultMaximumUploadSize(Bytes defaultMaximumUploadSize) {
        this.defaultMaximumUploadSize = defaultMaximumUploadSize;
    }

    @Override
    public void setPageIdUniquePerSession(boolean value) {
        this.pageIdUniquePerSession = value;
    }

    @Override
    public boolean isPageIdUniquePerSession() {
        return this.pageIdUniquePerSession;
    }

    @Override
    public boolean isLinePreciseReportingOnAddComponentEnabled() {
        return this.linePreciseReportingOnAddComponentEnabled;
    }

    @Override
    public boolean isLinePreciseReportingOnNewComponentEnabled() {
        return this.linePreciseReportingOnNewComponentEnabled;
    }

    @Override
    public void setLinePreciseReportingOnAddComponentEnabled(boolean enable) {
        this.linePreciseReportingOnAddComponentEnabled = enable;
    }

    @Override
    public void setLinePreciseReportingOnNewComponentEnabled(boolean enable) {
        this.linePreciseReportingOnNewComponentEnabled = enable;
    }

    @Override
    public void setAddLastModifiedTimeToResourceReferenceUrl(boolean value) {
        this.addLastModifiedTimeToResourceReferenceUrl = value;
    }

    @Override
    public boolean getAddLastModifiedTimeToResourceReferenceUrl() {
        return this.addLastModifiedTimeToResourceReferenceUrl;
    }

    @Override
    public boolean getThrowExceptionOnMissingXmlDeclaration() {
        return this.throwExceptionOnMissingXmlDeclaration;
    }

    @Override
    public void setThrowExceptionOnMissingXmlDeclaration(boolean throwException) {
        this.throwExceptionOnMissingXmlDeclaration = throwException;
    }

    @Override
    public CharSequence getParentFolderPlaceholder() {
        return this.parentFolderPlaceholder;
    }

    @Override
    public void setParentFolderPlaceholder(CharSequence sequence) {
        this.parentFolderPlaceholder = sequence;
    }

    @Override
    public boolean isOutputComponentPath() {
        return this.outputComponentPath;
    }

    @Override
    public void setOutputComponentPath(boolean outputComponentPath) {
        this.outputComponentPath = outputComponentPath;
    }

    @Override
    public IJavascriptCompressor getJavascriptCompressor() {
        return this.javascriptCompressor;
    }

    @Override
    public IJavascriptCompressor setJavascriptCompressor(IJavascriptCompressor compressor) {
        IJavascriptCompressor old = this.javascriptCompressor;
        this.javascriptCompressor = compressor;
        return old;
    }

    @Override
    public IDetachListener getDetachListener() {
        return this.detachListener;
    }

    @Override
    public void setDetachListener(IDetachListener detachListener) {
        this.detachListener = detachListener;
    }

    @Override
    public void setDevelopmentUtilitiesEnabled(boolean enable) {
        this.developmentUtilitiesEnabled = enable;
    }

    @Override
    public boolean isDevelopmentUtilitiesEnabled() {
        return this.developmentUtilitiesEnabled;
    }

    @Override
    public final int getDefaultCacheDuration() {
        return this.defaultCacheDuration;
    }

    @Override
    public final void setDefaultCacheDuration(int defaultDuration) {
        if (defaultDuration < 0) {
            throw new IllegalArgumentException("Parameter 'defaultDuration' must not be < 0");
        }
        this.defaultCacheDuration = defaultDuration;
    }
}

