/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;

public class CapabilityImpl
implements Capability {
    private final Module m_module;
    private final String m_namespace;
    private final List<Directive> m_dirs;
    private final List<Directive> m_dirsConst;
    private final List<Attribute> m_attrs;
    private final List<Attribute> m_attrsConst;
    private final List<String> m_uses;
    private final List<List<String>> m_includeFilter;
    private final List<List<String>> m_excludeFilter;

    public CapabilityImpl(Module module, String namespace, List<Directive> dirs, List<Attribute> attrs) {
        this.m_namespace = namespace;
        this.m_module = module;
        this.m_dirs = dirs;
        this.m_dirsConst = Collections.unmodifiableList(this.m_dirs);
        this.m_attrs = attrs;
        this.m_attrsConst = Collections.unmodifiableList(this.m_attrs);
        String mandatory = "";
        ArrayList<String> uses = new ArrayList<String>(0);
        ArrayList<List<String>> includeFilter = null;
        ArrayList<List<String>> excludeFilter = null;
        for (int dirIdx = 0; dirIdx < this.m_dirs.size(); ++dirIdx) {
            if (this.m_dirs.get(dirIdx).getName().equals("uses")) {
                StringTokenizer tok = new StringTokenizer((String)this.m_dirs.get(dirIdx).getValue(), ",");
                uses = new ArrayList(tok.countTokens());
                while (tok.hasMoreTokens()) {
                    uses.add(tok.nextToken().trim());
                }
                continue;
            }
            if (this.m_dirs.get(dirIdx).getName().equals("mandatory")) {
                mandatory = (String)this.m_dirs.get(dirIdx).getValue();
                continue;
            }
            if (!this.m_dirs.get(dirIdx).getName().equals("include") && !this.m_dirs.get(dirIdx).getName().equals("exclude")) continue;
            ArrayList<List<String>> filterList = null;
            List<String> filters = ManifestParser.parseDelimitedString((String)this.m_dirs.get(dirIdx).getValue(), ",");
            filterList = new ArrayList<List<String>>(filters.size());
            for (int filterIdx = 0; filterIdx < filters.size(); ++filterIdx) {
                List<String> substrings = SimpleFilter.parseSubstring(filters.get(filterIdx));
                filterList.add(substrings);
            }
            if (this.m_dirs.get(dirIdx).getName().equals("include")) {
                includeFilter = filterList;
                continue;
            }
            excludeFilter = filterList;
        }
        this.m_uses = uses;
        this.m_includeFilter = includeFilter;
        this.m_excludeFilter = excludeFilter;
        StringTokenizer tok = new StringTokenizer(mandatory, ", ");
        while (tok.hasMoreTokens()) {
            String attrName = tok.nextToken().trim();
            boolean found = false;
            for (int i = 0; !found && i < this.m_attrs.size(); ++i) {
                if (!this.m_attrs.get(i).getName().equals(attrName)) continue;
                this.m_attrs.set(i, new Attribute(this.m_attrs.get(i).getName(), this.m_attrs.get(i).getValue(), true));
                found = true;
            }
            if (found) continue;
            throw new IllegalArgumentException("Mandatory attribute '" + attrName + "' does not exist.");
        }
    }

    @Override
    public Module getModule() {
        return this.m_module;
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public Directive getDirective(String name) {
        for (int i = 0; i < this.m_dirs.size(); ++i) {
            if (!this.m_dirs.get(i).getName().equals(name)) continue;
            return this.m_dirs.get(i);
        }
        return null;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.m_dirsConst;
    }

    @Override
    public Attribute getAttribute(String name) {
        for (int i = 0; i < this.m_attrs.size(); ++i) {
            if (!this.m_attrs.get(i).getName().equals(name)) continue;
            return this.m_attrs.get(i);
        }
        return null;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.m_attrsConst;
    }

    @Override
    public List<String> getUses() {
        return this.m_uses;
    }

    public boolean isIncluded(String name) {
        if (this.m_includeFilter == null && this.m_excludeFilter == null) {
            return true;
        }
        String className = Util.getClassName(name);
        boolean included = this.m_includeFilter == null;
        for (int i = 0; !included && this.m_includeFilter != null && i < this.m_includeFilter.size(); ++i) {
            included = SimpleFilter.compareSubstring(this.m_includeFilter.get(i), className);
        }
        boolean excluded = false;
        for (int i = 0; !excluded && this.m_excludeFilter != null && i < this.m_excludeFilter.size(); ++i) {
            excluded = SimpleFilter.compareSubstring(this.m_excludeFilter.get(i), className);
        }
        return included && !excluded;
    }

    public String toString() {
        if (this.m_module == null) {
            return this.m_attrs.toString();
        }
        if (this.m_namespace.equals("package")) {
            return "[" + this.m_module + "] " + this.m_namespace + "; " + this.getAttribute("package");
        }
        return "[" + this.m_module + "] " + this.m_namespace + "; " + this.m_attrs;
    }
}

