/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.retention.RetentionRegistry;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemValidator {
    public static final int CHECK_ACCESS = 1;
    public static final int CHECK_LOCK = 2;
    public static final int CHECK_VERSIONING = 4;
    public static final int CHECK_REFERENCES = 8;
    public static final int CHECK_CONSTRAINTS = 16;
    public static final int CHECK_PENDING_CHANGES = 32;
    public static final int CHECK_PENDING_CHANGES_ON_NODE = 64;
    public static final int CHECK_HOLD = 128;
    public static final int CHECK_RETENTION = 256;
    private static Logger log = LoggerFactory.getLogger((Class)ItemValidator.class);
    protected final NodeTypeRegistry ntReg;
    protected final HierarchyManager hierMgr;
    protected final PathResolver resolver;
    protected final LockManager lockMgr;
    protected final AccessManager accessMgr;
    protected final RetentionRegistry retentionReg;
    protected final ItemManager itemMgr;

    public ItemValidator(NodeTypeRegistry ntReg, HierarchyManager hierMgr, SessionImpl session) throws RepositoryException {
        this(ntReg, hierMgr, (PathResolver)session, session.getLockManager(), session.getAccessManager(), session.getRetentionRegistry(), session.getItemManager());
    }

    public ItemValidator(NodeTypeRegistry ntReg, HierarchyManager hierMgr, PathResolver resolver, LockManager lockMgr, AccessManager accessMgr, RetentionRegistry retentionReg, ItemManager itemMgr) {
        this.ntReg = ntReg;
        this.hierMgr = hierMgr;
        this.resolver = resolver;
        this.lockMgr = lockMgr;
        this.accessMgr = accessMgr;
        this.retentionReg = retentionReg;
        this.itemMgr = itemMgr;
    }

    public void validate(NodeState nodeState) throws ConstraintViolationException, RepositoryException {
        EffectiveNodeType entPrimary = this.ntReg.getEffectiveNodeType(nodeState.getNodeTypeName());
        EffectiveNodeType entPrimaryAndMixins = this.getEffectiveNodeType(nodeState);
        NodeDef def = this.itemMgr.getDefinition(nodeState).unwrap();
        Name[] requiredPrimaryTypes = def.getRequiredPrimaryTypes();
        for (int i = 0; i < requiredPrimaryTypes.length; ++i) {
            if (entPrimary.includesNodeType(requiredPrimaryTypes[i])) continue;
            String msg = this.safeGetJCRPath(nodeState.getNodeId()) + ": missing required primary type " + requiredPrimaryTypes[i];
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        PropDef[] pda = entPrimaryAndMixins.getMandatoryPropDefs();
        for (int i = 0; i < pda.length; ++i) {
            PropDef pd = pda[i];
            if (nodeState.hasPropertyName(pd.getName())) continue;
            String msg = this.safeGetJCRPath(nodeState.getNodeId()) + ": mandatory property " + pd.getName() + " does not exist";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        NodeDef[] cnda = entPrimaryAndMixins.getMandatoryNodeDefs();
        for (int i = 0; i < cnda.length; ++i) {
            NodeDef cnd = cnda[i];
            if (nodeState.hasChildNodeEntry(cnd.getName())) continue;
            String msg = this.safeGetJCRPath(nodeState.getNodeId()) + ": mandatory child node " + cnd.getName() + " does not exist";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
    }

    public void validate(PropertyState propState) throws ConstraintViolationException, RepositoryException {
        PropDef def = this.itemMgr.getDefinition(propState).unwrap();
        InternalValue[] values = propState.getValues();
        int type = 0;
        for (int i = 0; i < values.length; ++i) {
            if (type == 0) {
                type = values[i].getType();
            } else if (type != values[i].getType()) {
                throw new ConstraintViolationException(this.safeGetJCRPath(propState.getPropertyId()) + ": inconsistent value types");
            }
            if (def.getRequiredType() == 0 || def.getRequiredType() == type) continue;
            throw new ConstraintViolationException(this.safeGetJCRPath(propState.getPropertyId()) + ": requiredType constraint is not satisfied");
        }
        EffectiveNodeType.checkSetPropertyValueConstraints(def, values);
    }

    public void checkModify(ItemImpl item, int options, int permissions) throws RepositoryException {
        this.checkCondition(item, options, permissions, false);
    }

    public void checkRemove(ItemImpl item, int options, int permissions) throws RepositoryException {
        this.checkCondition(item, options, permissions, true);
    }

    private void checkCondition(ItemImpl item, int options, int permissions, boolean isRemoval) throws RepositoryException {
        if ((options & 0x20) == 32 && item.getSession().hasPendingChanges()) {
            String msg = "Unable to perform operation. Session has pending changes.";
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        if ((options & 0x40) == 64 && item.isNode() && ((NodeImpl)item).hasPendingChanges()) {
            String msg = "Unable to perform operation. Session has pending changes.";
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        if ((options & 0x10) == 16 && this.isProtected(item)) {
            String msg = "Unable to perform operation. Node is protected.";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        if ((options & 4) == 4) {
            NodeImpl node;
            NodeImpl nodeImpl = node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
            if (!node.internalIsCheckedOut()) {
                String msg = "Unable to perform operation. Node is checked-in.";
                log.debug(msg);
                throw new VersionException(msg);
            }
        }
        if ((options & 2) == 2) {
            this.checkLock(item);
        }
        if (permissions > 0) {
            Path path = item.getPrimaryPath();
            this.accessMgr.checkPermission(path, permissions);
        }
        if ((options & 0x80) == 128 && this.hasHold(item, isRemoval)) {
            throw new RepositoryException("Unable to perform operation. Node is affected by a hold.");
        }
        if ((options & 0x100) == 256 && this.hasRetention(item, isRemoval)) {
            throw new RepositoryException("Unable to perform operation. Node is affected by a retention.");
        }
    }

    public boolean canModify(ItemImpl item, int options, int permissions) throws RepositoryException {
        return this.hasCondition(item, options, permissions, false);
    }

    private boolean hasCondition(ItemImpl item, int options, int permissions, boolean isRemoval) throws RepositoryException {
        Path path;
        if ((options & 0x20) == 32 && item.getSession().hasPendingChanges()) {
            return false;
        }
        if ((options & 0x40) == 64 && item.isNode() && ((NodeImpl)item).hasPendingChanges()) {
            return false;
        }
        if ((options & 0x10) == 16 && this.isProtected(item)) {
            return false;
        }
        if ((options & 4) == 4) {
            NodeImpl node;
            NodeImpl nodeImpl = node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
            if (!node.internalIsCheckedOut()) {
                return false;
            }
        }
        if ((options & 2) == 2) {
            try {
                this.checkLock(item);
            }
            catch (LockException e) {
                return false;
            }
        }
        if (permissions > 0 && !this.accessMgr.isGranted(path = item.getPrimaryPath(), permissions)) {
            return false;
        }
        if ((options & 0x80) == 128 && this.hasHold(item, isRemoval)) {
            return false;
        }
        return (options & 0x100) != 256 || !this.hasRetention(item, isRemoval);
    }

    private void checkLock(ItemImpl item) throws LockException, RepositoryException {
        if (item.isNew()) {
            return;
        }
        NodeImpl node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        this.lockMgr.checkLock(node);
    }

    private boolean isProtected(ItemImpl item) throws RepositoryException {
        Object def = item.isNode() ? ((Node)item).getDefinition() : ((Property)item).getDefinition();
        return def.isProtected();
    }

    private boolean hasHold(ItemImpl item, boolean isRemoval) throws RepositoryException {
        if (item.isNew()) {
            return false;
        }
        Path path = item.getPrimaryPath();
        if (!item.isNode()) {
            path = path.getAncestor(1);
        }
        boolean checkParent = item.isNode() && isRemoval;
        return this.retentionReg.hasEffectiveHold(path, checkParent);
    }

    private boolean hasRetention(ItemImpl item, boolean isRemoval) throws RepositoryException {
        if (item.isNew()) {
            return false;
        }
        Path path = item.getPrimaryPath();
        if (!item.isNode()) {
            path = path.getAncestor(1);
        }
        boolean checkParent = item.isNode() && isRemoval;
        return this.retentionReg.hasEffectiveRetention(path, checkParent);
    }

    public EffectiveNodeType getEffectiveNodeType(NodeState state) throws RepositoryException {
        try {
            return this.ntReg.getEffectiveNodeType(state.getNodeTypeName(), state.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + this.safeGetJCRPath(state.getNodeId());
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    public NodeDef findApplicableNodeDefinition(Name name, Name nodeTypeName, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicableChildNodeDef(name, nodeTypeName, this.ntReg);
    }

    public PropDef findApplicablePropertyDefinition(Name name, int type, boolean multiValued, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicablePropertyDef(name, type, multiValued);
    }

    public PropDef findApplicablePropertyDefinition(Name name, int type, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicablePropertyDef(name, type);
    }

    public String safeGetJCRPath(Path path) {
        try {
            return this.resolver.getJCRPath(path);
        }
        catch (NamespaceException e) {
            log.error("failed to convert {} to a JCR path", (Object)path);
            return path.toString();
        }
    }

    public String safeGetJCRPath(ItemId id) {
        try {
            return this.safeGetJCRPath(this.hierMgr.getPath(id));
        }
        catch (ItemNotFoundException e) {
            return id.toString();
        }
        catch (RepositoryException e) {
            log.error(id + ": failed to build path");
            return id.toString();
        }
    }
}

