/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.api.jsr283.lock.Lock;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionLockManager
implements org.apache.jackrabbit.api.jsr283.lock.LockManager {
    private static Logger log = LoggerFactory.getLogger((Class)SessionLockManager.class);
    private final SessionImpl session;
    private final LockManager systemLockMgr;
    private final Set lockTokens = new HashSet();

    public SessionLockManager(SessionImpl session, LockManager systemLockMgr) throws RepositoryException {
        this.session = session;
        this.systemLockMgr = systemLockMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLockTokens() throws RepositoryException {
        Set set = this.lockTokens;
        synchronized (set) {
            String[] result = new String[this.lockTokens.size()];
            this.lockTokens.toArray(result);
            return result;
        }
    }

    public void addLockToken(String lockToken) throws LockException, RepositoryException {
        if (!this.lockTokens.contains(lockToken)) {
            this.systemLockMgr.lockTokenAdded(this.session, lockToken);
        } else {
            log.debug("Lock token already present with session -> no effect.");
        }
    }

    public void removeLockToken(String lockToken) throws LockException, RepositoryException {
        if (!this.lockTokens.contains(lockToken)) {
            throw new LockException("Lock token " + lockToken + " not present with session.");
        }
        this.systemLockMgr.lockTokenRemoved(this.session, lockToken);
    }

    public boolean isLocked(String absPath) throws RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        if (node.isNew()) {
            while (node.isNew()) {
                node = (NodeImpl)node.getParent();
            }
            return this.systemLockMgr.isLocked(node) && this.systemLockMgr.getLock(node).isDeep();
        }
        return this.systemLockMgr.isLocked(node);
    }

    public Lock getLock(String absPath) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        if (node.isNew()) {
            while (node.isNew()) {
                node = (NodeImpl)node.getParent();
            }
            Lock l = (Lock)this.systemLockMgr.getLock(node);
            if (l.isDeep()) {
                return l;
            }
            throw new LockException("Node not locked: " + node);
        }
        return (Lock)this.systemLockMgr.getLock(node);
    }

    public boolean holdsLock(String absPath) throws RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        if (node.isNew() || !node.isNodeType(NameConstants.MIX_LOCKABLE)) {
            return false;
        }
        return this.systemLockMgr.holdsLock(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock lock(String absPath, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        int options = 192;
        this.session.getValidator().checkModify(node, options, 512);
        SessionLockManager.checkLockable(node);
        LockManager lockManager = this.systemLockMgr;
        synchronized (lockManager) {
            return (Lock)this.systemLockMgr.lock(node, isDeep, isSessionScoped, timeoutHint, ownerInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String absPath) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        NodeImpl node = (NodeImpl)this.session.getNode(absPath);
        int options = 192;
        this.session.getValidator().checkModify(node, options, 512);
        SessionLockManager.checkLockable(node);
        LockManager lockManager = this.systemLockMgr;
        synchronized (lockManager) {
            if (!this.systemLockMgr.holdsLock(node)) {
                throw new LockException("Node not locked: " + node);
            }
            if (!this.systemLockMgr.isLockHolder((Session)this.session, node)) {
                throw new LockException("Node not locked by session: " + node);
            }
            this.systemLockMgr.unlock(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean lockTokenAdded(String lockToken) {
        Set set = this.lockTokens;
        synchronized (set) {
            return this.lockTokens.add(lockToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean lockTokenRemoved(String lockToken) {
        Set set = this.lockTokens;
        synchronized (set) {
            return this.lockTokens.remove(lockToken);
        }
    }

    private static void checkLockable(NodeImpl node) throws LockException, RepositoryException {
        if (!node.isNodeType(NameConstants.MIX_LOCKABLE)) {
            String msg = "Unable to perform a locking operation on a non-lockable node: " + node.safeGetJCRPath();
            log.debug(msg);
            throw new LockException(msg);
        }
    }
}

