/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.ItemDef;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefImpl;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.nodetype.xml.AdditionalNamespaceResolver;
import org.apache.jackrabbit.core.util.DOMWalker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.jackrabbit.value.ValueHelper;

public class NodeTypeReader {
    private final DOMWalker walker;
    private final Properties namespaces;
    private final NamePathResolver resolver;

    public static NodeTypeDef[] read(InputStream xml) throws IOException, InvalidNodeTypeDefException {
        try {
            NodeTypeReader reader = new NodeTypeReader(xml);
            return reader.getNodeTypeDefs();
        }
        catch (NameException e) {
            throw new InvalidNodeTypeDefException("Invalid namespace reference in a node type definition", e);
        }
        catch (NamespaceException e) {
            throw new InvalidNodeTypeDefException("Invalid namespace reference in a node type definition", e);
        }
    }

    public NodeTypeReader(InputStream xml) throws IOException {
        this.walker = new DOMWalker(xml);
        this.namespaces = this.walker.getNamespaces();
        AdditionalNamespaceResolver nsResolver = new AdditionalNamespaceResolver(this.namespaces);
        this.resolver = new DefaultNamePathResolver((NamespaceResolver)nsResolver);
    }

    public Properties getNamespaces() {
        return this.namespaces;
    }

    public NodeTypeDef[] getNodeTypeDefs() throws InvalidNodeTypeDefException, NameException, NamespaceException {
        ArrayList<NodeTypeDef> defs = new ArrayList<NodeTypeDef>();
        while (this.walker.iterateElements("nodeType")) {
            defs.add(this.getNodeTypeDef());
        }
        return defs.toArray(new NodeTypeDef[defs.size()]);
    }

    private NodeTypeDef getNodeTypeDef() throws InvalidNodeTypeDefException, NameException, NamespaceException {
        NodeTypeDef type = new NodeTypeDef();
        type.setName(this.resolver.getQName(this.walker.getAttribute("name")));
        type.setMixin(Boolean.valueOf(this.walker.getAttribute("isMixin")));
        type.setOrderableChildNodes(Boolean.valueOf(this.walker.getAttribute("hasOrderableChildNodes")));
        String primaryItemName = this.walker.getAttribute("primaryItemName");
        if (primaryItemName != null && primaryItemName.length() > 0) {
            type.setPrimaryItemName(this.resolver.getQName(primaryItemName));
        }
        if (this.walker.enterElement("supertypes")) {
            ArrayList<Name> supertypes = new ArrayList<Name>();
            while (this.walker.iterateElements("supertype")) {
                supertypes.add(this.resolver.getQName(this.walker.getContent()));
            }
            type.setSupertypes(supertypes.toArray(new Name[supertypes.size()]));
            this.walker.leaveElement();
        }
        ArrayList<PropDefImpl> properties = new ArrayList<PropDefImpl>();
        while (this.walker.iterateElements("propertyDefinition")) {
            PropDefImpl def = this.getPropDef();
            def.setDeclaringNodeType(type.getName());
            properties.add(def);
        }
        type.setPropertyDefs(properties.toArray(new PropDef[properties.size()]));
        ArrayList<NodeDefImpl> nodes = new ArrayList<NodeDefImpl>();
        while (this.walker.iterateElements("childNodeDefinition")) {
            NodeDefImpl def = this.getChildNodeDef();
            def.setDeclaringNodeType(type.getName());
            nodes.add(def);
        }
        type.setChildNodeDefs(nodes.toArray(new NodeDef[nodes.size()]));
        return type;
    }

    private PropDefImpl getPropDef() throws InvalidNodeTypeDefException, NameException, NamespaceException {
        int type;
        PropDefImpl def = new PropDefImpl();
        String name = this.walker.getAttribute("name");
        if (name.equals("*")) {
            def.setName(ItemDef.ANY_NAME);
        } else {
            def.setName(this.resolver.getQName(name));
        }
        def.setAutoCreated(Boolean.valueOf(this.walker.getAttribute("autoCreated")));
        def.setMandatory(Boolean.valueOf(this.walker.getAttribute("mandatory")));
        def.setProtected(Boolean.valueOf(this.walker.getAttribute("protected")));
        def.setOnParentVersion(OnParentVersionAction.valueFromName((String)this.walker.getAttribute("onParentVersion")));
        def.setMultiple(Boolean.valueOf(this.walker.getAttribute("multiple")));
        def.setRequiredType(PropertyType.valueFromName((String)this.walker.getAttribute("requiredType")));
        if (this.walker.enterElement("valueConstraints")) {
            ArrayList<ValueConstraint> constraints = new ArrayList<ValueConstraint>();
            type = def.getRequiredType();
            while (this.walker.iterateElements("valueConstraint")) {
                String constraint = this.walker.getContent();
                try {
                    constraints.add(ValueConstraint.create(type, constraint.trim(), this.resolver));
                }
                catch (InvalidConstraintException e) {
                    throw new InvalidNodeTypeDefException("Invalid value constraint " + constraint, e);
                }
            }
            def.setValueConstraints(constraints.toArray(new ValueConstraint[constraints.size()]));
            this.walker.leaveElement();
        }
        if (this.walker.enterElement("defaultValues")) {
            ArrayList<InternalValue> values = new ArrayList<InternalValue>();
            type = def.getRequiredType();
            if (type == 0) {
                type = 1;
            }
            while (this.walker.iterateElements("defaultValue")) {
                String value = this.walker.getContent();
                try {
                    values.add(InternalValue.create(ValueHelper.convert((String)value, (int)type, (ValueFactory)ValueFactoryImpl.getInstance()), this.resolver));
                }
                catch (RepositoryException e) {
                    throw new InvalidNodeTypeDefException("Unable to create default value: " + value, e);
                }
            }
            def.setDefaultValues(values.toArray(new InternalValue[values.size()]));
            this.walker.leaveElement();
        }
        return def;
    }

    private NodeDefImpl getChildNodeDef() throws NameException, NamespaceException {
        NodeDefImpl def = new NodeDefImpl();
        String name = this.walker.getAttribute("name");
        if (name.equals("*")) {
            def.setName(ItemDef.ANY_NAME);
        } else {
            def.setName(this.resolver.getQName(name));
        }
        def.setAutoCreated(Boolean.valueOf(this.walker.getAttribute("autoCreated")));
        def.setMandatory(Boolean.valueOf(this.walker.getAttribute("mandatory")));
        def.setProtected(Boolean.valueOf(this.walker.getAttribute("protected")));
        def.setOnParentVersion(OnParentVersionAction.valueFromName((String)this.walker.getAttribute("onParentVersion")));
        def.setAllowsSameNameSiblings(Boolean.valueOf(this.walker.getAttribute("sameNameSiblings")));
        String type = this.walker.getAttribute("defaultPrimaryType");
        if (type != null && type.length() > 0) {
            def.setDefaultPrimaryType(this.resolver.getQName(type));
        }
        if (this.walker.enterElement("requiredPrimaryTypes")) {
            ArrayList<Name> types = new ArrayList<Name>();
            while (this.walker.iterateElements("requiredPrimaryType")) {
                types.add(this.resolver.getQName(this.walker.getContent()));
            }
            def.setRequiredPrimaryTypes(types.toArray(new Name[types.size()]));
            this.walker.leaveElement();
        }
        return def;
    }
}

