/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.spi.connector;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.ArtifactTransfer;
import org.sonatype.aether.spi.connector.Transfer;
import org.sonatype.aether.transfer.ArtifactTransferException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactDownload
extends ArtifactTransfer {
    private boolean existenceCheck;
    private String checksumPolicy = "";
    private String context = "";
    private Collection<String> contexts = Collections.emptySet();
    private List<RemoteRepository> repositories = Collections.emptyList();

    public ArtifactDownload() {
    }

    public ArtifactDownload(Artifact artifact, String context, File file, String checksumPolicy) {
        this.setArtifact(artifact);
        this.setRequestContext(context);
        this.setFile(file);
        this.setChecksumPolicy(checksumPolicy);
    }

    @Override
    public ArtifactDownload setArtifact(Artifact artifact) {
        super.setArtifact(artifact);
        return this;
    }

    @Override
    public ArtifactDownload setFile(File file) {
        super.setFile(file);
        return this;
    }

    public boolean isExistenceCheck() {
        return this.existenceCheck;
    }

    public ArtifactDownload setExistenceCheck(boolean existenceCheck) {
        this.existenceCheck = existenceCheck;
        return this;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public ArtifactDownload setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy != null ? checksumPolicy : "";
        return this;
    }

    public String getRequestContext() {
        return this.context;
    }

    public ArtifactDownload setRequestContext(String context) {
        String string = this.context = context != null ? context : "";
        if (Transfer.State.NEW.equals((Object)this.getState())) {
            this.contexts = Collections.singleton(context);
        }
        return this;
    }

    public Collection<String> getSupportedContexts() {
        return this.contexts;
    }

    public ArtifactDownload setSupportedContexts(Collection<String> contexts) {
        this.contexts = contexts == null || contexts.isEmpty() ? Collections.singleton(this.context) : contexts;
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public ArtifactDownload setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories == null ? Collections.emptyList() : repositories;
        return this;
    }

    @Override
    public ArtifactDownload setException(ArtifactTransferException exception) {
        super.setException(exception);
        return this;
    }

    public String toString() {
        return (Object)((Object)this.getState()) + " " + this.getArtifact() + " - " + (this.isExistenceCheck() ? "?" : "") + this.getFile();
    }
}

