/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.Locale;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class XmlMarshallingHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "read-config-as-xml";
    private final ConfigurationPersister configPersister;

    public XmlMarshallingHandler(ConfigurationPersister configPersister) {
        this.configPersister = configPersister;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getReadConfigAsXmlOperation(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(OperationContext context, ModelNode operation) {
        Resource resource = context.readResourceFromRoot(this.getBaseAddress());
        ModelNode model = Resource.Tools.readModel(resource);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                BufferedOutputStream output = new BufferedOutputStream(baos);
                this.configPersister.marshallAsXml(model, output);
                output.close();
                baos.close();
            }
            finally {
                this.safeClose(baos);
            }
            String xml = new String(baos.toByteArray());
            context.getResult().set(xml);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            ControllerLogger.MGMT_OP_LOGGER.failedExecutingOperation(e, operation.require("operation"), PathAddress.pathAddress(operation.get("address")));
            context.getFailureDescription().set(e.toString());
        }
        context.completeStep();
    }

    protected PathAddress getBaseAddress() {
        return PathAddress.EMPTY_ADDRESS;
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                ControllerLogger.MGMT_OP_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }
}

