/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.IClass;
import org.testng.IConfigurable;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.SuiteRunState;
import org.testng.TestException;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.NoInjection;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ExpectedExceptionsHolder;
import org.testng.internal.IConfiguration;
import org.testng.internal.IConfigurationListener;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokeMethodRunnable;
import org.testng.internal.InvokedMethod;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Parameters;
import org.testng.internal.PoolService;
import org.testng.internal.SingleTestMethodWorker;
import org.testng.internal.TestMethodWithDataProviderMethodWorker;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.Sets;
import org.testng.internal.invokers.InvokedMethodListenerInvoker;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.thread.ThreadExecutionException;
import org.testng.internal.thread.ThreadUtil;
import org.testng.internal.thread.graph.IWorker;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker
implements IInvoker {
    private final ITestContext m_testContext;
    private final ITestResultNotifier m_notifier;
    private final IAnnotationFinder m_annotationFinder;
    private final SuiteRunState m_suiteState;
    private final boolean m_skipFailedInvocationCounts;
    private final List<IInvokedMethodListener> m_invokedMethodListeners;
    private final boolean m_continueOnFailedConfiguration;
    private Map<String, Boolean> m_beforegroupsFailures = Maps.newHashtable();
    private Map<Class<?>, Set<Object>> m_classInvocationResults = Maps.newHashtable();
    private Map<ITestNGMethod, Set<Object>> m_methodInvocationResults = Maps.newHashtable();
    private IConfiguration m_configuration;

    private void setClassInvocationFailure(Class<?> clazz, Object instance) {
        Set<Object> instances = this.m_classInvocationResults.get(clazz);
        if (instances == null) {
            instances = Sets.newHashSet();
            this.m_classInvocationResults.put(clazz, instances);
        }
        instances.add(instance);
    }

    private void setMethodInvocationFailure(ITestNGMethod method, Object instance) {
        Set<Object> instances = this.m_methodInvocationResults.get(method);
        if (instances == null) {
            instances = Sets.newHashSet();
            this.m_methodInvocationResults.put(method, instances);
        }
        instances.add(instance);
    }

    public Invoker(IConfiguration configuration, ITestContext testContext, ITestResultNotifier notifier, SuiteRunState state, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> invokedMethodListeners) {
        this.m_configuration = configuration;
        this.m_testContext = testContext;
        this.m_suiteState = state;
        this.m_notifier = notifier;
        this.m_annotationFinder = configuration.getAnnotationFinder();
        this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        this.m_invokedMethodListeners = invokedMethodListeners;
        this.m_continueOnFailedConfiguration = "continue".equals(testContext.getSuite().getXmlSuite().getConfigFailurePolicy());
    }

    @Override
    public void invokeConfigurations(IClass testClass, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object[] parameterValues, Object instance) {
        this.invokeConfigurations(testClass, null, allMethods, suite, params, parameterValues, instance, null);
    }

    private void invokeConfigurations(IClass testClass, ITestNGMethod currentTestMethod, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object[] parameterValues, Object instance, ITestResult testMethodResult) {
        ITestNGMethod[] methods;
        if (null == allMethods) {
            this.log(5, "No @Configuration methods found");
            return;
        }
        for (ITestNGMethod tm : methods = this.filterMethodsUnique(testClass, allMethods)) {
            if (null == testClass) {
                testClass = tm.getTestClass();
            }
            TestResult testResult = new TestResult(testClass, instance, tm, null, System.currentTimeMillis(), System.currentTimeMillis());
            IConfigurationAnnotation configurationAnnotation = null;
            try {
                Object[] instances = tm.getInstances();
                if (instances == null || instances.length == 0) {
                    instances = new Object[]{instance};
                }
                Class<?> objectClass = instances[0].getClass();
                Method method = tm.getMethod();
                if (MethodHelper.isEnabled(objectClass, this.m_annotationFinder)) {
                    configurationAnnotation = AnnotationHelper.findConfiguration(this.m_annotationFinder, method);
                    if (MethodHelper.isEnabled(configurationAnnotation)) {
                        Object[] objectArray;
                        boolean isClassConfiguration = this.isClassConfiguration(configurationAnnotation);
                        boolean isSuiteConfiguration = this.isSuiteConfiguration(configurationAnnotation);
                        boolean alwaysRun = this.isAlwaysRun(configurationAnnotation);
                        if (!this.confInvocationPassed(tm, currentTestMethod, testClass, instance) && !alwaysRun) {
                            this.handleConfigurationSkip(tm, testResult, configurationAnnotation, currentTestMethod, instance, suite);
                            continue;
                        }
                        this.log(3, "Invoking " + Utils.detailedMethodName(tm, true));
                        Object[] parameters = Parameters.createConfigurationParameters(tm.getMethod(), params, parameterValues, currentTestMethod, this.m_annotationFinder, suite, this.m_testContext, testMethodResult);
                        testResult.setParameters(parameters);
                        if (null != instance) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = instance;
                        } else {
                            objectArray = instances;
                        }
                        Object[] newInstances = objectArray;
                        this.invokeConfigurationMethod(newInstances, tm, parameters, isClassConfiguration, isSuiteConfiguration, testResult);
                        testResult.setEndMillis(System.currentTimeMillis());
                        this.runConfigurationListeners(testResult);
                        continue;
                    }
                    this.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because it is not enabled");
                    continue;
                }
                this.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because " + objectClass.getName() + " is not enabled");
            }
            catch (InvocationTargetException ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, currentTestMethod, instance, suite);
            }
            catch (TestNGException ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, currentTestMethod, instance, suite);
            }
            catch (Throwable ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, currentTestMethod, instance, suite);
            }
        }
    }

    private void handleConfigurationSkip(ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        this.recordConfigurationInvocationFailed(tm, testResult.getTestClass(), annotation, currentTestMethod, instance, suite);
        testResult.setStatus(3);
        this.runConfigurationListeners(testResult);
    }

    private boolean isClassConfiguration(IConfigurationAnnotation configurationAnnotation) {
        if (null == configurationAnnotation) {
            return false;
        }
        boolean before = configurationAnnotation.getBeforeTestClass();
        boolean after = configurationAnnotation.getAfterTestClass();
        return before || after;
    }

    private boolean isSuiteConfiguration(IConfigurationAnnotation configurationAnnotation) {
        if (null == configurationAnnotation) {
            return false;
        }
        boolean before = configurationAnnotation.getBeforeSuite();
        boolean after = configurationAnnotation.getAfterSuite();
        return before || after;
    }

    private boolean isAlwaysRun(IConfigurationAnnotation configurationAnnotation) {
        if (null == configurationAnnotation) {
            return false;
        }
        boolean alwaysRun = false;
        if ((configurationAnnotation.getAfterSuite() || configurationAnnotation.getAfterTest() || configurationAnnotation.getAfterTestClass() || configurationAnnotation.getAfterTestMethod()) && configurationAnnotation.getAlwaysRun()) {
            alwaysRun = true;
        }
        return alwaysRun;
    }

    private void handleConfigurationFailure(Throwable ite, ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        SkipException skipEx;
        Throwable cause;
        Throwable throwable = cause = ite.getCause() != null ? ite.getCause() : ite;
        if (SkipException.class.isAssignableFrom(cause.getClass()) && (skipEx = (SkipException)cause).isSkip()) {
            testResult.setThrowable(skipEx);
            this.handleConfigurationSkip(tm, testResult, annotation, currentTestMethod, instance, suite);
            return;
        }
        Utils.log("", 3, "Failed to invoke @Configuration method " + tm.getRealClass().getName() + "." + tm.getMethodName() + ":" + cause.getMessage());
        this.handleException(cause, tm, testResult, 1);
        this.runConfigurationListeners(testResult);
        if (null != annotation) {
            this.recordConfigurationInvocationFailed(tm, testResult.getTestClass(), annotation, currentTestMethod, instance, suite);
        }
    }

    private XmlClass[] findClassesInSameTest(Class<?> cls, XmlSuite suite) {
        Map<String, XmlClass> vResult = Maps.newHashMap();
        String className = cls.getName();
        for (XmlTest test : suite.getTests()) {
            for (XmlClass testClass : test.getXmlClasses()) {
                if (!testClass.getName().equals(className)) continue;
                for (XmlClass thisClass : test.getXmlClasses()) {
                    vResult.put(thisClass.getName(), thisClass);
                }
            }
        }
        XmlClass[] result = vResult.values().toArray(new XmlClass[vResult.size()]);
        return result;
    }

    private void recordConfigurationInvocationFailed(ITestNGMethod tm, IClass testClass, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        if (annotation.getBeforeTestClass() || annotation.getAfterTestClass()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setClassInvocationFailure(testClass.getRealClass(), instance);
            } else {
                this.setClassInvocationFailure(tm.getRealClass(), instance);
            }
        } else if (annotation.getBeforeTestMethod() || annotation.getAfterTestMethod()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setMethodInvocationFailure(currentTestMethod, instance);
            } else {
                this.setClassInvocationFailure(tm.getRealClass(), instance);
            }
        } else if (annotation.getBeforeSuite() || annotation.getAfterSuite()) {
            this.m_suiteState.failed();
        } else if (annotation.getBeforeTest() || annotation.getAfterTest()) {
            this.setClassInvocationFailure(tm.getRealClass(), instance);
            XmlClass[] classes = this.findClassesInSameTest(tm.getRealClass(), suite);
            for (XmlClass xmlClass : classes) {
                this.setClassInvocationFailure(xmlClass.getSupportClass(), instance);
            }
        }
        String[] beforeGroups = annotation.getBeforeGroups();
        if (null != beforeGroups && beforeGroups.length > 0) {
            for (String group : beforeGroups) {
                this.m_beforegroupsFailures.put(group, Boolean.FALSE);
            }
        }
    }

    private boolean confInvocationPassed(ITestNGMethod method, ITestNGMethod currentTestMethod, IClass testClass, Object instance) {
        Class<?> cls;
        boolean result = true;
        Class<?> clazz = cls = this.m_continueOnFailedConfiguration ? testClass.getRealClass() : method.getMethod().getDeclaringClass();
        if (this.m_suiteState.isFailed()) {
            result = false;
        } else if (this.m_classInvocationResults.containsKey(cls)) {
            result = !this.m_continueOnFailedConfiguration ? !this.m_classInvocationResults.containsKey(cls) : !this.m_classInvocationResults.get(cls).contains(instance);
        } else if (this.m_continueOnFailedConfiguration && currentTestMethod != null && this.m_methodInvocationResults.containsKey(currentTestMethod)) {
            result = !this.m_methodInvocationResults.get(currentTestMethod).contains(instance);
        } else if (!this.m_continueOnFailedConfiguration) {
            for (Class<?> clazz2 : this.m_classInvocationResults.keySet()) {
                if (!clazz2.isAssignableFrom(cls)) continue;
                result = false;
                break;
            }
        }
        String[] groups = method.getGroups();
        if (null != groups && groups.length > 0) {
            for (String group : groups) {
                if (!this.m_beforegroupsFailures.containsKey(group)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeConfigurationMethod(Object[] instances, ITestNGMethod tm, Object[] params, boolean isClass, boolean isSuite, ITestResult testResult) throws InvocationTargetException, IllegalAccessException {
        tm.setId(ThreadUtil.currentThreadInfo());
        Object[] arr$ = instances;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            Object var15_18;
            InvokedMethod invokedMethod;
            block13: {
                Object targetInstance = arr$[i$];
                invokedMethod = new InvokedMethod(targetInstance, tm, params, false, isClass, System.currentTimeMillis());
                this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, testResult);
                this.m_notifier.addInvokedMethod(invokedMethod);
                try {
                    try {
                        IConfigurable configurableInstance;
                        Reporter.setCurrentTestResult(testResult);
                        Method method = tm.getMethod();
                        IConfigurable iConfigurable = configurableInstance = IConfigurable.class.isAssignableFrom(tm.getMethod().getDeclaringClass()) ? (IConfigurable)targetInstance : this.m_configuration.getConfigurable();
                        if (configurableInstance != null) {
                            MethodInvocationHelper.invokeConfigurable(targetInstance, params, configurableInstance, method, testResult);
                        } else if (MethodHelper.calculateTimeOut(tm) <= 0L) {
                            MethodInvocationHelper.invokeMethod(method, targetInstance, params);
                        } else {
                            MethodInvocationHelper.invokeWithTimeout(tm, targetInstance, params, testResult);
                            if (!testResult.isSuccess()) {
                                this.throwConfigurationFailure(testResult, testResult.getThrowable());
                                throw testResult.getThrowable();
                            }
                        }
                        if (!isSuite) break block13;
                        var15_18 = null;
                    }
                    catch (InvocationTargetException ex) {
                        this.throwConfigurationFailure(testResult, ex);
                        throw ex;
                    }
                    catch (IllegalAccessException ex) {
                        this.throwConfigurationFailure(testResult, ex);
                        throw ex;
                    }
                    catch (NoSuchMethodException ex) {
                        this.throwConfigurationFailure(testResult, ex);
                        throw new TestNGException(ex);
                    }
                    catch (Throwable ex) {
                        this.throwConfigurationFailure(testResult, ex);
                        throw new TestNGException(ex);
                    }
                }
                catch (Throwable throwable) {
                    var15_18 = null;
                    Reporter.setCurrentTestResult(testResult);
                    this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
                    throw throwable;
                }
                Reporter.setCurrentTestResult(testResult);
                this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
                return;
            }
            var15_18 = null;
            Reporter.setCurrentTestResult(testResult);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
            ++i$;
        }
    }

    private void throwConfigurationFailure(ITestResult testResult, Throwable ex) {
        testResult.setStatus(2);
        testResult.setThrowable(ex.getCause() == null ? ex : ex.getCause());
    }

    private void runInvokedMethodListeners(InvokedMethodListenerMethod listenerMethod, IInvokedMethod invokedMethod, ITestResult testResult) {
        if (this.noListenersPresent()) {
            return;
        }
        InvokedMethodListenerInvoker invoker = new InvokedMethodListenerInvoker(listenerMethod, testResult, this.m_testContext);
        for (IInvokedMethodListener currentListener : this.m_invokedMethodListeners) {
            invoker.invokeListener(currentListener, invokedMethod);
        }
    }

    private boolean noListenersPresent() {
        return this.m_invokedMethodListeners == null || this.m_invokedMethodListeners.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITestResult invokeMethod(Object[] instances, int instanceIndex, ITestNGMethod tm, Object[] parameterValues, int parametersIndex, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods) {
        TestResult testResult = new TestResult();
        Object instance = instances[instanceIndex];
        this.invokeBeforeGroupsConfigurations(testClass, tm, groupMethods, suite, params, instance);
        this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, beforeMethods, true), suite, params, parameterValues, instance, testResult);
        InvokedMethod invokedMethod = null;
        try {
            try {
                testResult.init(testClass, instance, tm, null, System.currentTimeMillis(), 0L);
                testResult.setParameters(parameterValues);
                testResult.setHost(this.m_testContext.getHost());
                testResult.setStatus(16);
                invokedMethod = new InvokedMethod(instance, tm, parameterValues, true, false, System.currentTimeMillis());
                this.runTestListeners(testResult);
                this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, testResult);
                this.m_notifier.addInvokedMethod(invokedMethod);
                Method thisMethod = tm.getMethod();
                if (this.confInvocationPassed(tm, tm, testClass, instance)) {
                    this.log(3, "Invoking " + thisMethod.getDeclaringClass().getName() + "." + thisMethod.getName());
                    if (MethodHelper.calculateTimeOut(tm) <= 0L) {
                        try {
                            IHookable hookableInstance;
                            Reporter.setCurrentTestResult(testResult);
                            IHookable iHookable = hookableInstance = IHookable.class.isAssignableFrom(thisMethod.getDeclaringClass()) ? (IHookable)instance : this.m_configuration.getHookable();
                            if (hookableInstance != null) {
                                MethodInvocationHelper.invokeHookable(instance, parameterValues, hookableInstance, thisMethod, testResult);
                            } else {
                                MethodInvocationHelper.invokeMethod(thisMethod, instance, parameterValues);
                            }
                            testResult.setStatus(1);
                            Object var18_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var18_22 = null;
                            Reporter.setCurrentTestResult(null);
                            throw throwable;
                        }
                        Reporter.setCurrentTestResult(null);
                    }
                    try {
                        Reporter.setCurrentTestResult(testResult);
                        MethodInvocationHelper.invokeWithTimeout(tm, instance, parameterValues, testResult);
                        Object var20_24 = null;
                    }
                    catch (Throwable throwable) {
                        Object var20_25 = null;
                        Reporter.setCurrentTestResult(null);
                        throw throwable;
                    }
                    Reporter.setCurrentTestResult(null);
                }
                testResult.setStatus(3);
            }
            catch (InvocationTargetException ite) {
                testResult.setThrowable(ite.getCause());
                testResult.setStatus(2);
                Object var22_28 = null;
                ExpectedExceptionsHolder expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
                List<ITestResult> results = Lists.newArrayList();
                results.add(testResult);
                this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
                this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
                if (testResult.getThrowable() != null && parameterValues.length > 0) {
                    tm.addFailedInvocationNumber(parametersIndex);
                }
                tm.incrementCurrentInvocationCount();
                if (testResult != null) {
                    testResult.setEndMillis(System.currentTimeMillis());
                }
                this.runTestListeners(testResult);
                this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instance, testResult);
                this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instance);
                return testResult;
            }
            catch (ThreadExecutionException tee) {
                Throwable cause = tee.getCause();
                if (InvokeMethodRunnable.TestNGRuntimeException.class.equals(cause.getClass())) {
                    testResult.setThrowable(cause.getCause());
                } else {
                    testResult.setThrowable(cause);
                }
                testResult.setStatus(2);
                Object var22_29 = null;
                ExpectedExceptionsHolder expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
                List<ITestResult> results = Lists.newArrayList();
                results.add(testResult);
                this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
                this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
                if (testResult.getThrowable() != null && parameterValues.length > 0) {
                    tm.addFailedInvocationNumber(parametersIndex);
                }
                tm.incrementCurrentInvocationCount();
                if (testResult != null) {
                    testResult.setEndMillis(System.currentTimeMillis());
                }
                this.runTestListeners(testResult);
                this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instance, testResult);
                this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instance);
                return testResult;
            }
            catch (Throwable thr) {
                testResult.setThrowable(thr);
                testResult.setStatus(2);
                Object var22_30 = null;
                ExpectedExceptionsHolder expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
                List<ITestResult> results = Lists.newArrayList();
                results.add(testResult);
                this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
                this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
                if (testResult.getThrowable() != null && parameterValues.length > 0) {
                    tm.addFailedInvocationNumber(parametersIndex);
                }
                tm.incrementCurrentInvocationCount();
                if (testResult != null) {
                    testResult.setEndMillis(System.currentTimeMillis());
                }
                this.runTestListeners(testResult);
                this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instance, testResult);
                this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instance);
                return testResult;
            }
            Object var22_27 = null;
        }
        catch (Throwable throwable) {
            Object var22_31 = null;
            ExpectedExceptionsHolder expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
            List<ITestResult> results = Lists.newArrayList();
            results.add(testResult);
            this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
            if (testResult.getThrowable() != null && parameterValues.length > 0) {
                tm.addFailedInvocationNumber(parametersIndex);
            }
            tm.incrementCurrentInvocationCount();
            if (testResult != null) {
                testResult.setEndMillis(System.currentTimeMillis());
            }
            this.runTestListeners(testResult);
            this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instance, testResult);
            this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instance);
            throw throwable;
        }
        ExpectedExceptionsHolder expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, tm.getMethod());
        List<ITestResult> results = Lists.newArrayList();
        results.add(testResult);
        this.handleInvocationResults(tm, results, null, 0, expectedExceptionClasses, false, true);
        this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
        if (testResult.getThrowable() != null && parameterValues.length > 0) {
            tm.addFailedInvocationNumber(parametersIndex);
        }
        tm.incrementCurrentInvocationCount();
        if (testResult != null) {
            testResult.setEndMillis(System.currentTimeMillis());
        }
        this.runTestListeners(testResult);
        this.invokeConfigurations(testClass, tm, this.filterConfigurationMethods(tm, afterMethods, false), suite, params, parameterValues, instance, testResult);
        this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instance);
        return testResult;
    }

    private ITestNGMethod[] filterConfigurationMethods(ITestNGMethod tm, ITestNGMethod[] methods, boolean isBefore) {
        List result = Lists.newArrayList();
        for (ITestNGMethod m : methods) {
            ConfigurationMethod cm = (ConfigurationMethod)m;
            if (isBefore) {
                if (cm.isFirstTimeOnly() && (!cm.isFirstTimeOnly() || tm.getCurrentInvocationCount() != 0)) continue;
                result.add(m);
                continue;
            }
            int current = tm.getCurrentInvocationCount();
            boolean isLast = false;
            if (tm.getParameterInvocationCount() > 0) {
                isLast = current == tm.getParameterInvocationCount();
            } else if (tm.getInvocationCount() > 1) {
                boolean bl = isLast = current == tm.getInvocationCount();
            }
            if (cm.isLastTimeOnly() && (!cm.isLastTimeOnly() || !isLast)) continue;
            result.add(m);
        }
        return result.toArray(new ITestNGMethod[result.size()]);
    }

    protected List<ITestResult> invokeTestMethod(Object[] instances, ITestNGMethod tm, Object[] parameterValues, int parametersIndex, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods) {
        List<ITestResult> results = Lists.newArrayList();
        tm.setId(ThreadUtil.currentThreadInfo());
        for (int i = 0; i < instances.length; ++i) {
            results.add(this.invokeMethod(instances, i, tm, parameterValues, parametersIndex, suite, params, testClass, beforeMethods, afterMethods, groupMethods));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeBeforeGroupsConfigurations(ITestClass testClass, ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        ConfigurationGroupMethods configurationGroupMethods = groupMethods;
        synchronized (configurationGroupMethods) {
            List filteredMethods = Lists.newArrayList();
            String[] groups = currentTestMethod.getGroups();
            Map<String, List<ITestNGMethod>> beforeGroupMap = groupMethods.getBeforeGroupsMap();
            for (String group : groups) {
                List<ITestNGMethod> methods = beforeGroupMap.get(group);
                if (methods == null) continue;
                filteredMethods.addAll(methods);
            }
            ITestNGMethod[] beforeMethodsArray = filteredMethods.toArray(new ITestNGMethod[filteredMethods.size()]);
            if (beforeMethodsArray.length > 0) {
                this.invokeConfigurations(null, beforeMethodsArray, suite, params, null, null);
            }
            groupMethods.removeBeforeGroups(groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAfterGroupsConfigurations(ITestClass testClass, ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        if (currentTestMethod.getGroups().length == 0) {
            return;
        }
        Map<String, String> filteredGroups = Maps.newHashMap();
        String[] groups = currentTestMethod.getGroups();
        ConfigurationGroupMethods configurationGroupMethods = groupMethods;
        synchronized (configurationGroupMethods) {
            for (String group : groups) {
                if (!groupMethods.isLastMethodForGroup(group, currentTestMethod)) continue;
                filteredGroups.put(group, group);
            }
            if (filteredGroups.isEmpty()) {
                return;
            }
            Map<ITestNGMethod, ITestNGMethod> afterMethods = Maps.newHashMap();
            Map<String, List<ITestNGMethod>> map = groupMethods.getAfterGroupsMap();
            for (String g : filteredGroups.values()) {
                List<ITestNGMethod> methods = map.get(g);
                if (methods == null) continue;
                for (ITestNGMethod m : methods) {
                    afterMethods.put(m, m);
                }
            }
            ITestNGMethod[] afterMethodsArray = afterMethods.keySet().toArray(new ITestNGMethod[afterMethods.size()]);
            this.invokeConfigurations(null, afterMethodsArray, suite, params, null, null);
            groupMethods.removeAfterGroups(filteredGroups.keySet());
        }
    }

    private Object[] getParametersFromIndex(Iterator<Object[]> parametersValues, int index) {
        while (parametersValues.hasNext()) {
            Object[] parameters = parametersValues.next();
            if (index == 0) {
                return parameters;
            }
            --index;
        }
        return null;
    }

    int retryFailed(Object[] instances, int instanceIndex, ITestNGMethod tm, XmlSuite suite, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, List<ITestResult> result, int failureCount, ExpectedExceptionsHolder expectedExceptionHolder, ITestContext testContext, Map<String, String> parameters, int parametersIndex) {
        List<Object> failedInstances;
        do {
            failedInstances = Lists.newArrayList();
            Map<String, String> allParameters = Maps.newHashMap();
            ParameterBag bag = this.createParameters(testClass, tm, parameters, allParameters, null, suite, testContext, null, null);
            Object[] parameterValues = this.getParametersFromIndex(bag.parameterHolder.parameters, parametersIndex);
            result.add(this.invokeMethod(instances, instanceIndex, tm, parameterValues, parametersIndex, suite, allParameters, testClass, beforeMethods, afterMethods, groupMethods));
            failureCount = this.handleInvocationResults(tm, result, failedInstances, failureCount, expectedExceptionHolder, true, true);
        } while (!failedInstances.isEmpty());
        return failureCount;
    }

    private ParameterBag createParameters(ITestClass testClass, ITestNGMethod testMethod, Map<String, String> parameters, Map<String, String> allParameterNames, Object[] parameterValues, XmlSuite suite, ITestContext testContext, Object fedInstance, ITestResult testResult) {
        Object instance;
        if (fedInstance != null) {
            instance = fedInstance;
        } else {
            Object[] instances = testClass.getInstances(true);
            instance = instances[0];
        }
        ParameterBag bag = this.handleParameters(testMethod, instance, allParameterNames, parameters, parameterValues, suite, testContext, fedInstance, testResult);
        return bag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod testMethod, ITestNGMethod[] allTestMethods, int testMethodIndex, XmlSuite suite, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, Object[] instances, ITestContext testContext) {
        assert (null != testMethod.getTestClass()) : "COULDN'T FIND TESTCLASS FOR " + testMethod.getMethod().getDeclaringClass();
        List<ITestResult> result = Lists.newArrayList();
        if (!MethodHelper.isEnabled(testMethod.getMethod(), this.m_annotationFinder)) {
            return result;
        }
        ITestClass testClass = testMethod.getTestClass();
        long start = System.currentTimeMillis();
        long timeOutInvocationCount = testMethod.getInvocationTimeOut();
        boolean onlyOne = testMethod.getThreadPoolSize() > 1 || timeOutInvocationCount > 0L;
        int invocationCount = onlyOne ? 1 : testMethod.getInvocationCount();
        int failureCount = 0;
        ExpectedExceptionsHolder expectedExceptionHolder = MethodHelper.findExpectedExceptions(this.m_annotationFinder, testMethod.getMethod());
        while (invocationCount-- > 0) {
            boolean okToProceed = this.checkDependencies(testMethod, allTestMethods);
            if (!okToProceed) {
                TestResult testResult = new TestResult(testClass, null, testMethod, null, start, System.currentTimeMillis());
                String missingGroup = testMethod.getMissingGroup();
                if (missingGroup != null) {
                    testResult.setThrowable(new Throwable("Method " + testMethod + " depends on nonexistent group \"" + missingGroup + "\""));
                }
                testResult.setStatus(3);
                result.add(testResult);
                this.m_notifier.addSkippedTest(testMethod, testResult);
                this.runTestListeners(testResult);
                return result;
            }
            if (testMethod.getThreadPoolSize() > 1 && testMethod.getInvocationCount() > 1) {
                return this.invokePooledTestMethods(testMethod, allTestMethods, suite, parameters, groupMethods, testContext);
            }
            ITestNGMethod[] beforeMethods = this.filterMethods(testClass, testClass.getBeforeTestMethods());
            ITestNGMethod[] afterMethods = this.filterMethods(testClass, testClass.getAfterTestMethods());
            Map<String, String> allParameterNames = Maps.newHashMap();
            ParameterBag bag = this.createParameters(testClass, testMethod, parameters, allParameterNames, null, suite, testContext, instances[0], null);
            if (bag.hasErrors()) {
                failureCount = this.handleInvocationResults(testMethod, bag.errorResults, null, failureCount, expectedExceptionHolder, true, true);
                ITestResult tr = this.registerSkippedTestResult(testMethod, instances[0], start, bag.errorResults.get(0).getThrowable());
                result.add(tr);
                continue;
            }
            Iterator<Object[]> allParameterValues = bag.parameterHolder.parameters;
            int parametersIndex = 0;
            try {
                Object v0;
                Object[] parameterValues;
                List workers = Lists.newArrayList();
                if (bag.parameterHolder.origin == ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER && bag.parameterHolder.dataProviderHolder.annotation.isParallel()) {
                    while (allParameterValues.hasNext()) {
                        parameterValues = this.injectParameters(allParameterValues.next(), testMethod.getMethod(), testContext, null);
                        TestMethodWithDataProviderMethodWorker w = new TestMethodWithDataProviderMethodWorker(this, testMethod, parametersIndex, parameterValues, instances, suite, parameters, testClass, beforeMethods, afterMethods, groupMethods, expectedExceptionHolder, testContext, this.m_skipFailedInvocationCounts, invocationCount, failureCount, this.m_notifier);
                        workers.add(w);
                        ++parametersIndex;
                    }
                    PoolService ps = PoolService.getInstance();
                    List r = ps.submitTasksAndWait(testMethod, workers);
                    result.addAll(r);
                    continue;
                }
                if (!allParameterValues.hasNext()) continue;
                parameterValues = this.injectParameters(allParameterValues.next(), testMethod.getMethod(), testContext, null);
                List<ITestResult> tmpResults = Lists.newArrayList();
                try {
                    tmpResults.addAll(this.invokeTestMethod(instances, testMethod, parameterValues, parametersIndex, suite, parameters, testClass, beforeMethods, afterMethods, groupMethods));
                    v0 = null;
                }
                catch (Throwable throwable) {
                    v0 = null;
                }
                Object var30_29 = v0;
                List<Object> failedInstances = Lists.newArrayList();
                failureCount = this.handleInvocationResults(testMethod, tmpResults, failedInstances, failureCount, expectedExceptionHolder, true, false);
                if (failedInstances.isEmpty()) {
                    result.addAll(tmpResults);
                } else {
                    for (int i = 0; i < failedInstances.size(); ++i) {
                        List<ITestResult> retryResults = Lists.newArrayList();
                        failureCount = this.retryFailed(failedInstances.toArray(), i, testMethod, suite, testClass, beforeMethods, afterMethods, groupMethods, retryResults, failureCount, expectedExceptionHolder, testContext, parameters, parametersIndex);
                        result.addAll(retryResults);
                    }
                }
                if (failureCount > 0 && (this.m_skipFailedInvocationCounts || testMethod.skipFailedInvocations())) {
                    while (invocationCount-- > 0) {
                        result.add(this.registerSkippedTestResult(testMethod, instances[0], start, null));
                    }
                }
                // JSR Ret
            }
            catch (Throwable cause) {
                TestResult r = new TestResult(testMethod.getTestClass(), instances[0], testMethod, cause, start, System.currentTimeMillis());
                r.setStatus(2);
                result.add(r);
                this.runTestListeners(r);
                this.m_notifier.addFailedTest(testMethod, r);
            }
        }
        return result;
    }

    private ITestResult registerSkippedTestResult(ITestNGMethod testMethod, Object instance, long start, Throwable throwable) {
        TestResult result = new TestResult(testMethod.getTestClass(), instance, testMethod, throwable, start, System.currentTimeMillis());
        result.setStatus(3);
        this.runTestListeners(result);
        return result;
    }

    private Object[] injectParameters(Object[] parameterValues, Method method, ITestContext context, ITestResult testResult) throws TestNGException {
        List vResult = Lists.newArrayList();
        int i = 0;
        int numValues = parameterValues.length;
        int numParams = method.getParameterTypes().length;
        if (numValues > numParams) {
            throw new TestNGException("Number of parameter values passed in using data provider exceeds number of parameters defined on test method");
        }
        for (Class<?> cls : method.getParameterTypes()) {
            Object injected;
            Annotation[] annotations = method.getParameterAnnotations()[i];
            boolean noInjection = false;
            for (Annotation a : annotations) {
                if (!(a instanceof NoInjection)) continue;
                noInjection = true;
                break;
            }
            if ((injected = Parameters.getInjectedParameter(cls, method, context, testResult)) != null && !noInjection) {
                vResult.add(injected);
                continue;
            }
            try {
                vResult.add(parameterValues[i++]);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new TestNGException("Number of parameter values passed in using data provider is less than number of parameters defined on test method and TestNG is unable in inject a suitable object", ex);
            }
        }
        return vResult.toArray(new Object[vResult.size()]);
    }

    private ParameterBag handleParameters(ITestNGMethod testMethod, Object instance, Map<String, String> allParameterNames, Map<String, String> parameters, Object[] parameterValues, XmlSuite suite, ITestContext testContext, Object fedInstance, ITestResult testResult) {
        try {
            return new ParameterBag(Parameters.handleParameters(testMethod, allParameterNames, instance, new Parameters.MethodParameters(parameters, parameterValues, testMethod.getMethod(), testContext, testResult), suite, this.m_annotationFinder, fedInstance), null);
        }
        catch (Throwable cause) {
            return new ParameterBag(null, new TestResult(testMethod.getTestClass(), instance, testMethod, cause, System.currentTimeMillis(), System.currentTimeMillis()));
        }
    }

    private List<ITestResult> invokePooledTestMethods(ITestNGMethod testMethod, ITestNGMethod[] allTestMethods, XmlSuite suite, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, ITestContext testContext) {
        List<IWorker<ITestNGMethod>> workers = Lists.newArrayList();
        for (int i = 0; i < testMethod.getInvocationCount(); ++i) {
            ITestNGMethod clonedMethod = testMethod.clone();
            clonedMethod.setInvocationCount(1);
            clonedMethod.setThreadPoolSize(1);
            MethodInstance mi = new MethodInstance(clonedMethod, clonedMethod.getTestClass().getInstances(true));
            workers.add(new SingleTestMethodWorker(this, mi, suite, parameters, allTestMethods, testContext));
        }
        return this.runWorkers(testMethod, workers, testMethod.getThreadPoolSize(), groupMethods, suite, parameters);
    }

    int handleInvocationResults(ITestNGMethod testMethod, List<ITestResult> result, List<Object> failedInstances, int failureCount, ExpectedExceptionsHolder expectedExceptionsHolder, boolean triggerListeners, boolean collectResults) {
        List<ITestResult> resultsToRetry = Lists.newArrayList();
        for (int i = 0; i < result.size(); ++i) {
            Class<?>[] classes;
            ITestResult testResult = result.get(i);
            Throwable ite = testResult.getThrowable();
            int status = testResult.getStatus();
            if (ite != null) {
                if (this.isExpectedException(ite, expectedExceptionsHolder)) {
                    if (this.messageRegExpMatches(expectedExceptionsHolder.messageRegExp, ite)) {
                        testResult.setStatus(1);
                        status = 1;
                    } else {
                        testResult.setThrowable(new TestException("The exception was thrown with the wrong message: expected \"" + expectedExceptionsHolder.messageRegExp + "\"" + " but got \"" + ite.getMessage() + "\"", ite));
                        status = 2;
                    }
                } else if (ite != null && expectedExceptionsHolder != null) {
                    testResult.setThrowable(new TestException("Expected exception " + expectedExceptionsHolder.expectedClasses[0].getName() + " but got " + ite, ite));
                    status = 2;
                } else if (SkipException.class.isAssignableFrom(ite.getClass())) {
                    SkipException skipEx = (SkipException)ite;
                    if (skipEx.isSkip()) {
                        status = 3;
                    } else {
                        this.handleException(ite, testMethod, testResult, failureCount++);
                        status = 2;
                    }
                } else {
                    this.handleException(ite, testMethod, testResult, failureCount++);
                    status = testResult.getStatus();
                }
            } else if (status != 3 && expectedExceptionsHolder != null && (classes = expectedExceptionsHolder.expectedClasses) != null && classes.length > 0) {
                testResult.setThrowable(new TestException("Method " + testMethod + " should have thrown an exception of " + expectedExceptionsHolder.expectedClasses[0]));
                status = 2;
            }
            testResult.setStatus(status);
            boolean retry = false;
            if (testResult.getStatus() == 2) {
                IRetryAnalyzer retryAnalyzer = testMethod.getRetryAnalyzer();
                if (retryAnalyzer != null && failedInstances != null) {
                    retry = retryAnalyzer.retry(testResult);
                }
                if (retry) {
                    resultsToRetry.add(testResult);
                    if (failedInstances != null) {
                        failedInstances.add(testResult.getInstance());
                    }
                }
            }
            if (retry && !collectResults) continue;
            if (1 == status) {
                this.m_notifier.addPassedTest(testMethod, testResult);
                continue;
            }
            if (3 == status) {
                this.m_notifier.addSkippedTest(testMethod, testResult);
                continue;
            }
            if (2 == status) {
                this.m_notifier.addFailedTest(testMethod, testResult);
                continue;
            }
            if (4 == status) {
                this.m_notifier.addFailedButWithinSuccessPercentageTest(testMethod, testResult);
                continue;
            }
            assert (false) : "UNKNOWN STATUS:" + status;
        }
        return this.removeResultsToRetryFromResult(resultsToRetry, result, failureCount);
    }

    private boolean messageRegExpMatches(String messageRegExp, Throwable ite) {
        if (".*".equals(messageRegExp)) {
            return true;
        }
        if (ite.getMessage() == null) {
            return false;
        }
        return Pattern.matches(messageRegExp, ite.getMessage());
    }

    private int removeResultsToRetryFromResult(List<ITestResult> resultsToRetry, List<ITestResult> result, int failureCount) {
        if (resultsToRetry != null) {
            for (ITestResult res : resultsToRetry) {
                result.remove(res);
                --failureCount;
            }
        }
        return failureCount;
    }

    private List<ITestResult> runWorkers(ITestNGMethod testMethod, List<IWorker<ITestNGMethod>> workers, int threadPoolSize, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> parameters) {
        Object[] instances;
        ITestClass testClass = testMethod.getTestClass();
        for (Object instance : instances = testClass.getInstances(true)) {
            this.invokeBeforeGroupsConfigurations(testClass, testMethod, groupMethods, suite, parameters, instance);
        }
        long maxTimeOut = -1L;
        for (IWorker<ITestNGMethod> tmw : workers) {
            long mt = tmw.getTimeOut();
            if (mt <= maxTimeOut) continue;
            maxTimeOut = mt;
        }
        ThreadUtil.execute(workers, threadPoolSize, maxTimeOut, true);
        List<ITestResult> result = Lists.newArrayList();
        for (IWorker<ITestNGMethod> tmw : workers) {
            if (!(tmw instanceof TestMethodWorker)) continue;
            result.addAll(((TestMethodWorker)tmw).getTestResults());
        }
        for (Object instance : instances) {
            this.invokeAfterGroupsConfigurations(testClass, testMethod, groupMethods, suite, parameters, instance);
        }
        return result;
    }

    private boolean checkDependencies(ITestNGMethod testMethod, ITestNGMethod[] allTestMethods) {
        boolean result = true;
        if (testMethod.isAlwaysRun()) {
            return true;
        }
        if (testMethod.getMissingGroup() != null && !testMethod.ignoreMissingDependencies()) {
            return false;
        }
        if (this.dependsOnGroups(testMethod)) {
            String[] groupsDependedUpon;
            for (String element : groupsDependedUpon = testMethod.getGroupsDependedUpon()) {
                ITestNGMethod[] methods = MethodGroupsHelper.findMethodsThatBelongToGroup(testMethod, this.m_testContext.getAllTestMethods(), element);
                result = result && this.haveBeenRunSuccessfully(methods);
            }
        }
        if (result && this.dependsOnMethods(testMethod)) {
            ITestNGMethod[] methods = MethodHelper.findDependedUponMethods(testMethod, allTestMethods);
            result = result && this.haveBeenRunSuccessfully(methods);
        }
        return result;
    }

    private boolean haveBeenRunSuccessfully(ITestNGMethod[] methods) {
        for (ITestNGMethod method : methods) {
            Set<ITestResult> results = this.m_notifier.getPassedTests(method);
            Set<ITestResult> failedresults = this.m_notifier.getFailedTests(method);
            if (failedresults != null && failedresults.size() > 0) {
                return false;
            }
            if (results == null || results.size() == 0) {
                return false;
            }
            for (ITestResult result : results) {
                if (result.isSuccess()) continue;
                return false;
            }
        }
        return true;
    }

    private void handleException(Throwable throwable, ITestNGMethod testMethod, ITestResult testResult, int failureCount) {
        testResult.setThrowable(throwable);
        int successPercentage = testMethod.getSuccessPercentage();
        int invocationCount = testMethod.getInvocationCount();
        float numberOfTestsThatCanFail = (float)((100 - successPercentage) * invocationCount) / 100.0f;
        if ((float)failureCount < numberOfTestsThatCanFail) {
            testResult.setStatus(4);
        } else {
            testResult.setStatus(2);
        }
    }

    private boolean isExpectedException(Throwable ite, ExpectedExceptionsHolder exceptionHolder) {
        if (exceptionHolder == null) {
            return false;
        }
        if (ite.getClass() == TestException.class) {
            return false;
        }
        Class<?>[] exceptions = exceptionHolder.expectedClasses;
        Class<?> realExceptionClass = ite.getClass();
        for (Class<?> exception : exceptions) {
            if (!exception.isAssignableFrom(realExceptionClass)) continue;
            return true;
        }
        return false;
    }

    private ITestNGMethod[] filterMethods(IClass testClass, ITestNGMethod[] methods) {
        List vResult = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            if (tm.canRunFromClass(testClass)) {
                this.log(9, "Keeping method " + tm + " for class " + testClass);
                vResult.add(tm);
                continue;
            }
            this.log(9, "Filtering out method " + tm + " for class " + testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private ITestNGMethod[] filterMethodsUnique(IClass testClass, ITestNGMethod[] methods) {
        if (null == testClass) {
            return methods;
        }
        List vResult = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            testClass = tm.getTestClass();
            if (tm.getTestClass().getName().equals(testClass.getName())) {
                this.log(9, "        Keeping method " + tm + " for class " + testClass);
                vResult.add(tm);
                continue;
            }
            this.log(9, "        Filtering out method " + tm + " for class " + testClass);
        }
        return vResult.toArray(new ITestNGMethod[vResult.size()]);
    }

    private boolean dependsOnGroups(ITestNGMethod tm) {
        String[] groups = tm.getGroupsDependedUpon();
        boolean result = null != groups && groups.length > 0;
        return result;
    }

    private boolean dependsOnMethods(ITestNGMethod tm) {
        String[] methods = tm.getMethodsDependedUpon();
        boolean result = null != methods && methods.length > 0;
        return result;
    }

    private void runConfigurationListeners(ITestResult tr) {
        for (IConfigurationListener icl : this.m_notifier.getConfigurationListeners()) {
            switch (tr.getStatus()) {
                case 3: {
                    icl.onConfigurationSkip(tr);
                    break;
                }
                case 2: {
                    icl.onConfigurationFailure(tr);
                    break;
                }
                case 1: {
                    icl.onConfigurationSuccess(tr);
                }
            }
        }
    }

    void runTestListeners(ITestResult tr) {
        Invoker.runTestListeners(tr, this.m_notifier.getTestListeners());
    }

    public static void runTestListeners(ITestResult tr, List<ITestListener> listeners) {
        block7: for (ITestListener itl : listeners) {
            switch (tr.getStatus()) {
                case 3: {
                    itl.onTestSkipped(tr);
                    continue block7;
                }
                case 4: {
                    itl.onTestFailedButWithinSuccessPercentage(tr);
                    continue block7;
                }
                case 2: {
                    itl.onTestFailure(tr);
                    continue block7;
                }
                case 1: {
                    itl.onTestSuccess(tr);
                    continue block7;
                }
                case 16: {
                    itl.onTestStart(tr);
                    continue block7;
                }
            }
            assert (false) : "UNKNOWN STATUS:" + tr;
        }
    }

    private void log(int level, String s) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), level, s);
    }

    private static class ParameterBag {
        final ParameterHolder parameterHolder;
        final List<ITestResult> errorResults = Lists.newArrayList();

        public ParameterBag(ParameterHolder params, TestResult tr) {
            this.parameterHolder = params;
            if (tr != null) {
                this.errorResults.add(tr);
            }
        }

        public boolean hasErrors() {
            return !this.errorResults.isEmpty();
        }
    }
}

