/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import junit.framework.Assert;
import org.dbunit.IDatabaseTester;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;

public abstract class AbstractDatabaseTester
implements IDatabaseTester {
    private IDataSet dataSet;
    private String schema;
    private DatabaseOperation setUpOperation = DatabaseOperation.CLEAN_INSERT;
    private DatabaseOperation tearDownOperation = DatabaseOperation.NONE;

    public void closeConnection(IDatabaseConnection connection) throws Exception {
        connection.close();
    }

    public IDataSet getDataSet() {
        return this.dataSet;
    }

    public void onSetup() throws Exception {
        this.executeOperation(this.getSetUpOperation());
    }

    public void onTearDown() throws Exception {
        this.executeOperation(this.getTearDownOperation());
    }

    public void setDataSet(IDataSet dataSet) {
        this.dataSet = dataSet;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setSetUpOperation(DatabaseOperation setUpOperation) {
        this.setUpOperation = setUpOperation;
    }

    public void setTearDownOperation(DatabaseOperation tearDownOperation) {
        this.tearDownOperation = tearDownOperation;
    }

    protected void assertNotNullNorEmpty(String propertyName, String property) {
        Assert.assertNotNull((String)(propertyName + " is null"), (Object)property);
        Assert.assertTrue((String)("Invalid " + propertyName), (property.trim().length() > 0 ? 1 : 0) != 0);
    }

    protected String getSchema() {
        return this.schema;
    }

    protected DatabaseOperation getSetUpOperation() {
        return this.setUpOperation;
    }

    protected DatabaseOperation getTearDownOperation() {
        return this.tearDownOperation;
    }

    private void executeOperation(DatabaseOperation operation) throws Exception {
        if (operation != DatabaseOperation.NONE) {
            IDatabaseConnection connection = this.getConnection();
            try {
                operation.execute(connection, this.getDataSet());
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.closeConnection(connection);
                throw throwable;
            }
            this.closeConnection(connection);
            {
            }
        }
    }

    public abstract IDatabaseConnection getConnection() throws Exception;
}

