/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.dbunit.AbstractDatabaseTester;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;

public class JndiDatabaseTester
extends AbstractDatabaseTester {
    private DataSource dataSource;
    private Properties environment;
    private boolean initialized = false;
    private String lookupName;
    static /* synthetic */ Class class$javax$sql$DataSource;

    public JndiDatabaseTester(Properties environment, String lookupName) {
        this.environment = environment;
        this.lookupName = lookupName;
    }

    public JndiDatabaseTester(String lookupName) {
        this(null, lookupName);
    }

    public IDatabaseConnection getConnection() throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        return new DatabaseConnection(this.dataSource.getConnection());
    }

    private void initialize() throws NamingException {
        InitialContext context = new InitialContext(this.environment);
        this.assertNotNullNorEmpty("lookupName", this.lookupName);
        Object obj = context.lookup(this.lookupName);
        Assert.assertNotNull((String)("JNDI object with [" + this.lookupName + "] not found"), (Object)obj);
        Assert.assertTrue((String)("Object [" + obj + "] at JNDI location [" + this.lookupName + "] is not of type [" + (class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = JndiDatabaseTester.class$("javax.sql.DataSource")) : class$javax$sql$DataSource).getName() + "]"), (boolean)(obj instanceof DataSource));
        this.dataSource = (DataSource)obj;
        Assert.assertNotNull((String)"DataSource is not set", (Object)this.dataSource);
        this.initialized = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

