/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;

public class PrimaryKeyFilteredTableWrapper
implements ITable {
    private final ITable originalTable;
    private final List filteredRowsMapping;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public PrimaryKeyFilteredTableWrapper(ITable table, Set allowedPKs) throws DataSetException {
        if (table == null || allowedPKs == null) {
            throw new IllegalArgumentException("Constructor cannot receive null arguments");
        }
        this.originalTable = table;
        this.filteredRowsMapping = this.setRows(allowedPKs);
    }

    private List setRows(Set allowedPKs) throws DataSetException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting rows for table " + this.originalTable.getTableMetaData().getTableName()));
        }
        int allowedSize = allowedPKs.size();
        int fullSize = this.originalTable.getRowCount();
        ArrayList<Integer> mapping = new ArrayList<Integer>(allowedSize);
        String pkColumn = this.originalTable.getTableMetaData().getPrimaryKeys()[0].getColumnName();
        int row = 0;
        while (row < fullSize) {
            Object pk = this.originalTable.getValue(row, pkColumn);
            if (allowedPKs.contains(pk)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Adding row " + row + " (pk=" + pk + ")"));
                }
                mapping.add(new Integer(row));
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Discarding row " + row + " (pk=" + pk + ")"));
            }
            ++row;
        }
        return mapping;
    }

    public ITableMetaData getTableMetaData() {
        return this.originalTable.getTableMetaData();
    }

    public int getRowCount() {
        return this.filteredRowsMapping.size();
    }

    public Object getValue(int row, String column) throws DataSetException {
        int max = this.filteredRowsMapping.size();
        if (row < max) {
            int realRow = (Integer)this.filteredRowsMapping.get(row);
            Object value = this.originalTable.getValue(realRow, column);
            return value;
        }
        throw new RowOutOfBoundsException("tried to access row " + row + " but rowCount is " + max);
    }
}

