/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;

public abstract class AbstractDataSet
implements IDataSet {
    protected ITable[] cloneTables(ITable[] tables) {
        ITable[] clones = new ITable[tables.length];
        int i = 0;
        while (i < tables.length) {
            clones[i] = tables[i];
            ++i;
        }
        return clones;
    }

    protected abstract ITableIterator createIterator(boolean var1) throws DataSetException;

    public String[] getTableNames() throws DataSetException {
        ArrayList<String> tableNameList = new ArrayList<String>();
        ITableIterator iterator = this.createIterator(false);
        while (iterator.next()) {
            tableNameList.add(iterator.getTableMetaData().getTableName());
        }
        return tableNameList.toArray(new String[0]);
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        return this.getTable(tableName).getTableMetaData();
    }

    public ITable getTable(String tableName) throws DataSetException {
        ITable found = null;
        ITableIterator iterator = this.createIterator(false);
        while (iterator.next()) {
            ITable table = iterator.getTable();
            if (!tableName.equalsIgnoreCase(table.getTableMetaData().getTableName())) continue;
            if (found != null) {
                throw new AmbiguousTableNameException(tableName);
            }
            found = table;
        }
        if (found != null) {
            return found;
        }
        throw new NoSuchTableException(tableName);
    }

    public ITable[] getTables() throws DataSetException {
        ArrayList<ITable> tableList = new ArrayList<ITable>();
        ITableIterator iterator = this.createIterator(false);
        while (iterator.next()) {
            tableList.add(iterator.getTable());
        }
        return tableList.toArray(new ITable[0]);
    }

    public ITableIterator iterator() throws DataSetException {
        return this.createIterator(false);
    }

    public ITableIterator reverseIterator() throws DataSetException {
        return this.createIterator(true);
    }

    public String toString() {
        try {
            return Arrays.asList(this.getTableNames()).toString();
        }
        catch (DataSetException e) {
            return super.toString();
        }
    }
}

