/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.CompositeTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.dataset.filter.PatternMatcher;

public class DefaultColumnFilter
implements IColumnFilter {
    private final PatternMatcher _includeMatcher = new PatternMatcher();
    private final PatternMatcher _excludeMatcher = new PatternMatcher();

    public void includeColumn(String columnPattern) {
        this._includeMatcher.addPattern(columnPattern);
    }

    public void includeColumns(Column[] columns) {
        int i = 0;
        while (i < columns.length) {
            this._includeMatcher.addPattern(columns[i].getColumnName());
            ++i;
        }
    }

    public void excludeColumn(String columnPattern) {
        this._excludeMatcher.addPattern(columnPattern);
    }

    public void excludeColumns(Column[] columns) {
        int i = 0;
        while (i < columns.length) {
            this._excludeMatcher.addPattern(columns[i].getColumnName());
            ++i;
        }
    }

    public static ITable includedColumnsTable(ITable table, String[] columnNames) throws DataSetException {
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        int i = 0;
        while (i < columnNames.length) {
            String columnName = columnNames[i];
            columnFilter.includeColumn(columnName);
            ++i;
        }
        FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), columnFilter);
        return new CompositeTable((ITableMetaData)metaData, table);
    }

    public static ITable includedColumnsTable(ITable table, Column[] columns) throws DataSetException {
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        columnFilter.includeColumns(columns);
        FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), columnFilter);
        return new CompositeTable((ITableMetaData)metaData, table);
    }

    public static ITable excludedColumnsTable(ITable table, String[] columnNames) throws DataSetException {
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        int i = 0;
        while (i < columnNames.length) {
            String columnName = columnNames[i];
            columnFilter.excludeColumn(columnName);
            ++i;
        }
        FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), columnFilter);
        return new CompositeTable((ITableMetaData)metaData, table);
    }

    public static ITable excludedColumnsTable(ITable table, Column[] columns) throws DataSetException {
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        columnFilter.excludeColumns(columns);
        FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), columnFilter);
        return new CompositeTable((ITableMetaData)metaData, table);
    }

    public boolean accept(String tableName, Column column) {
        if (this._includeMatcher.isEmpty() || this._includeMatcher.accept(column.getColumnName())) {
            return !this._excludeMatcher.accept(column.getColumnName());
        }
        return false;
    }
}

